/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.data.engine.rest.internal.security.permission.resource.util;

import com.liferay.data.engine.content.type.DataDefinitionContentType;
import com.liferay.data.engine.rest.internal.content.type.DataDefinitionContentTypeRegistryUtil;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.util.PortalUtil;

public class DataDefinitionPermissionUtil {
    public static void check(PermissionChecker permissionChecker, DDMStructure ddmStructure, String actionId) throws PortalException {
        if (!DataDefinitionPermissionUtil.contains(permissionChecker, ddmStructure, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, DataDefinitionPermissionUtil._getModelResourceName(ddmStructure), ddmStructure.getStructureId(), new String[]{actionId});
        }
    }

    public static void checkPortletPermission(PermissionChecker permissionChecker, DDMStructure ddmStructure, String actionId) throws PortalException {
        DataDefinitionPermissionUtil._checkPortletPermission(permissionChecker, DataDefinitionContentTypeRegistryUtil.getDataDefinitionContentType(ddmStructure.getClassNameId()), ddmStructure.getGroupId(), actionId);
    }

    public static void checkPortletPermission(PermissionChecker permissionChecker, String contentType, long groupId, String actionId) throws Exception {
        DataDefinitionPermissionUtil._checkPortletPermission(permissionChecker, DataDefinitionContentTypeRegistryUtil.getDataDefinitionContentType(contentType), groupId, actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, DDMStructure ddmStructure, String actionId) throws PortalException {
        DataDefinitionContentType dataDefinitionContentType = DataDefinitionContentTypeRegistryUtil.getDataDefinitionContentType(ddmStructure.getClassNameId());
        if (dataDefinitionContentType == null) {
            return false;
        }
        return dataDefinitionContentType.hasPermission(permissionChecker, ddmStructure.getCompanyId(), ddmStructure.getGroupId(), DataDefinitionPermissionUtil._getModelResourceName(ddmStructure), ddmStructure.getStructureId(), ddmStructure.getUserId(), actionId);
    }

    private static void _checkPortletPermission(PermissionChecker permissionChecker, DataDefinitionContentType dataDefinitionContentType, long groupId, String actionId) throws PortalException {
        if (dataDefinitionContentType == null) {
            throw new PrincipalException.MustHavePermission(permissionChecker, new String[]{actionId});
        }
        if (!dataDefinitionContentType.hasPortletPermission(permissionChecker, groupId, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, dataDefinitionContentType.getContentType(), groupId, new String[]{actionId});
        }
    }

    private static String _getModelResourceName(DDMStructure ddmStructure) {
        return ResourceActionsUtil.getCompositeModelName((String[])new String[]{PortalUtil.getClassName((long)ddmStructure.getClassNameId()), DDMStructure.class.getName()});
    }
}

