/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.data.engine.rest.internal.security.permission.resource.util;

import com.liferay.data.engine.content.type.DataDefinitionContentType;
import com.liferay.data.engine.rest.internal.content.type.DataDefinitionContentTypeRegistryUtil;
import com.liferay.dynamic.data.lists.model.DDLRecordSet;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.util.PortalUtil;

public class DataRecordCollectionPermissionUtil {
    public static void check(PermissionChecker permissionChecker, DDLRecordSet ddlRecordSet, String actionId) throws PortalException {
        if (!DataRecordCollectionPermissionUtil.contains(permissionChecker, ddlRecordSet, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, DataRecordCollectionPermissionUtil._getModelResourceName(ddlRecordSet), ddlRecordSet.getRecordSetId(), new String[]{actionId});
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, DDLRecordSet ddlRecordSet, String actionId) throws PortalException {
        DDMStructure ddmStructure = ddlRecordSet.getDDMStructure();
        DataDefinitionContentType dataDefinitionContentType = DataDefinitionContentTypeRegistryUtil.getDataDefinitionContentType(ddmStructure.getClassNameId());
        if (dataDefinitionContentType == null) {
            return false;
        }
        return dataDefinitionContentType.hasPermission(permissionChecker, ddlRecordSet.getCompanyId(), ddlRecordSet.getGroupId(), DataRecordCollectionPermissionUtil._getModelResourceName(ddlRecordSet), ddlRecordSet.getRecordSetId(), ddlRecordSet.getUserId(), actionId);
    }

    private static String _getModelResourceName(DDLRecordSet ddlRecordSet) throws PortalException {
        DDMStructure ddmStructure = ddlRecordSet.getDDMStructure();
        return ResourceActionsUtil.getCompositeModelName((String[])new String[]{PortalUtil.getClassName((long)ddmStructure.getClassNameId()), DDLRecordSet.class.getName()});
    }
}

