/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.data.engine.rest.internal.security.permission.resource.util;

import com.liferay.data.engine.content.type.DataDefinitionContentType;
import com.liferay.data.engine.rest.internal.content.type.DataDefinitionContentTypeRegistryUtil;
import com.liferay.data.engine.rest.internal.security.permission.resource.util.DataRecordCollectionPermissionUtil;
import com.liferay.dynamic.data.lists.model.DDLRecord;
import com.liferay.dynamic.data.lists.model.DDLRecordSet;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.util.PortalUtil;

public class DataRecordPermissionUtil {
    public static void check(PermissionChecker permissionChecker, DDLRecord ddlRecord, String actionId) throws PortalException {
        if (!DataRecordPermissionUtil.contains(permissionChecker, ddlRecord, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, DataRecordPermissionUtil._getModelResourceName(ddlRecord), ddlRecord.getRecordId(), new String[]{actionId});
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, DDLRecord ddlRecord, String actionId) throws PortalException {
        DDLRecordSet recordSet = ddlRecord.getRecordSet();
        boolean hasPermission = DataRecordCollectionPermissionUtil.contains(permissionChecker, recordSet, actionId);
        if (hasPermission) {
            return true;
        }
        DDMStructure ddmStructure = recordSet.getDDMStructure();
        DataDefinitionContentType dataDefinitionContentType = DataDefinitionContentTypeRegistryUtil.getDataDefinitionContentType(ddmStructure.getClassNameId());
        if (dataDefinitionContentType == null) {
            return false;
        }
        return dataDefinitionContentType.hasPermission(permissionChecker, ddlRecord.getCompanyId(), ddlRecord.getGroupId(), DataRecordPermissionUtil._getModelResourceName(ddlRecord), ddlRecord.getRecordId(), ddlRecord.getUserId(), actionId);
    }

    private static String _getModelResourceName(DDLRecord ddlRecord) throws PortalException {
        DDLRecordSet recordSet = ddlRecord.getRecordSet();
        DDMStructure ddmStructure = recordSet.getDDMStructure();
        return ResourceActionsUtil.getCompositeModelName((String[])new String[]{PortalUtil.getClassName((long)ddmStructure.getClassNameId()), DDLRecord.class.getName()});
    }
}

