/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.data.engine.rest.internal.strategy;

import com.liferay.data.engine.rest.internal.strategy.MapToDDMFormValuesConverterStrategy;
import com.liferay.data.engine.rest.strategy.util.DataRecordValueKeyUtil;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.model.UnlocalizedValue;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.util.DDMFormFieldParameterNameUtil;
import com.liferay.dynamic.data.mapping.util.DDMFormValuesFactoryUtil;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class DefaultMapToDDMFormValuesConverterStrategy
implements MapToDDMFormValuesConverterStrategy {
    private static final DefaultMapToDDMFormValuesConverterStrategy _defaultMapToDDMFormValuesConverterStrategy = new DefaultMapToDDMFormValuesConverterStrategy();

    public static DefaultMapToDDMFormValuesConverterStrategy getInstance() {
        return _defaultMapToDDMFormValuesConverterStrategy;
    }

    @Override
    public void setDDMFormFieldValues(Map<String, Object> dataRecordValues, DDMForm ddmForm, DDMFormValues ddmFormValues, Locale locale) {
        HashMap<String, DDMFormFieldValue> ddmFormFieldValues = new HashMap<String, DDMFormFieldValue>();
        this._createDDMFormFieldValues(dataRecordValues, ddmForm.getDDMFormFields(), ddmFormFieldValues, ddmForm.getDefaultLocale(), locale, "");
        ddmFormValues.setDDMFormFieldValues(DDMFormValuesFactoryUtil.getDDMFormFieldValues(ddmFormFieldValues, (List)ddmForm.getDDMFormFields()));
    }

    private DefaultMapToDDMFormValuesConverterStrategy() {
    }

    private void _addString(Locale locale, Object object, Value value) {
        if (object == null) {
            value.addString(locale, null);
        } else if (object instanceof List) {
            value.addString(locale, JSONFactoryUtil.looseSerializeDeep((Object)object));
        } else {
            value.addString(locale, String.valueOf(object));
        }
    }

    private void _createDDMFormFieldValues(Map<String, Object> dataRecordValues, final DDMFormField ddmFormField, Map<String, DDMFormFieldValue> ddmFormFieldValues, Locale defaultLocale, Locale locale, String parentDataRecordValueKey) {
        boolean hasDataRecordValue = false;
        for (Map.Entry<String, Object> entry : dataRecordValues.entrySet()) {
            String dataRecordValueKey = entry.getKey();
            final String[] dataRecordValueKeyParts = DDMFormFieldParameterNameUtil.getLastDDMFormFieldParameterNameParts((String)dataRecordValueKey);
            final String dataRecordValueFieldName = dataRecordValueKeyParts[0];
            if (!this._isDataRecordValueFromDDMFormField(dataRecordValueFieldName, dataRecordValueKey, ddmFormField.getName(), parentDataRecordValueKey)) continue;
            DDMFormFieldValue ddmFormFieldValue = new DDMFormFieldValue(){
                {
                    this.setInstanceId(dataRecordValueKeyParts[1]);
                    this.setName(dataRecordValueFieldName);
                }
            };
            if (entry.getValue() != null && ddmFormField.isLocalizable() && !ddmFormField.isTransient()) {
                LocalizedValue value = new LocalizedValue();
                Map localizedValues = (Map)entry.getValue();
                if (locale == null) {
                    for (Map.Entry localizedValue : localizedValues.entrySet()) {
                        this._addString(LocaleUtil.fromLanguageId((String)((String)localizedValue.getKey())), localizedValues.get(localizedValue.getKey()), (Value)value);
                    }
                } else {
                    this._addString(locale, GetterUtil.getObject(localizedValues.get(LocaleUtil.toLanguageId((Locale)locale)), localizedValues.get(LocaleUtil.toLanguageId((Locale)defaultLocale))), (Value)value);
                }
                ddmFormFieldValue.setValue((Value)value);
            } else if (entry.getValue() != null) {
                ddmFormFieldValue.setValue((Value)new UnlocalizedValue((String)entry.getValue()));
            }
            ddmFormFieldValues.put(dataRecordValueKey, ddmFormFieldValue);
            if (ListUtil.isNotEmpty((List)ddmFormField.getNestedDDMFormFields())) {
                this._createDDMFormFieldValues(dataRecordValues, ddmFormField.getNestedDDMFormFields(), ddmFormFieldValues, defaultLocale, locale, dataRecordValueKey);
            }
            hasDataRecordValue = true;
        }
        if (hasDataRecordValue) {
            return;
        }
        DDMFormFieldValue ddmFormFieldValue = new DDMFormFieldValue(){
            {
                this.setName(ddmFormField.getName());
            }
        };
        String dataRecordValueKey = DataRecordValueKeyUtil.createDataRecordValueKey((String)ddmFormField.getName(), (String)ddmFormFieldValue.getInstanceId(), (String)parentDataRecordValueKey, (int)0);
        ddmFormFieldValues.put(dataRecordValueKey, ddmFormFieldValue);
        if (ListUtil.isNotEmpty((List)ddmFormField.getNestedDDMFormFields())) {
            this._createDDMFormFieldValues(dataRecordValues, ddmFormField.getNestedDDMFormFields(), ddmFormFieldValues, defaultLocale, locale, dataRecordValueKey);
        }
    }

    private void _createDDMFormFieldValues(Map<String, Object> dataRecordValues, List<DDMFormField> ddmFormFields, Map<String, DDMFormFieldValue> ddmFormFieldValues, Locale defaultLocale, Locale locale, String parentDataRecordValueKey) {
        for (DDMFormField ddmFormField : ddmFormFields) {
            this._createDDMFormFieldValues(dataRecordValues, ddmFormField, ddmFormFieldValues, defaultLocale, locale, parentDataRecordValueKey);
        }
    }

    private boolean _isDataRecordValueFromDDMFormField(String dataRecordValueFieldName, String dataRecordValueKey, String ddmFormFieldName, String parentDataRecordValueKey) {
        return StringUtil.equals((String)ddmFormFieldName, (String)dataRecordValueFieldName) && (Validator.isNull((String)parentDataRecordValueKey) || dataRecordValueKey.contains(parentDataRecordValueKey));
    }
}

