/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.data.engine.rest.internal.content.type;

import com.liferay.data.engine.content.type.DataDefinitionContentType;
import com.liferay.data.engine.rest.resource.exception.DataDefinitionValidationException;
import com.liferay.portal.kernel.util.MapUtil;
import java.util.Map;
import java.util.TreeMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(service={DataDefinitionContentTypeRegistry.class})
public class DataDefinitionContentTypeRegistry {
    private final Map<String, Long> _classNameIds = new TreeMap<String, Long>();
    private final Map<Long, DataDefinitionContentType> _dataDefinitionContentTypesByClassNameId = new TreeMap<Long, DataDefinitionContentType>();
    private final Map<String, DataDefinitionContentType> _dataDefinitionContentTypesByContentType = new TreeMap<String, DataDefinitionContentType>();

    public Long getClassNameId(String contentType) throws Exception {
        Long id = this._classNameIds.get(contentType);
        if (id == null) {
            throw new DataDefinitionValidationException.MustSetValidContentType(contentType);
        }
        return id;
    }

    public DataDefinitionContentType getDataDefinitionContentType(long classNameId) {
        return this._dataDefinitionContentTypesByClassNameId.get(classNameId);
    }

    public DataDefinitionContentType getDataDefinitionContentType(String contentType) throws Exception {
        DataDefinitionContentType dataDefinitionContentType = this._dataDefinitionContentTypesByContentType.get(contentType);
        if (dataDefinitionContentType == null) {
            throw new DataDefinitionValidationException.MustSetValidContentType(contentType);
        }
        return dataDefinitionContentType;
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void addDataDefinitionContentType(DataDefinitionContentType dataDefinitionContentType, Map<String, Object> properties) {
        if (!properties.containsKey("content.type")) {
            return;
        }
        String contentType = MapUtil.getString(properties, (String)"content.type");
        this._classNameIds.put(contentType, dataDefinitionContentType.getClassNameId());
        this._dataDefinitionContentTypesByClassNameId.put(dataDefinitionContentType.getClassNameId(), dataDefinitionContentType);
        this._dataDefinitionContentTypesByContentType.put(contentType, dataDefinitionContentType);
    }

    @Deactivate
    protected void deactivate() {
        this._dataDefinitionContentTypesByContentType.clear();
    }

    protected void removeDataDefinitionContentType(DataDefinitionContentType dataDefinitionContentType, Map<String, Object> properties) {
        String contentType = MapUtil.getString(properties, (String)"content.type");
        this._dataDefinitionContentTypesByClassNameId.remove(this._classNameIds.get(contentType));
        this._classNameIds.remove(contentType);
        this._dataDefinitionContentTypesByContentType.remove(contentType);
    }
}

