/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.data.engine.rest.internal.renderer.v2_0;

import com.liferay.data.engine.renderer.DataLayoutRenderer;
import com.liferay.data.engine.renderer.DataLayoutRendererContext;
import com.liferay.data.engine.rest.internal.dto.v2_0.util.MapToDDMFormValuesConverterUtil;
import com.liferay.dynamic.data.mapping.form.renderer.DDMFormRenderer;
import com.liferay.dynamic.data.mapping.form.renderer.DDMFormRenderingContext;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMStructureLayout;
import com.liferay.dynamic.data.mapping.model.DDMStructureVersion;
import com.liferay.dynamic.data.mapping.service.DDMStructureLayoutLocalService;
import com.liferay.dynamic.data.mapping.service.DDMStructureVersionLocalService;
import com.liferay.portal.kernel.security.auth.GuestOrUserUtil;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={DataLayoutRenderer.class})
public class DataLayoutRendererImpl
implements DataLayoutRenderer {
    @Reference
    private DDMFormRenderer _ddmFormRenderer;
    @Reference
    private DDMStructureLayoutLocalService _ddmStructureLayoutLocalService;
    @Reference(target="(model.class.name=com.liferay.dynamic.data.mapping.model.DDMStructure)")
    private ModelResourcePermission<DDMStructure> _ddmStructureModelResourcePermission;
    @Reference
    private DDMStructureVersionLocalService _ddmStructureVersionLocalService;
    @Reference
    private Portal _portal;

    public String render(Long dataLayoutId, DataLayoutRendererContext dataLayoutRendererContext) throws Exception {
        DDMStructureLayout ddmStructureLayout = this._ddmStructureLayoutLocalService.getStructureLayout(dataLayoutId.longValue());
        DDMStructureVersion ddmStructureVersion = this._ddmStructureVersionLocalService.getDDMStructureVersion(ddmStructureLayout.getStructureVersionId());
        DDMStructure ddmStructure = ddmStructureVersion.getStructure();
        this._ddmStructureModelResourcePermission.check(GuestOrUserUtil.getPermissionChecker(), ddmStructure.getPrimaryKey(), "VIEW");
        DDMForm ddmForm = ddmStructure.getDDMForm();
        long groupId = ParamUtil.getLong((HttpServletRequest)dataLayoutRendererContext.getHttpServletRequest(), (String)"groupId", (long)ddmStructure.getGroupId());
        return this._ddmFormRenderer.render(ddmForm, ddmStructureLayout.getDDMFormLayout(), this._toDDMFormRenderingContext(dataLayoutId, dataLayoutRendererContext, ddmForm, groupId));
    }

    private DDMFormRenderingContext _toDDMFormRenderingContext(Long dataLayoutId, DataLayoutRendererContext dataLayoutRendererContext, DDMForm ddmForm, long groupId) throws Exception {
        DDMFormRenderingContext ddmFormRenderingContext = new DDMFormRenderingContext();
        if (Validator.isNotNull((String)dataLayoutRendererContext.getDefaultLanguageId())) {
            ddmFormRenderingContext.addProperty("defaultLanguageId", (Object)dataLayoutRendererContext.getDefaultLanguageId());
        }
        ddmFormRenderingContext.addProperty("persistDefaultValues", (Object)dataLayoutRendererContext.isPersistDefaultValues());
        ddmFormRenderingContext.addProperty("persisted", (Object)dataLayoutRendererContext.isPersisted());
        ddmFormRenderingContext.setContainerId(dataLayoutRendererContext.getContainerId());
        ddmFormRenderingContext.setDDMFormValues(MapToDDMFormValuesConverterUtil.toDDMFormValues(dataLayoutRendererContext.getDataRecordValues(), ddmForm, null));
        ddmFormRenderingContext.setDDMStructureLayoutId(dataLayoutId.longValue());
        ddmFormRenderingContext.setGroupId(groupId);
        ddmFormRenderingContext.setEditOnlyInDefaultLanguage(true);
        ddmFormRenderingContext.setHttpServletRequest(dataLayoutRendererContext.getHttpServletRequest());
        ddmFormRenderingContext.setHttpServletResponse(dataLayoutRendererContext.getHttpServletResponse());
        Locale locale = null;
        String languageId = ParamUtil.get((HttpServletRequest)dataLayoutRendererContext.getHttpServletRequest(), (String)"languageId", (String)dataLayoutRendererContext.getLanguageId());
        locale = Validator.isNull((String)languageId) ? ddmForm.getDefaultLocale() : LocaleUtil.fromLanguageId((String)languageId);
        ddmFormRenderingContext.setLocale(locale);
        ddmFormRenderingContext.setPortletNamespace(dataLayoutRendererContext.getPortletNamespace());
        ddmFormRenderingContext.setReadOnly(dataLayoutRendererContext.isReadOnly());
        ddmFormRenderingContext.setShowSubmitButton(false);
        ddmFormRenderingContext.setSubmittable(dataLayoutRendererContext.isSubmittable());
        ddmFormRenderingContext.setViewMode(true);
        return ddmFormRenderingContext;
    }
}

