/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.data.engine.rest.internal.resource.v2_0;

import com.liferay.data.engine.rest.dto.v2_0.DataDefinition;
import com.liferay.data.engine.rest.resource.v2_0.DataDefinitionResource;
import com.liferay.petra.function.UnsafeBiConsumer;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.model.ResourceAction;
import com.liferay.portal.kernel.model.ResourcePermission;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ResourceActionLocalService;
import com.liferay.portal.kernel.service.ResourceLocalServiceUtil;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.odata.filter.ExpressionConvert;
import com.liferay.portal.odata.filter.Filter;
import com.liferay.portal.odata.filter.FilterParser;
import com.liferay.portal.odata.filter.FilterParserProvider;
import com.liferay.portal.odata.sort.SortField;
import com.liferay.portal.odata.sort.SortParser;
import com.liferay.portal.odata.sort.SortParserProvider;
import com.liferay.portal.vulcan.accept.language.AcceptLanguage;
import com.liferay.portal.vulcan.batch.engine.VulcanBatchEngineTaskItemDelegate;
import com.liferay.portal.vulcan.batch.engine.resource.VulcanBatchEngineImportTaskResource;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.permission.ModelPermissionsUtil;
import com.liferay.portal.vulcan.permission.Permission;
import com.liferay.portal.vulcan.permission.PermissionUtil;
import com.liferay.portal.vulcan.resource.EntityModelResource;
import com.liferay.portal.vulcan.util.ActionUtil;
import com.liferay.portal.vulcan.util.TransformUtil;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.NotSupportedException;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="/v2.0")
public abstract class BaseDataDefinitionResourceImpl
implements DataDefinitionResource,
EntityModelResource,
VulcanBatchEngineTaskItemDelegate<DataDefinition> {
    protected AcceptLanguage contextAcceptLanguage;
    protected UnsafeBiConsumer<Collection<DataDefinition>, UnsafeConsumer<DataDefinition, Exception>, Exception> contextBatchUnsafeConsumer;
    protected Company contextCompany;
    protected HttpServletRequest contextHttpServletRequest;
    protected HttpServletResponse contextHttpServletResponse;
    protected Object contextScopeChecker;
    protected UriInfo contextUriInfo;
    protected User contextUser;
    protected ExpressionConvert<com.liferay.portal.kernel.search.filter.Filter> expressionConvert;
    protected FilterParserProvider filterParserProvider;
    protected GroupLocalService groupLocalService;
    protected ResourceActionLocalService resourceActionLocalService;
    protected ResourcePermissionLocalService resourcePermissionLocalService;
    protected RoleLocalService roleLocalService;
    protected SortParserProvider sortParserProvider;
    protected VulcanBatchEngineImportTaskResource vulcanBatchEngineImportTaskResource;
    private static final Log _log = LogFactoryUtil.getLog(BaseDataDefinitionResourceImpl.class);

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="contentType"), @Parameter(in=ParameterIn.QUERY, name="keywords"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize"), @Parameter(in=ParameterIn.QUERY, name="sort")})
    @Tags(value={@Tag(name="DataDefinition")})
    @GET
    @Path(value="/data-definitions/by-content-type/{contentType}")
    @Produces(value={"application/json", "application/xml"})
    public Page<DataDefinition> getDataDefinitionByContentTypeContentTypePage(@Parameter(hidden=true) @NotNull @PathParam(value="contentType") String contentType, @Parameter(hidden=true) @QueryParam(value="keywords") String keywords, @Context Pagination pagination, @Context Sort[] sorts) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="contentType")})
    @Tags(value={@Tag(name="DataDefinition")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/data-definitions/by-content-type/{contentType}")
    @POST
    @Produces(value={"application/json", "application/xml"})
    public DataDefinition postDataDefinitionByContentType(@Parameter(hidden=true) @NotNull @PathParam(value="contentType") String contentType, DataDefinition dataDefinition) throws Exception {
        return new DataDefinition();
    }

    @Tags(value={@Tag(name="DataDefinition")})
    @GET
    @Path(value="/data-definitions/data-definition-fields/field-types")
    @Produces(value={"application/json", "application/xml"})
    public String getDataDefinitionDataDefinitionFieldFieldTypes() throws Exception {
        return "";
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="dataDefinitionId")})
    @Tags(value={@Tag(name="DataDefinition")})
    @DELETE
    @Path(value="/data-definitions/{dataDefinitionId}")
    @Produces(value={"application/json", "application/xml"})
    public void deleteDataDefinition(@Parameter(hidden=true) @NotNull @PathParam(value="dataDefinitionId") Long dataDefinitionId) throws Exception {
    }

    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Tags(value={@Tag(name="DataDefinition")})
    @Consumes(value={"application/json"})
    @DELETE
    @Path(value="/data-definitions/batch")
    @Produces(value={"application/json"})
    public Response deleteDataDefinitionBatch(@Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.deleteImportTask(DataDefinition.class.getName(), callbackURL, object)).build();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="dataDefinitionId")})
    @Tags(value={@Tag(name="DataDefinition")})
    @GET
    @Path(value="/data-definitions/{dataDefinitionId}")
    @Produces(value={"application/json", "application/xml"})
    public DataDefinition getDataDefinition(@Parameter(hidden=true) @NotNull @PathParam(value="dataDefinitionId") Long dataDefinitionId) throws Exception {
        return new DataDefinition();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="dataDefinitionId")})
    @Tags(value={@Tag(name="DataDefinition")})
    @Consumes(value={"application/json", "application/xml"})
    @PATCH
    @Path(value="/data-definitions/{dataDefinitionId}")
    @Produces(value={"application/json", "application/xml"})
    public DataDefinition patchDataDefinition(@Parameter(hidden=true) @NotNull @PathParam(value="dataDefinitionId") Long dataDefinitionId, DataDefinition dataDefinition) throws Exception {
        DataDefinition existingDataDefinition = this.getDataDefinition(dataDefinitionId);
        if (dataDefinition.getAvailableLanguageIds() != null) {
            existingDataDefinition.setAvailableLanguageIds(dataDefinition.getAvailableLanguageIds());
        }
        if (dataDefinition.getContentType() != null) {
            existingDataDefinition.setContentType(dataDefinition.getContentType());
        }
        if (dataDefinition.getDataDefinitionKey() != null) {
            existingDataDefinition.setDataDefinitionKey(dataDefinition.getDataDefinitionKey());
        }
        if (dataDefinition.getDateCreated() != null) {
            existingDataDefinition.setDateCreated(dataDefinition.getDateCreated());
        }
        if (dataDefinition.getDateModified() != null) {
            existingDataDefinition.setDateModified(dataDefinition.getDateModified());
        }
        if (dataDefinition.getDefaultLanguageId() != null) {
            existingDataDefinition.setDefaultLanguageId(dataDefinition.getDefaultLanguageId());
        }
        if (dataDefinition.getDescription() != null) {
            existingDataDefinition.setDescription(dataDefinition.getDescription());
        }
        if (dataDefinition.getName() != null) {
            existingDataDefinition.setName(dataDefinition.getName());
        }
        if (dataDefinition.getSiteId() != null) {
            existingDataDefinition.setSiteId(dataDefinition.getSiteId());
        }
        if (dataDefinition.getStorageType() != null) {
            existingDataDefinition.setStorageType(dataDefinition.getStorageType());
        }
        if (dataDefinition.getUserId() != null) {
            existingDataDefinition.setUserId(dataDefinition.getUserId());
        }
        this.preparePatch(dataDefinition, existingDataDefinition);
        return this.putDataDefinition(dataDefinitionId, existingDataDefinition);
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="dataDefinitionId")})
    @Tags(value={@Tag(name="DataDefinition")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/data-definitions/{dataDefinitionId}")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    public DataDefinition putDataDefinition(@Parameter(hidden=true) @NotNull @PathParam(value="dataDefinitionId") Long dataDefinitionId, DataDefinition dataDefinition) throws Exception {
        return new DataDefinition();
    }

    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Tags(value={@Tag(name="DataDefinition")})
    @Consumes(value={"application/json"})
    @Path(value="/data-definitions/batch")
    @Produces(value={"application/json"})
    @PUT
    public Response putDataDefinitionBatch(@Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.putImportTask(DataDefinition.class.getName(), callbackURL, object)).build();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="dataDefinitionId")})
    @Tags(value={@Tag(name="DataDefinition")})
    @Path(value="/data-definitions/{dataDefinitionId}/copy")
    @POST
    @Produces(value={"application/json", "application/xml"})
    public DataDefinition postDataDefinitionCopy(@Parameter(hidden=true) @NotNull @PathParam(value="dataDefinitionId") Long dataDefinitionId) throws Exception {
        return new DataDefinition();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="dataDefinitionId"), @Parameter(in=ParameterIn.QUERY, name="roleNames")})
    @Tags(value={@Tag(name="DataDefinition")})
    @GET
    @Path(value="/data-definitions/{dataDefinitionId}/permissions")
    @Produces(value={"application/json", "application/xml"})
    public Page<Permission> getDataDefinitionPermissionsPage(@Parameter(hidden=true) @NotNull @PathParam(value="dataDefinitionId") Long dataDefinitionId, @Parameter(hidden=true) @QueryParam(value="roleNames") String roleNames) throws Exception {
        String resourceName = this.getPermissionCheckerResourceName(dataDefinitionId);
        Long resourceId = this.getPermissionCheckerResourceId(dataDefinitionId);
        PermissionUtil.checkPermission((String)"PERMISSIONS", (GroupLocalService)this.groupLocalService, (String)resourceName, (long)resourceId, (Long)this.getPermissionCheckerGroupId(dataDefinitionId));
        return this.toPermissionPage(HashMapBuilder.put((Object)"get", this.addAction("PERMISSIONS", "getDataDefinitionPermissionsPage", resourceName, resourceId)).put((Object)"replace", this.addAction("PERMISSIONS", "putDataDefinitionPermissionsPage", resourceName, resourceId)).build(), resourceId, resourceName, roleNames);
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="dataDefinitionId")})
    @Tags(value={@Tag(name="DataDefinition")})
    @Path(value="/data-definitions/{dataDefinitionId}/permissions")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    public Page<Permission> putDataDefinitionPermissionsPage(@Parameter(hidden=true) @NotNull @PathParam(value="dataDefinitionId") Long dataDefinitionId, Permission[] permissions) throws Exception {
        String resourceName = this.getPermissionCheckerResourceName(dataDefinitionId);
        Long resourceId = this.getPermissionCheckerResourceId(dataDefinitionId);
        PermissionUtil.checkPermission((String)"PERMISSIONS", (GroupLocalService)this.groupLocalService, (String)resourceName, (long)resourceId, (Long)this.getPermissionCheckerGroupId(dataDefinitionId));
        this.resourcePermissionLocalService.updateResourcePermissions(this.contextCompany.getCompanyId(), this.getPermissionCheckerGroupId(dataDefinitionId).longValue(), resourceName, String.valueOf(resourceId), ModelPermissionsUtil.toModelPermissions((long)this.contextCompany.getCompanyId(), (Permission[])permissions, (long)resourceId, (String)resourceName, (ResourceActionLocalService)this.resourceActionLocalService, (ResourcePermissionLocalService)this.resourcePermissionLocalService, (RoleLocalService)this.roleLocalService));
        return this.toPermissionPage(HashMapBuilder.put((Object)"get", this.addAction("PERMISSIONS", "getDataDefinitionPermissionsPage", resourceName, resourceId)).put((Object)"replace", this.addAction("PERMISSIONS", "putDataDefinitionPermissionsPage", resourceName, resourceId)).build(), resourceId, resourceName, null);
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId"), @Parameter(in=ParameterIn.PATH, name="contentType"), @Parameter(in=ParameterIn.QUERY, name="keywords"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize"), @Parameter(in=ParameterIn.QUERY, name="sort")})
    @Tags(value={@Tag(name="DataDefinition")})
    @GET
    @Path(value="/sites/{siteId}/data-definitions/by-content-type/{contentType}")
    @Produces(value={"application/json", "application/xml"})
    public Page<DataDefinition> getSiteDataDefinitionByContentTypeContentTypePage(@Parameter(hidden=true) @NotNull @PathParam(value="siteId") Long siteId, @Parameter(hidden=true) @NotNull @PathParam(value="contentType") String contentType, @Parameter(hidden=true) @QueryParam(value="keywords") String keywords, @Context Pagination pagination, @Context Sort[] sorts) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId"), @Parameter(in=ParameterIn.PATH, name="contentType")})
    @Tags(value={@Tag(name="DataDefinition")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/sites/{siteId}/data-definitions/by-content-type/{contentType}")
    @POST
    @Produces(value={"application/json", "application/xml"})
    public DataDefinition postSiteDataDefinitionByContentType(@Parameter(hidden=true) @NotNull @PathParam(value="siteId") Long siteId, @Parameter(hidden=true) @NotNull @PathParam(value="contentType") String contentType, DataDefinition dataDefinition) throws Exception {
        return new DataDefinition();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId"), @Parameter(in=ParameterIn.PATH, name="contentType"), @Parameter(in=ParameterIn.PATH, name="dataDefinitionKey")})
    @Tags(value={@Tag(name="DataDefinition")})
    @GET
    @Path(value="/sites/{siteId}/data-definitions/by-content-type/{contentType}/by-data-definition-key/{dataDefinitionKey}")
    @Produces(value={"application/json", "application/xml"})
    public DataDefinition getSiteDataDefinitionByContentTypeByDataDefinitionKey(@Parameter(hidden=true) @NotNull @PathParam(value="siteId") Long siteId, @Parameter(hidden=true) @NotNull @PathParam(value="contentType") String contentType, @Parameter(hidden=true) @NotNull @PathParam(value="dataDefinitionKey") String dataDefinitionKey) throws Exception {
        return new DataDefinition();
    }

    public void create(Collection<DataDefinition> dataDefinitions, Map<String, Serializable> parameters) throws Exception {
        throw new UnsupportedOperationException("This method needs to be implemented");
    }

    public void delete(Collection<DataDefinition> dataDefinitions, Map<String, Serializable> parameters) throws Exception {
        for (DataDefinition dataDefinition : dataDefinitions) {
            this.deleteDataDefinition(dataDefinition.getId());
        }
    }

    public Set<String> getAvailableCreateStrategies() {
        return SetUtil.fromArray((Object[])new String[0]);
    }

    public Set<String> getAvailableUpdateStrategies() {
        return SetUtil.fromArray((Object[])new String[]{"PARTIAL_UPDATE", "UPDATE"});
    }

    public EntityModel getEntityModel(Map<String, List<String>> multivaluedMap) throws Exception {
        return this.getEntityModel((MultivaluedMap)new MultivaluedHashMap(multivaluedMap));
    }

    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) throws Exception {
        return null;
    }

    public String getVersion() {
        return "v2.0";
    }

    public Page<DataDefinition> read(com.liferay.portal.kernel.search.filter.Filter filter, Pagination pagination, Sort[] sorts, Map<String, Serializable> parameters, String search) throws Exception {
        throw new UnsupportedOperationException("This method needs to be implemented");
    }

    public void setLanguageId(final String languageId) {
        this.contextAcceptLanguage = new AcceptLanguage(){

            public List<Locale> getLocales() {
                return null;
            }

            public String getPreferredLanguageId() {
                return languageId;
            }

            public Locale getPreferredLocale() {
                return LocaleUtil.fromLanguageId((String)languageId);
            }
        };
    }

    public void update(Collection<DataDefinition> dataDefinitions, Map<String, Serializable> parameters) throws Exception {
        UnsafeConsumer dataDefinitionUnsafeConsumer = null;
        String updateStrategy = (String)((Object)parameters.getOrDefault("updateStrategy", (Serializable)((Object)"UPDATE")));
        if ("PARTIAL_UPDATE".equalsIgnoreCase(updateStrategy)) {
            dataDefinitionUnsafeConsumer = dataDefinition -> this.patchDataDefinition(dataDefinition.getId() != null ? dataDefinition.getId() : Long.parseLong((String)parameters.get("dataDefinitionId")), (DataDefinition)dataDefinition);
        }
        if ("UPDATE".equalsIgnoreCase(updateStrategy)) {
            dataDefinitionUnsafeConsumer = dataDefinition -> this.putDataDefinition(dataDefinition.getId() != null ? dataDefinition.getId() : Long.parseLong((String)parameters.get("dataDefinitionId")), (DataDefinition)dataDefinition);
        }
        if (dataDefinitionUnsafeConsumer == null) {
            throw new NotSupportedException("Update strategy \"" + updateStrategy + "\" is not supported for DataDefinition");
        }
        if (this.contextBatchUnsafeConsumer != null) {
            this.contextBatchUnsafeConsumer.accept(dataDefinitions, (Object)dataDefinitionUnsafeConsumer);
        } else {
            for (DataDefinition dataDefinition2 : dataDefinitions) {
                dataDefinitionUnsafeConsumer.accept((Object)dataDefinition2);
            }
        }
    }

    protected String getPermissionCheckerActionsResourceName(Object id) throws Exception {
        return this.getPermissionCheckerResourceName(id);
    }

    protected Long getPermissionCheckerGroupId(Object id) throws Exception {
        throw new UnsupportedOperationException("This method needs to be implemented");
    }

    protected String getPermissionCheckerPortletName(Object id) throws Exception {
        throw new UnsupportedOperationException("This method needs to be implemented");
    }

    protected Long getPermissionCheckerResourceId(Object id) throws Exception {
        return GetterUtil.getLong((Object)id);
    }

    protected String getPermissionCheckerResourceName(Object id) throws Exception {
        throw new UnsupportedOperationException("This method needs to be implemented");
    }

    protected Page<Permission> toPermissionPage(Map<String, Map<String, String>> actions, long id, String resourceName, String roleNames) throws Exception {
        List resourceActions = this.resourceActionLocalService.getResourceActions(resourceName);
        if (Validator.isNotNull((String)roleNames)) {
            return Page.of(actions, this._getPermissions(this.contextCompany.getCompanyId(), resourceActions, id, resourceName, StringUtil.split((String)roleNames)));
        }
        return Page.of(actions, this._getPermissions(this.contextCompany.getCompanyId(), resourceActions, id, resourceName, null));
    }

    public void setContextAcceptLanguage(AcceptLanguage contextAcceptLanguage) {
        this.contextAcceptLanguage = contextAcceptLanguage;
    }

    public void setContextBatchUnsafeConsumer(UnsafeBiConsumer<Collection<DataDefinition>, UnsafeConsumer<DataDefinition, Exception>, Exception> contextBatchUnsafeConsumer) {
        this.contextBatchUnsafeConsumer = contextBatchUnsafeConsumer;
    }

    public void setContextCompany(Company contextCompany) {
        this.contextCompany = contextCompany;
    }

    public void setContextHttpServletRequest(HttpServletRequest contextHttpServletRequest) {
        this.contextHttpServletRequest = contextHttpServletRequest;
    }

    public void setContextHttpServletResponse(HttpServletResponse contextHttpServletResponse) {
        this.contextHttpServletResponse = contextHttpServletResponse;
    }

    public void setContextUriInfo(UriInfo contextUriInfo) {
        this.contextUriInfo = contextUriInfo;
    }

    public void setContextUser(User contextUser) {
        this.contextUser = contextUser;
    }

    public void setExpressionConvert(ExpressionConvert<com.liferay.portal.kernel.search.filter.Filter> expressionConvert) {
        this.expressionConvert = expressionConvert;
    }

    public void setFilterParserProvider(FilterParserProvider filterParserProvider) {
        this.filterParserProvider = filterParserProvider;
    }

    public void setGroupLocalService(GroupLocalService groupLocalService) {
        this.groupLocalService = groupLocalService;
    }

    public void setResourceActionLocalService(ResourceActionLocalService resourceActionLocalService) {
        this.resourceActionLocalService = resourceActionLocalService;
    }

    public void setResourcePermissionLocalService(ResourcePermissionLocalService resourcePermissionLocalService) {
        this.resourcePermissionLocalService = resourcePermissionLocalService;
    }

    public void setRoleLocalService(RoleLocalService roleLocalService) {
        this.roleLocalService = roleLocalService;
    }

    public void setSortParserProvider(SortParserProvider sortParserProvider) {
        this.sortParserProvider = sortParserProvider;
    }

    public void setVulcanBatchEngineImportTaskResource(VulcanBatchEngineImportTaskResource vulcanBatchEngineImportTaskResource) {
        this.vulcanBatchEngineImportTaskResource = vulcanBatchEngineImportTaskResource;
    }

    public com.liferay.portal.kernel.search.filter.Filter toFilter(String filterString, Map<String, List<String>> multivaluedMap) {
        try {
            EntityModel entityModel = this.getEntityModel(multivaluedMap);
            FilterParser filterParser = this.filterParserProvider.provide(entityModel);
            Filter oDataFilter = new Filter(filterParser.parse(filterString));
            return (com.liferay.portal.kernel.search.filter.Filter)this.expressionConvert.convert(oDataFilter.getExpression(), this.contextAcceptLanguage.getPreferredLocale(), entityModel);
        }
        catch (Exception exception) {
            _log.error((Object)("Invalid filter " + filterString), (Throwable)exception);
            return null;
        }
    }

    public Sort[] toSorts(String sortString) {
        if (Validator.isNull((String)sortString)) {
            return null;
        }
        try {
            SortParser sortParser = this.sortParserProvider.provide(this.getEntityModel(Collections.emptyMap()));
            if (sortParser == null) {
                return null;
            }
            com.liferay.portal.odata.sort.Sort oDataSort = new com.liferay.portal.odata.sort.Sort(sortParser.parse(sortString));
            List sortFields = oDataSort.getSortFields();
            Sort[] sorts = new Sort[sortFields.size()];
            for (int i = 0; i < sortFields.size(); ++i) {
                SortField sortField = (SortField)sortFields.get(i);
                sorts[i] = new Sort(sortField.getSortableFieldName(this.contextAcceptLanguage.getPreferredLocale()), !sortField.isAscending());
            }
            return sorts;
        }
        catch (Exception exception) {
            _log.error((Object)("Invalid sort " + sortString), (Throwable)exception);
            return new Sort[0];
        }
    }

    protected Map<String, String> addAction(String actionName, GroupedModel groupedModel, String methodName) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (GroupedModel)groupedModel, (String)methodName, (Object)this.contextScopeChecker, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, Long id, String methodName, Long ownerId, String permissionName, Long siteId) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (Long)id, (String)methodName, (Object)this.contextScopeChecker, (Long)ownerId, (String)permissionName, (Long)siteId, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, Long id, String methodName, ModelResourcePermission modelResourcePermission) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (Long)id, (String)methodName, (Object)this.contextScopeChecker, (ModelResourcePermission)modelResourcePermission, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, String methodName, String permissionName, Long siteId) {
        return this.addAction(actionName, siteId, methodName, null, permissionName, siteId);
    }

    protected void preparePatch(DataDefinition dataDefinition, DataDefinition existingDataDefinition) {
    }

    protected <T, R, E extends Throwable> List<R> transform(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction) {
        return TransformUtil.transform(collection, unsafeFunction);
    }

    protected <T, R, E extends Throwable> R[] transform(T[] array, UnsafeFunction<T, R, E> unsafeFunction, Class<?> clazz) {
        return TransformUtil.transform((Object[])array, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> R[] transformToArray(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction, Class<?> clazz) {
        return TransformUtil.transformToArray(collection, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> List<R> transformToList(T[] array, UnsafeFunction<T, R, E> unsafeFunction) {
        return TransformUtil.transformToList((Object[])array, unsafeFunction);
    }

    protected <T, R, E extends Throwable> List<R> unsafeTransform(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction) throws E {
        return TransformUtil.unsafeTransform(collection, unsafeFunction);
    }

    protected <T, R, E extends Throwable> R[] unsafeTransform(T[] array, UnsafeFunction<T, R, E> unsafeFunction, Class<?> clazz) throws E {
        return TransformUtil.unsafeTransform((Object[])array, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> R[] unsafeTransformToArray(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction, Class<?> clazz) throws E {
        return TransformUtil.unsafeTransformToArray(collection, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> List<R> unsafeTransformToList(T[] array, UnsafeFunction<T, R, E> unsafeFunction) throws E {
        return TransformUtil.unsafeTransformToList((Object[])array, unsafeFunction);
    }

    private void _checkResources(long companyId, long resourceId, String resourceName) throws PortalException {
        int count = this.resourcePermissionLocalService.getResourcePermissionsCount(companyId, resourceName, 4, String.valueOf(resourceId));
        if (count == 0) {
            ResourceLocalServiceUtil.addResources((long)companyId, (long)resourceId, (long)0L, (String)resourceName, (String)String.valueOf(resourceId), (boolean)false, (boolean)true, (boolean)true);
        }
    }

    private Collection<Permission> _getPermissions(long companyId, List<ResourceAction> resourceActions, long resourceId, String resourceName, String[] roleNames) throws Exception {
        this._checkResources(companyId, resourceId, resourceName);
        LinkedHashMap<String, Permission> permissions = new LinkedHashMap<String, Permission>();
        List resourcePermissions = new ArrayList();
        try {
            Method method = ResourcePermissionLocalService.class.getMethod("getResourcePermissions", String.class);
            resourcePermissions = (List)method.invoke((Object)this.resourcePermissionLocalService, resourceName);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            resourcePermissions = this.resourcePermissionLocalService.getResourcePermissions(companyId, resourceName, 4, String.valueOf(resourceId));
        }
        for (ResourcePermission resourcePermission : resourcePermissions) {
            if (resourcePermission.getPrimKeyId() != 0L && resourcePermission.getPrimKeyId() != resourceId) continue;
            Role role = this.roleLocalService.getRole(resourcePermission.getRoleId());
            if (roleNames != null && (roleNames == null || !ArrayUtil.contains((Object[])roleNames, (Object)role.getName()))) continue;
            Permission permission = (Permission)permissions.get(role.getName());
            if (permission == null) {
                permission = this._toPermission(resourceActions, resourcePermission, role);
                if (permission == null) continue;
                permissions.put(role.getName(), permission);
                continue;
            }
            HashSet actionsIdsSet = new HashSet();
            Collections.addAll(actionsIdsSet, permission.getActionIds());
            Permission newPermission = this._toPermission(resourceActions, resourcePermission, role);
            Collections.addAll(actionsIdsSet, newPermission.getActionIds());
            permission.setActionIds(actionsIdsSet.toArray(new String[0]));
        }
        return permissions.values();
    }

    private Permission _toPermission(List<ResourceAction> resourceActions, ResourcePermission resourcePermission, final Role role) {
        final HashSet<String> actionsIdsSet = new HashSet<String>();
        long actionIds = resourcePermission.getActionIds();
        for (ResourceAction resourceAction : resourceActions) {
            long bitwiseValue = resourceAction.getBitwiseValue();
            if ((actionIds & bitwiseValue) != bitwiseValue) continue;
            actionsIdsSet.add(resourceAction.getActionId());
        }
        if (actionsIdsSet.isEmpty()) {
            return null;
        }
        return new Permission(){
            {
                this.actionIds = actionsIdsSet.toArray(new String[0]);
                this.roleName = role.getName();
            }
        };
    }
}

