/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.data.engine.rest.internal.resource.v2_0;

import com.liferay.data.engine.rest.dto.v2_0.DataLayout;
import com.liferay.data.engine.rest.dto.v2_0.DataLayoutRenderingContext;
import com.liferay.data.engine.rest.resource.v2_0.DataLayoutResource;
import com.liferay.petra.function.UnsafeBiConsumer;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.model.ResourceAction;
import com.liferay.portal.kernel.model.ResourcePermission;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ResourceActionLocalService;
import com.liferay.portal.kernel.service.ResourceLocalServiceUtil;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.odata.filter.ExpressionConvert;
import com.liferay.portal.odata.filter.Filter;
import com.liferay.portal.odata.filter.FilterParser;
import com.liferay.portal.odata.filter.FilterParserProvider;
import com.liferay.portal.odata.sort.SortField;
import com.liferay.portal.odata.sort.SortParser;
import com.liferay.portal.odata.sort.SortParserProvider;
import com.liferay.portal.vulcan.accept.language.AcceptLanguage;
import com.liferay.portal.vulcan.batch.engine.VulcanBatchEngineTaskItemDelegate;
import com.liferay.portal.vulcan.batch.engine.resource.VulcanBatchEngineImportTaskResource;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.permission.Permission;
import com.liferay.portal.vulcan.resource.EntityModelResource;
import com.liferay.portal.vulcan.util.ActionUtil;
import com.liferay.portal.vulcan.util.TransformUtil;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.NotSupportedException;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="/v2.0")
public abstract class BaseDataLayoutResourceImpl
implements DataLayoutResource,
EntityModelResource,
VulcanBatchEngineTaskItemDelegate<DataLayout> {
    protected AcceptLanguage contextAcceptLanguage;
    protected UnsafeBiConsumer<Collection<DataLayout>, UnsafeConsumer<DataLayout, Exception>, Exception> contextBatchUnsafeConsumer;
    protected Company contextCompany;
    protected HttpServletRequest contextHttpServletRequest;
    protected HttpServletResponse contextHttpServletResponse;
    protected Object contextScopeChecker;
    protected UriInfo contextUriInfo;
    protected User contextUser;
    protected ExpressionConvert<com.liferay.portal.kernel.search.filter.Filter> expressionConvert;
    protected FilterParserProvider filterParserProvider;
    protected GroupLocalService groupLocalService;
    protected ResourceActionLocalService resourceActionLocalService;
    protected ResourcePermissionLocalService resourcePermissionLocalService;
    protected RoleLocalService roleLocalService;
    protected SortParserProvider sortParserProvider;
    protected VulcanBatchEngineImportTaskResource vulcanBatchEngineImportTaskResource;
    private static final Log _log = LogFactoryUtil.getLog(BaseDataLayoutResourceImpl.class);

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="dataDefinitionId")})
    @Tags(value={@Tag(name="DataLayout")})
    @DELETE
    @Path(value="/data-definitions/{dataDefinitionId}/data-layouts")
    @Produces(value={"application/json", "application/xml"})
    public void deleteDataDefinitionDataLayout(@Parameter(hidden=true) @NotNull @PathParam(value="dataDefinitionId") Long dataDefinitionId) throws Exception {
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="dataDefinitionId"), @Parameter(in=ParameterIn.QUERY, name="keywords"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize"), @Parameter(in=ParameterIn.QUERY, name="sort")})
    @Tags(value={@Tag(name="DataLayout")})
    @GET
    @Path(value="/data-definitions/{dataDefinitionId}/data-layouts")
    @Produces(value={"application/json", "application/xml"})
    public Page<DataLayout> getDataDefinitionDataLayoutsPage(@Parameter(hidden=true) @NotNull @PathParam(value="dataDefinitionId") Long dataDefinitionId, @Parameter(hidden=true) @QueryParam(value="keywords") String keywords, @Context Pagination pagination, @Context Sort[] sorts) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="dataDefinitionId")})
    @Tags(value={@Tag(name="DataLayout")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/data-definitions/{dataDefinitionId}/data-layouts")
    @POST
    @Produces(value={"application/json", "application/xml"})
    public DataLayout postDataDefinitionDataLayout(@Parameter(hidden=true) @NotNull @PathParam(value="dataDefinitionId") Long dataDefinitionId, DataLayout dataLayout) throws Exception {
        return new DataLayout();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="dataDefinitionId"), @Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Tags(value={@Tag(name="DataLayout")})
    @Consumes(value={"application/json"})
    @Path(value="/data-definitions/{dataDefinitionId}/data-layouts/batch")
    @POST
    @Produces(value={"application/json"})
    public Response postDataDefinitionDataLayoutBatch(@Parameter(hidden=true) @NotNull @PathParam(value="dataDefinitionId") Long dataDefinitionId, @Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.postImportTask(DataLayout.class.getName(), callbackURL, null, object)).build();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="dataLayoutId")})
    @Tags(value={@Tag(name="DataLayout")})
    @DELETE
    @Path(value="/data-layouts/{dataLayoutId}")
    @Produces(value={"application/json", "application/xml"})
    public void deleteDataLayout(@Parameter(hidden=true) @NotNull @PathParam(value="dataLayoutId") Long dataLayoutId) throws Exception {
    }

    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Tags(value={@Tag(name="DataLayout")})
    @Consumes(value={"application/json"})
    @DELETE
    @Path(value="/data-layouts/batch")
    @Produces(value={"application/json"})
    public Response deleteDataLayoutBatch(@Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.deleteImportTask(DataLayout.class.getName(), callbackURL, object)).build();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="dataLayoutId")})
    @Tags(value={@Tag(name="DataLayout")})
    @GET
    @Path(value="/data-layouts/{dataLayoutId}")
    @Produces(value={"application/json", "application/xml"})
    public DataLayout getDataLayout(@Parameter(hidden=true) @NotNull @PathParam(value="dataLayoutId") Long dataLayoutId) throws Exception {
        return new DataLayout();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="dataLayoutId")})
    @Tags(value={@Tag(name="DataLayout")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/data-layouts/{dataLayoutId}")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    public DataLayout putDataLayout(@Parameter(hidden=true) @NotNull @PathParam(value="dataLayoutId") Long dataLayoutId, DataLayout dataLayout) throws Exception {
        return new DataLayout();
    }

    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Tags(value={@Tag(name="DataLayout")})
    @Consumes(value={"application/json"})
    @Path(value="/data-layouts/batch")
    @Produces(value={"application/json"})
    @PUT
    public Response putDataLayoutBatch(@Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.putImportTask(DataLayout.class.getName(), callbackURL, object)).build();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="dataLayoutId")})
    @Tags(value={@Tag(name="DataLayout")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/data-layouts/{dataLayoutId}/context")
    @POST
    @Produces(value={"application/json", "application/xml"})
    public Response postDataLayoutContext(@Parameter(hidden=true) @NotNull @PathParam(value="dataLayoutId") Long dataLayoutId, DataLayoutRenderingContext dataLayoutRenderingContext) throws Exception {
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId"), @Parameter(in=ParameterIn.PATH, name="contentType"), @Parameter(in=ParameterIn.PATH, name="dataLayoutKey")})
    @Tags(value={@Tag(name="DataLayout")})
    @GET
    @Path(value="/sites/{siteId}/data-layouts/by-content-type/{contentType}/by-data-layout-key/{dataLayoutKey}")
    @Produces(value={"application/json", "application/xml"})
    public DataLayout getSiteDataLayoutByContentTypeByDataLayoutKey(@Parameter(hidden=true) @NotNull @PathParam(value="siteId") Long siteId, @Parameter(hidden=true) @NotNull @PathParam(value="contentType") String contentType, @Parameter(hidden=true) @NotNull @PathParam(value="dataLayoutKey") String dataLayoutKey) throws Exception {
        return new DataLayout();
    }

    public void create(Collection<DataLayout> dataLayouts, Map<String, Serializable> parameters) throws Exception {
        UnsafeConsumer dataLayoutUnsafeConsumer = null;
        String createStrategy = (String)((Object)parameters.getOrDefault("createStrategy", (Serializable)((Object)"INSERT")));
        if ("INSERT".equalsIgnoreCase(createStrategy)) {
            if (parameters.containsKey("dataDefinitionId")) {
                dataLayoutUnsafeConsumer = dataLayout -> this.postDataDefinitionDataLayout(Long.parseLong((String)parameters.get("dataDefinitionId")), (DataLayout)dataLayout);
            } else {
                throw new NotSupportedException("One of the following parameters must be specified: [dataDefinitionId]");
            }
        }
        if (dataLayoutUnsafeConsumer == null) {
            throw new NotSupportedException("Create strategy \"" + createStrategy + "\" is not supported for DataLayout");
        }
        if (this.contextBatchUnsafeConsumer != null) {
            this.contextBatchUnsafeConsumer.accept(dataLayouts, (Object)dataLayoutUnsafeConsumer);
        } else {
            for (DataLayout dataLayout2 : dataLayouts) {
                dataLayoutUnsafeConsumer.accept((Object)dataLayout2);
            }
        }
    }

    public void delete(Collection<DataLayout> dataLayouts, Map<String, Serializable> parameters) throws Exception {
        for (DataLayout dataLayout : dataLayouts) {
            this.deleteDataLayout(dataLayout.getId());
        }
    }

    public Set<String> getAvailableCreateStrategies() {
        return SetUtil.fromArray((Object[])new String[]{"INSERT"});
    }

    public Set<String> getAvailableUpdateStrategies() {
        return SetUtil.fromArray((Object[])new String[]{"UPDATE"});
    }

    public EntityModel getEntityModel(Map<String, List<String>> multivaluedMap) throws Exception {
        return this.getEntityModel((MultivaluedMap)new MultivaluedHashMap(multivaluedMap));
    }

    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) throws Exception {
        return null;
    }

    public String getVersion() {
        return "v2.0";
    }

    public Page<DataLayout> read(com.liferay.portal.kernel.search.filter.Filter filter, Pagination pagination, Sort[] sorts, Map<String, Serializable> parameters, String search) throws Exception {
        if (parameters.containsKey("dataDefinitionId")) {
            return this.getDataDefinitionDataLayoutsPage(Long.parseLong((String)((Object)parameters.get("dataDefinitionId"))), (String)((Object)parameters.get("keywords")), pagination, sorts);
        }
        throw new NotSupportedException("One of the following parameters must be specified: [dataDefinitionId]");
    }

    public void setLanguageId(final String languageId) {
        this.contextAcceptLanguage = new AcceptLanguage(){

            public List<Locale> getLocales() {
                return null;
            }

            public String getPreferredLanguageId() {
                return languageId;
            }

            public Locale getPreferredLocale() {
                return LocaleUtil.fromLanguageId((String)languageId);
            }
        };
    }

    public void update(Collection<DataLayout> dataLayouts, Map<String, Serializable> parameters) throws Exception {
        UnsafeConsumer dataLayoutUnsafeConsumer = null;
        String updateStrategy = (String)((Object)parameters.getOrDefault("updateStrategy", (Serializable)((Object)"UPDATE")));
        if ("UPDATE".equalsIgnoreCase(updateStrategy)) {
            dataLayoutUnsafeConsumer = dataLayout -> this.putDataLayout(dataLayout.getId() != null ? dataLayout.getId() : Long.parseLong((String)parameters.get("dataLayoutId")), (DataLayout)dataLayout);
        }
        if (dataLayoutUnsafeConsumer == null) {
            throw new NotSupportedException("Update strategy \"" + updateStrategy + "\" is not supported for DataLayout");
        }
        if (this.contextBatchUnsafeConsumer != null) {
            this.contextBatchUnsafeConsumer.accept(dataLayouts, (Object)dataLayoutUnsafeConsumer);
        } else {
            for (DataLayout dataLayout2 : dataLayouts) {
                dataLayoutUnsafeConsumer.accept((Object)dataLayout2);
            }
        }
    }

    public void setContextAcceptLanguage(AcceptLanguage contextAcceptLanguage) {
        this.contextAcceptLanguage = contextAcceptLanguage;
    }

    public void setContextBatchUnsafeConsumer(UnsafeBiConsumer<Collection<DataLayout>, UnsafeConsumer<DataLayout, Exception>, Exception> contextBatchUnsafeConsumer) {
        this.contextBatchUnsafeConsumer = contextBatchUnsafeConsumer;
    }

    public void setContextCompany(Company contextCompany) {
        this.contextCompany = contextCompany;
    }

    public void setContextHttpServletRequest(HttpServletRequest contextHttpServletRequest) {
        this.contextHttpServletRequest = contextHttpServletRequest;
    }

    public void setContextHttpServletResponse(HttpServletResponse contextHttpServletResponse) {
        this.contextHttpServletResponse = contextHttpServletResponse;
    }

    public void setContextUriInfo(UriInfo contextUriInfo) {
        this.contextUriInfo = contextUriInfo;
    }

    public void setContextUser(User contextUser) {
        this.contextUser = contextUser;
    }

    public void setExpressionConvert(ExpressionConvert<com.liferay.portal.kernel.search.filter.Filter> expressionConvert) {
        this.expressionConvert = expressionConvert;
    }

    public void setFilterParserProvider(FilterParserProvider filterParserProvider) {
        this.filterParserProvider = filterParserProvider;
    }

    public void setGroupLocalService(GroupLocalService groupLocalService) {
        this.groupLocalService = groupLocalService;
    }

    public void setResourceActionLocalService(ResourceActionLocalService resourceActionLocalService) {
        this.resourceActionLocalService = resourceActionLocalService;
    }

    public void setResourcePermissionLocalService(ResourcePermissionLocalService resourcePermissionLocalService) {
        this.resourcePermissionLocalService = resourcePermissionLocalService;
    }

    public void setRoleLocalService(RoleLocalService roleLocalService) {
        this.roleLocalService = roleLocalService;
    }

    public void setSortParserProvider(SortParserProvider sortParserProvider) {
        this.sortParserProvider = sortParserProvider;
    }

    public void setVulcanBatchEngineImportTaskResource(VulcanBatchEngineImportTaskResource vulcanBatchEngineImportTaskResource) {
        this.vulcanBatchEngineImportTaskResource = vulcanBatchEngineImportTaskResource;
    }

    public com.liferay.portal.kernel.search.filter.Filter toFilter(String filterString, Map<String, List<String>> multivaluedMap) {
        try {
            EntityModel entityModel = this.getEntityModel(multivaluedMap);
            FilterParser filterParser = this.filterParserProvider.provide(entityModel);
            Filter oDataFilter = new Filter(filterParser.parse(filterString));
            return (com.liferay.portal.kernel.search.filter.Filter)this.expressionConvert.convert(oDataFilter.getExpression(), this.contextAcceptLanguage.getPreferredLocale(), entityModel);
        }
        catch (Exception exception) {
            _log.error((Object)("Invalid filter " + filterString), (Throwable)exception);
            return null;
        }
    }

    public Sort[] toSorts(String sortString) {
        if (Validator.isNull((String)sortString)) {
            return null;
        }
        try {
            SortParser sortParser = this.sortParserProvider.provide(this.getEntityModel(Collections.emptyMap()));
            if (sortParser == null) {
                return null;
            }
            com.liferay.portal.odata.sort.Sort oDataSort = new com.liferay.portal.odata.sort.Sort(sortParser.parse(sortString));
            List sortFields = oDataSort.getSortFields();
            Sort[] sorts = new Sort[sortFields.size()];
            for (int i = 0; i < sortFields.size(); ++i) {
                SortField sortField = (SortField)sortFields.get(i);
                sorts[i] = new Sort(sortField.getSortableFieldName(this.contextAcceptLanguage.getPreferredLocale()), !sortField.isAscending());
            }
            return sorts;
        }
        catch (Exception exception) {
            _log.error((Object)("Invalid sort " + sortString), (Throwable)exception);
            return new Sort[0];
        }
    }

    protected Map<String, String> addAction(String actionName, GroupedModel groupedModel, String methodName) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (GroupedModel)groupedModel, (String)methodName, (Object)this.contextScopeChecker, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, Long id, String methodName, Long ownerId, String permissionName, Long siteId) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (Long)id, (String)methodName, (Object)this.contextScopeChecker, (Long)ownerId, (String)permissionName, (Long)siteId, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, Long id, String methodName, ModelResourcePermission modelResourcePermission) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (Long)id, (String)methodName, (Object)this.contextScopeChecker, (ModelResourcePermission)modelResourcePermission, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, String methodName, String permissionName, Long siteId) {
        return this.addAction(actionName, siteId, methodName, null, permissionName, siteId);
    }

    protected <T, R, E extends Throwable> List<R> transform(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction) {
        return TransformUtil.transform(collection, unsafeFunction);
    }

    protected <T, R, E extends Throwable> R[] transform(T[] array, UnsafeFunction<T, R, E> unsafeFunction, Class<?> clazz) {
        return TransformUtil.transform((Object[])array, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> R[] transformToArray(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction, Class<?> clazz) {
        return TransformUtil.transformToArray(collection, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> List<R> transformToList(T[] array, UnsafeFunction<T, R, E> unsafeFunction) {
        return TransformUtil.transformToList((Object[])array, unsafeFunction);
    }

    protected <T, R, E extends Throwable> List<R> unsafeTransform(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction) throws E {
        return TransformUtil.unsafeTransform(collection, unsafeFunction);
    }

    protected <T, R, E extends Throwable> R[] unsafeTransform(T[] array, UnsafeFunction<T, R, E> unsafeFunction, Class<?> clazz) throws E {
        return TransformUtil.unsafeTransform((Object[])array, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> R[] unsafeTransformToArray(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction, Class<?> clazz) throws E {
        return TransformUtil.unsafeTransformToArray(collection, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> List<R> unsafeTransformToList(T[] array, UnsafeFunction<T, R, E> unsafeFunction) throws E {
        return TransformUtil.unsafeTransformToList((Object[])array, unsafeFunction);
    }

    private void _checkResources(long companyId, long resourceId, String resourceName) throws PortalException {
        int count = this.resourcePermissionLocalService.getResourcePermissionsCount(companyId, resourceName, 4, String.valueOf(resourceId));
        if (count == 0) {
            ResourceLocalServiceUtil.addResources((long)companyId, (long)resourceId, (long)0L, (String)resourceName, (String)String.valueOf(resourceId), (boolean)false, (boolean)true, (boolean)true);
        }
    }

    private Collection<Permission> _getPermissions(long companyId, List<ResourceAction> resourceActions, long resourceId, String resourceName, String[] roleNames) throws Exception {
        this._checkResources(companyId, resourceId, resourceName);
        LinkedHashMap<String, Permission> permissions = new LinkedHashMap<String, Permission>();
        List resourcePermissions = new ArrayList();
        try {
            Method method = ResourcePermissionLocalService.class.getMethod("getResourcePermissions", String.class);
            resourcePermissions = (List)method.invoke((Object)this.resourcePermissionLocalService, resourceName);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            resourcePermissions = this.resourcePermissionLocalService.getResourcePermissions(companyId, resourceName, 4, String.valueOf(resourceId));
        }
        for (ResourcePermission resourcePermission : resourcePermissions) {
            if (resourcePermission.getPrimKeyId() != 0L && resourcePermission.getPrimKeyId() != resourceId) continue;
            Role role = this.roleLocalService.getRole(resourcePermission.getRoleId());
            if (roleNames != null && (roleNames == null || !ArrayUtil.contains((Object[])roleNames, (Object)role.getName()))) continue;
            Permission permission = (Permission)permissions.get(role.getName());
            if (permission == null) {
                permission = this._toPermission(resourceActions, resourcePermission, role);
                if (permission == null) continue;
                permissions.put(role.getName(), permission);
                continue;
            }
            HashSet actionsIdsSet = new HashSet();
            Collections.addAll(actionsIdsSet, permission.getActionIds());
            Permission newPermission = this._toPermission(resourceActions, resourcePermission, role);
            Collections.addAll(actionsIdsSet, newPermission.getActionIds());
            permission.setActionIds(actionsIdsSet.toArray(new String[0]));
        }
        return permissions.values();
    }

    private Permission _toPermission(List<ResourceAction> resourceActions, ResourcePermission resourcePermission, final Role role) {
        final HashSet<String> actionsIdsSet = new HashSet<String>();
        long actionIds = resourcePermission.getActionIds();
        for (ResourceAction resourceAction : resourceActions) {
            long bitwiseValue = resourceAction.getBitwiseValue();
            if ((actionIds & bitwiseValue) != bitwiseValue) continue;
            actionsIdsSet.add(resourceAction.getActionId());
        }
        if (actionsIdsSet.isEmpty()) {
            return null;
        }
        return new Permission(){
            {
                this.actionIds = actionsIdsSet.toArray(new String[0]);
                this.roleName = role.getName();
            }
        };
    }
}

