/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.data.engine.rest.internal.resource.v2_0;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.liferay.data.engine.field.type.util.LocalizedValueUtil;
import com.liferay.data.engine.rest.dto.v2_0.DataDefinition;
import com.liferay.data.engine.rest.dto.v2_0.DataLayout;
import com.liferay.data.engine.rest.dto.v2_0.DataLayoutRenderingContext;
import com.liferay.data.engine.rest.dto.v2_0.util.DataDefinitionDDMFormUtil;
import com.liferay.data.engine.rest.internal.content.type.DataDefinitionContentTypeRegistry;
import com.liferay.data.engine.rest.internal.dto.v2_0.util.DataDefinitionUtil;
import com.liferay.data.engine.rest.internal.dto.v2_0.util.DataLayoutUtil;
import com.liferay.data.engine.rest.internal.dto.v2_0.util.MapToDDMFormValuesConverterUtil;
import com.liferay.data.engine.rest.internal.odata.entity.v2_0.DataLayoutEntityModel;
import com.liferay.data.engine.rest.internal.resource.v2_0.BaseDataLayoutResourceImpl;
import com.liferay.data.engine.rest.internal.security.permission.resource.DataDefinitionModelResourcePermission;
import com.liferay.data.engine.rest.resource.exception.DataLayoutValidationException;
import com.liferay.data.engine.rest.resource.v2_0.DataLayoutResource;
import com.liferay.data.engine.service.DEDataDefinitionFieldLinkLocalService;
import com.liferay.dynamic.data.mapping.form.builder.rule.DDMFormRuleDeserializer;
import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldTypeServicesRegistry;
import com.liferay.dynamic.data.mapping.form.renderer.DDMFormRenderingContext;
import com.liferay.dynamic.data.mapping.form.renderer.DDMFormTemplateContextFactory;
import com.liferay.dynamic.data.mapping.io.DDMFormLayoutSerializer;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormLayout;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMStructureLayout;
import com.liferay.dynamic.data.mapping.model.DDMStructureVersion;
import com.liferay.dynamic.data.mapping.service.DDMStructureLayoutLocalService;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.dynamic.data.mapping.service.DDMStructureVersionLocalService;
import com.liferay.dynamic.data.mapping.spi.converter.SPIDDMFormRuleConverter;
import com.liferay.dynamic.data.mapping.util.comparator.StructureLayoutCreateDateComparator;
import com.liferay.dynamic.data.mapping.util.comparator.StructureLayoutModifiedDateComparator;
import com.liferay.dynamic.data.mapping.util.comparator.StructureLayoutNameComparator;
import com.liferay.dynamic.data.mapping.validator.DDMFormLayoutValidationException;
import com.liferay.dynamic.data.mapping.validator.DDMFormLayoutValidator;
import com.liferay.dynamic.data.mapping.validator.DDMFormValidationException;
import com.liferay.portal.events.ServicePreAction;
import com.liferay.portal.events.ThemeServicePreAction;
import com.liferay.portal.kernel.change.tracking.CTAware;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.servlet.DummyHttpServletResponse;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.util.SearchUtil;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import javax.validation.ValidationException;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@CTAware
@Component(properties={"OSGI-INF/liferay/rest/v2_0/data-layout.properties"}, scope=ServiceScope.PROTOTYPE, service={DataLayoutResource.class})
public class DataLayoutResourceImpl
extends BaseDataLayoutResourceImpl {
    private static final EntityModel _entityModel = new DataLayoutEntityModel();
    @Reference
    private DataDefinitionContentTypeRegistry _dataDefinitionContentTypeRegistry;
    @Reference
    private DataDefinitionModelResourcePermission _dataDefinitionModelResourcePermission;
    @Reference
    private DDMFormFieldTypeServicesRegistry _ddmFormFieldTypeServicesRegistry;
    @Reference(target="(ddm.form.layout.serializer.type=json)")
    private DDMFormLayoutSerializer _ddmFormLayoutSerializer;
    @Reference
    private DDMFormLayoutValidator _ddmFormLayoutValidator;
    @Reference
    private DDMFormRuleDeserializer _ddmFormRuleDeserializer;
    @Reference
    private DDMFormTemplateContextFactory _ddmFormTemplateContextFactory;
    @Reference
    private DDMStructureLayoutLocalService _ddmStructureLayoutLocalService;
    @Reference
    private DDMStructureLocalService _ddmStructureLocalService;
    @Reference
    private DDMStructureVersionLocalService _ddmStructureVersionLocalService;
    @Reference
    private DEDataDefinitionFieldLinkLocalService _deDataDefinitionFieldLinkLocalService;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private Language _language;
    @Reference
    private Portal _portal;
    @Reference
    private SPIDDMFormRuleConverter _spiDDMFormRuleConverter;

    @Override
    public void deleteDataDefinitionDataLayout(Long dataDefinitionId) throws Exception {
        DDMStructure ddmStructure = this._ddmStructureLocalService.getDDMStructure(dataDefinitionId.longValue());
        List ddmStructureVersions = this._ddmStructureVersionLocalService.getStructureVersions(dataDefinitionId.longValue());
        for (DDMStructureVersion ddmStructureVersion : ddmStructureVersions) {
            List ddmStructureLayouts = this._ddmStructureLayoutLocalService.getStructureLayouts(ddmStructure.getGroupId(), ddmStructure.getClassNameId(), ddmStructureVersion.getStructureVersionId());
            for (DDMStructureLayout ddmStructureLayout : ddmStructureLayouts) {
                this._deleteDataLayout(ddmStructureLayout.getStructureLayoutId());
            }
        }
    }

    @Override
    public void deleteDataLayout(Long dataLayoutId) throws Exception {
        DDMStructureLayout ddmStructureLayout = this._ddmStructureLayoutLocalService.getStructureLayout(dataLayoutId.longValue());
        DDMStructure ddmStructure = ddmStructureLayout.getDDMStructure();
        this._dataDefinitionModelResourcePermission.check(PermissionThreadLocal.getPermissionChecker(), ddmStructure.getStructureId(), "DELETE");
        this._deleteDataLayout(dataLayoutId);
    }

    @Override
    public Page<DataLayout> getDataDefinitionDataLayoutsPage(Long dataDefinitionId, String keywords, Pagination pagination, Sort[] sorts) throws Exception {
        return this._getDataLayouts(dataDefinitionId, keywords, this.contextAcceptLanguage.getPreferredLocale(), pagination, sorts);
    }

    @Override
    public DataLayout getDataLayout(Long dataLayoutId) throws Exception {
        DDMStructureLayout ddmStructureLayout = this._ddmStructureLayoutLocalService.getStructureLayout(dataLayoutId.longValue());
        this._dataDefinitionModelResourcePermission.check(PermissionThreadLocal.getPermissionChecker(), ddmStructureLayout.getDDMStructureId(), "VIEW");
        return this._getDataLayout(dataLayoutId);
    }

    @Override
    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) throws Exception {
        return _entityModel;
    }

    @Override
    public DataLayout getSiteDataLayoutByContentTypeByDataLayoutKey(Long siteId, String contentType, String dataLayoutKey) throws Exception {
        DDMStructureLayout ddmStructureLayout = this._ddmStructureLayoutLocalService.getStructureLayout(siteId.longValue(), this._dataDefinitionContentTypeRegistry.getClassNameId(contentType).longValue(), dataLayoutKey);
        this._dataDefinitionModelResourcePermission.check(PermissionThreadLocal.getPermissionChecker(), ddmStructureLayout.getDDMStructureId(), "VIEW");
        return this._getDataLayout(this._dataDefinitionContentTypeRegistry.getClassNameId(contentType), dataLayoutKey, siteId);
    }

    @Override
    public DataLayout postDataDefinitionDataLayout(Long dataDefinitionId, DataLayout dataLayout) throws Exception {
        DDMStructure ddmStructure = this._ddmStructureLocalService.getStructure(dataDefinitionId.longValue());
        this._dataDefinitionModelResourcePermission.checkPortletPermission(PermissionThreadLocal.getPermissionChecker(), ddmStructure, "ADD_DATA_DEFINITION");
        this._validate(dataLayout, ddmStructure);
        return this._addDataLayout(dataDefinitionId, DataLayoutUtil.serialize(dataLayout, DataDefinitionDDMFormUtil.toDDMForm((DataDefinition)DataDefinitionUtil.toDataDefinition(this._dataDefinitionContentTypeRegistry, this._ddmFormFieldTypeServicesRegistry, ddmStructure, this._ddmStructureLayoutLocalService, this._spiDDMFormRuleConverter), (DDMFormFieldTypeServicesRegistry)this._ddmFormFieldTypeServicesRegistry), this._ddmFormFieldTypeServicesRegistry, this._ddmFormLayoutSerializer, this._ddmFormRuleDeserializer), dataLayout.getDataLayoutKey(), dataLayout.getDescription(), dataLayout.getName());
    }

    @Override
    public Response postDataLayoutContext(Long dataLayoutId, DataLayoutRenderingContext dataLayoutRenderingContext) throws Exception {
        this._initThemeDisplay(dataLayoutRenderingContext);
        DDMStructureLayout ddmStructureLayout = this._ddmStructureLayoutLocalService.getDDMStructureLayout(dataLayoutId.longValue());
        DDMStructure ddmStructure = ddmStructureLayout.getDDMStructure();
        this._dataDefinitionModelResourcePermission.check(PermissionThreadLocal.getPermissionChecker(), ddmStructure.getStructureId(), "VIEW");
        DDMForm ddmForm = ddmStructure.getDDMForm();
        DDMFormRenderingContext ddmFormRenderingContext = new DDMFormRenderingContext();
        ddmFormRenderingContext.setContainerId(dataLayoutRenderingContext.getContainerId());
        ddmFormRenderingContext.setDDMFormValues(MapToDDMFormValuesConverterUtil.toDDMFormValues(dataLayoutRenderingContext.getDataRecordValues(), ddmForm, null));
        ddmFormRenderingContext.setEditOnlyInDefaultLanguage(true);
        ddmFormRenderingContext.setHttpServletRequest(this.contextHttpServletRequest);
        ddmFormRenderingContext.setHttpServletResponse(this.contextHttpServletResponse);
        ddmFormRenderingContext.setLocale(this.contextAcceptLanguage.getPreferredLocale());
        ddmFormRenderingContext.setPortletNamespace(dataLayoutRenderingContext.getNamespace());
        ddmFormRenderingContext.setReadOnly(dataLayoutRenderingContext.getReadOnly().booleanValue());
        ddmFormRenderingContext.setShowSubmitButton(false);
        ddmFormRenderingContext.setViewMode(true);
        if (LocaleThreadLocal.getThemeDisplayLocale() == null) {
            LocaleThreadLocal.setThemeDisplayLocale((Locale)this.contextAcceptLanguage.getPreferredLocale());
        }
        Map ddmFormTemplateContext = this._ddmFormTemplateContextFactory.create(ddmForm, ddmStructureLayout.getDDMFormLayout(), ddmFormRenderingContext);
        ddmFormTemplateContext.put("editable", false);
        ThemeDisplay themeDisplay = (ThemeDisplay)this.contextHttpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        ddmFormTemplateContext.put("spritemap", themeDisplay.getPathThemeSpritemap());
        ddmFormTemplateContext.remove("fieldTypes");
        return Response.ok((Object)this._jsonFactory.looseSerializeDeep((Object)ddmFormTemplateContext)).build();
    }

    @Override
    public DataLayout putDataLayout(Long dataLayoutId, DataLayout dataLayout) throws Exception {
        DDMStructureLayout ddmStructureLayout = this._ddmStructureLayoutLocalService.getStructureLayout(dataLayoutId.longValue());
        this._dataDefinitionModelResourcePermission.check(PermissionThreadLocal.getPermissionChecker(), ddmStructureLayout.getDDMStructureId(), "UPDATE");
        this._validate(dataLayout, ddmStructureLayout.getDDMStructure());
        return this._updateDataLayout(dataLayoutId, DataLayoutUtil.serialize(dataLayout, DataDefinitionDDMFormUtil.toDDMForm((DataDefinition)DataDefinitionUtil.toDataDefinition(this._dataDefinitionContentTypeRegistry, this._ddmFormFieldTypeServicesRegistry, this._ddmStructureLocalService.getStructure(ddmStructureLayout.getDDMStructureId()), this._ddmStructureLayoutLocalService, this._spiDDMFormRuleConverter), (DDMFormFieldTypeServicesRegistry)this._ddmFormFieldTypeServicesRegistry), this._ddmFormFieldTypeServicesRegistry, this._ddmFormLayoutSerializer, this._ddmFormRuleDeserializer), dataLayout.getDescription(), dataLayout.getName());
    }

    private void _addDataDefinitionFieldLinks(long dataLayoutId, DDMFormField ddmFormField, long siteId) throws Exception {
        long fieldSetDDMStructureId = GetterUtil.getLong((Object)ddmFormField.getProperty("ddmStructureId"));
        if (fieldSetDDMStructureId != 0L) {
            this._deDataDefinitionFieldLinkLocalService.addDEDataDefinitionFieldLink(siteId, this._portal.getClassNameId(DDMStructureLayout.class), dataLayoutId, fieldSetDDMStructureId, ddmFormField.getName());
            for (DDMFormField nestedDDMFormField : ddmFormField.getNestedDDMFormFields()) {
                this._addDataDefinitionFieldLinks(dataLayoutId, nestedDDMFormField, siteId);
            }
        }
    }

    private void _addDataDefinitionFieldLinks(long dataDefinitionId, long dataLayoutId, DDMForm ddmForm, List<String> fieldNames, long siteId) throws Exception {
        Map ddmFormFieldsMap = ddmForm.getDDMFormFieldsMap(true);
        for (String fieldName : fieldNames) {
            this._deDataDefinitionFieldLinkLocalService.addDEDataDefinitionFieldLink(siteId, this._portal.getClassNameId(DDMStructureLayout.class), dataLayoutId, dataDefinitionId, fieldName);
            DDMFormField ddmFormField = (DDMFormField)ddmFormFieldsMap.get(fieldName);
            if (ddmFormField == null) continue;
            this._addDataDefinitionFieldLinks(dataLayoutId, ddmFormField, siteId);
        }
    }

    private DataLayout _addDataLayout(long dataDefinitionId, String content, String dataLayoutKey, Map<String, Object> description, Map<String, Object> name) throws Exception {
        content = this._updateContent(content, "2.0");
        DDMStructure ddmStructure = this._ddmStructureLocalService.getStructure(dataDefinitionId);
        DDMStructureLayout ddmStructureLayout = this._ddmStructureLayoutLocalService.addStructureLayout(PrincipalThreadLocal.getUserId(), ddmStructure.getGroupId(), ddmStructure.getClassNameId(), dataLayoutKey, this._getDDMStructureVersionId(dataDefinitionId), LocalizedValueUtil.toLocaleStringMap(name), LocalizedValueUtil.toLocaleStringMap(description), content, new ServiceContext());
        this._addDataDefinitionFieldLinks(dataDefinitionId, ddmStructureLayout.getStructureLayoutId(), ddmStructure.getDDMForm(), this._getFieldNames(content), ddmStructureLayout.getGroupId());
        return DataLayoutUtil.toDataLayout(this._ddmFormFieldTypeServicesRegistry, ddmStructureLayout, this._spiDDMFormRuleConverter);
    }

    private void _deleteDataLayout(long dataLayoutId) throws Exception {
        this._ddmStructureLayoutLocalService.deleteDDMStructureLayout(dataLayoutId);
        this._deDataDefinitionFieldLinkLocalService.deleteDEDataDefinitionFieldLinks(this._portal.getClassNameId(DDMStructureLayout.class), dataLayoutId);
    }

    private DataLayout _getDataLayout(long dataLayoutId) throws Exception {
        return DataLayoutUtil.toDataLayout(this._ddmFormFieldTypeServicesRegistry, this._ddmStructureLayoutLocalService.getDDMStructureLayout(dataLayoutId), this._spiDDMFormRuleConverter);
    }

    private DataLayout _getDataLayout(long classNameId, String dataLayoutKey, long siteId) throws Exception {
        DDMStructureLayout ddmStructureLayout = this._ddmStructureLayoutLocalService.getStructureLayout(siteId, classNameId, dataLayoutKey);
        return this._getDataLayout(ddmStructureLayout.getStructureLayoutId());
    }

    private Page<DataLayout> _getDataLayouts(long dataDefinitionId, String keywords, Locale locale, Pagination pagination, Sort[] sorts) throws Exception {
        if (pagination.getPageSize() > 250) {
            throw new ValidationException(this._language.format(locale, "page-size-is-greater-than-x", (Object)250));
        }
        if (ArrayUtil.isEmpty((Object[])sorts)) {
            sorts = new Sort[]{new Sort(Field.getSortableFieldName((String)"modified"), 3, true)};
        }
        DDMStructure ddmStructure = this._ddmStructureLocalService.getStructure(dataDefinitionId);
        if (Validator.isNull((String)keywords)) {
            return Page.of(this.transform(this._ddmStructureLayoutLocalService.getStructureLayouts(ddmStructure.getGroupId(), ddmStructure.getClassNameId(), this._getDDMStructureVersionId(dataDefinitionId), pagination.getStartPosition(), pagination.getEndPosition(), this._toOrderByComparator((Sort)ArrayUtil.getValue((Object[])sorts, (int)0))), ddmStructureLayout -> DataLayoutUtil.toDataLayout(this._ddmFormFieldTypeServicesRegistry, ddmStructureLayout, this._spiDDMFormRuleConverter)), (Pagination)pagination, (long)this._ddmStructureLayoutLocalService.getStructureLayoutsCount(ddmStructure.getGroupId(), ddmStructure.getClassNameId(), this._getDDMStructureVersionId(dataDefinitionId)));
        }
        return SearchUtil.search(Collections.emptyMap(), booleanQuery -> {}, null, (String)DDMStructureLayout.class.getName(), (String)keywords, (Pagination)pagination, queryConfig -> queryConfig.setSelectedFieldNames(new String[]{"entryClassPK"}), searchContext -> {
            searchContext.setAttribute("classNameId", (Serializable)Long.valueOf(ddmStructure.getClassNameId()));
            searchContext.setAttribute("description", (Serializable)((Object)keywords));
            searchContext.setAttribute("name", (Serializable)((Object)keywords));
            searchContext.setAttribute("structureVersionId", (Serializable)Long.valueOf(this._getDDMStructureVersionId(dataDefinitionId)));
            searchContext.setCompanyId(ddmStructure.getCompanyId());
            searchContext.setGroupIds(new long[]{ddmStructure.getGroupId()});
        }, (Sort[])sorts, document -> DataLayoutUtil.toDataLayout(this._ddmFormFieldTypeServicesRegistry, this._ddmStructureLayoutLocalService.getStructureLayout(GetterUtil.getLong((String)document.get("entryClassPK"))), this._spiDDMFormRuleConverter));
    }

    private long _getDDMStructureVersionId(long deDataDefinitionId) throws PortalException {
        DDMStructureVersion ddmStructureVersion = this._ddmStructureVersionLocalService.getLatestStructureVersion(deDataDefinitionId);
        return ddmStructureVersion.getStructureVersionId();
    }

    private List<String> _getFieldNames(String content) {
        DocumentContext documentContext = JsonPath.parse((String)content);
        return (List)documentContext.read("$[\"pages\"][*][\"rows\"][*][\"columns\"][*][\"fieldNames\"][*]", new Predicate[0]);
    }

    private void _initThemeDisplay(DataLayoutRenderingContext dataLayoutRenderingContext) throws Exception {
        ServicePreAction servicePreAction = new ServicePreAction();
        DummyHttpServletResponse httpServletResponse = new DummyHttpServletResponse();
        servicePreAction.servicePre(this.contextHttpServletRequest, (HttpServletResponse)httpServletResponse, false);
        ThemeServicePreAction themeServicePreAction = new ThemeServicePreAction();
        themeServicePreAction.run(this.contextHttpServletRequest, (HttpServletResponse)httpServletResponse);
        ThemeDisplay themeDisplay = (ThemeDisplay)this.contextHttpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        themeDisplay.setScopeGroupId(dataLayoutRenderingContext.getScopeGroupId().longValue());
        themeDisplay.setSiteGroupId(dataLayoutRenderingContext.getSiteGroupId().longValue());
    }

    private DataLayoutValidationException _toDataLayoutValidationException(DDMFormLayoutValidationException ddmFormLayoutValidationException) {
        if (ddmFormLayoutValidationException instanceof DDMFormLayoutValidationException.InvalidColumnSize) {
            return new DataLayoutValidationException.InvalidColumnSize();
        }
        if (ddmFormLayoutValidationException instanceof DDMFormLayoutValidationException.InvalidRowSize) {
            return new DataLayoutValidationException.InvalidRowSize();
        }
        if (ddmFormLayoutValidationException instanceof DDMFormLayoutValidationException.MustNotDuplicateFieldName) {
            DDMFormLayoutValidationException.MustNotDuplicateFieldName mustNotDuplicateFieldName = (DDMFormLayoutValidationException.MustNotDuplicateFieldName)ddmFormLayoutValidationException;
            return new DataLayoutValidationException.MustNotDuplicateFieldName(mustNotDuplicateFieldName.getDuplicatedFieldNames());
        }
        if (ddmFormLayoutValidationException instanceof DDMFormLayoutValidationException.MustSetDefaultLocale) {
            return new DataLayoutValidationException.MustSetDefaultLocale();
        }
        if (ddmFormLayoutValidationException instanceof DDMFormLayoutValidationException.MustSetEqualLocaleForLayoutAndTitle) {
            return new DataLayoutValidationException.MustSetEqualLocaleForLayoutAndTitle();
        }
        return new DataLayoutValidationException(ddmFormLayoutValidationException.getCause());
    }

    private DataLayoutValidationException _toDataLayoutValidationException(DDMFormValidationException ddmFormValidationException) {
        if (ddmFormValidationException instanceof DDMFormValidationException.MustSetValidFormRuleExpression) {
            return new DataLayoutValidationException.MustSetValidRuleExpression();
        }
        return new DataLayoutValidationException(ddmFormValidationException.getCause());
    }

    private OrderByComparator<DDMStructureLayout> _toOrderByComparator(Sort sort) {
        boolean ascending = !sort.isReverse();
        String sortFieldName = sort.getFieldName();
        if (StringUtil.startsWith((String)sortFieldName, (String)"createDate")) {
            return new StructureLayoutCreateDateComparator(ascending);
        }
        if (StringUtil.startsWith((String)sortFieldName, (String)"localized_name")) {
            return new StructureLayoutNameComparator(ascending);
        }
        return new StructureLayoutModifiedDateComparator(ascending);
    }

    private String _updateContent(String content, String definitionSchemaVersion) throws Exception {
        JSONObject jsonObject = this._jsonFactory.createJSONObject(content);
        jsonObject.put("definitionSchemaVersion", definitionSchemaVersion);
        return jsonObject.toString();
    }

    private DataLayout _updateDataLayout(long dataLayoutId, String content, Map<String, Object> description, Map<String, Object> name) throws Exception {
        DDMStructureLayout ddmStructureLayout = this._ddmStructureLayoutLocalService.getStructureLayout(dataLayoutId);
        DDMFormLayout ddmFormLayout = ddmStructureLayout.getDDMFormLayout();
        content = this._updateContent(content, ddmFormLayout.getDefinitionSchemaVersion());
        DDMStructure ddmStructure = ddmStructureLayout.getDDMStructure();
        ddmStructureLayout = this._ddmStructureLayoutLocalService.updateStructureLayout(dataLayoutId, this._getDDMStructureVersionId(ddmStructure.getStructureId()), LocalizedValueUtil.toLocaleStringMap(name), LocalizedValueUtil.toLocaleStringMap(description), content, new ServiceContext());
        this._deDataDefinitionFieldLinkLocalService.deleteDEDataDefinitionFieldLinks(this._portal.getClassNameId(DDMStructureLayout.class), dataLayoutId);
        this._addDataDefinitionFieldLinks(ddmStructure.getStructureId(), ddmStructureLayout.getStructureLayoutId(), ddmStructure.getDDMForm(), this._getFieldNames(content), ddmStructureLayout.getGroupId());
        return DataLayoutUtil.toDataLayout(this._ddmFormFieldTypeServicesRegistry, ddmStructureLayout, this._spiDDMFormRuleConverter);
    }

    private void _validate(DataLayout dataLayout, DDMStructure ddmStructure) throws Exception {
        try {
            this._ddmFormLayoutValidator.validate(DataLayoutUtil.toDDMFormLayout(dataLayout, ddmStructure.getFullHierarchyDDMForm(), this._ddmFormFieldTypeServicesRegistry, this._ddmFormRuleDeserializer));
        }
        catch (DDMFormLayoutValidationException ddmFormLayoutValidationException) {
            throw this._toDataLayoutValidationException(ddmFormLayoutValidationException);
        }
        catch (DDMFormValidationException ddmFormValidationException) {
            throw this._toDataLayoutValidationException(ddmFormValidationException);
        }
        catch (Exception exception) {
            throw new DataLayoutValidationException((Throwable)exception);
        }
    }
}

