Liferay.Loader.define("data-engine-taglib@2.4.1/data_layout_builder/js/components/rules/RuleEditorModal.es", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/button', '@frontend-taglib-clay$clayui/form', '@frontend-taglib-clay$clayui/modal', 'dynamic-data-mapping-form-builder', 'frontend-js-react-web$react', '../../AppContext.es', '../../data-layout-builder/DataLayoutBuilderContext.es', '../../utils/client.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = void 0;

  var _button = _interopRequireDefault(require("@frontend-taglib-clay$clayui/button"));

  var _form = require("@frontend-taglib-clay$clayui/form");

  var _modal = _interopRequireWildcard(require("@frontend-taglib-clay$clayui/modal"));

  var _dynamicDataMappingFormBuilder = require("dynamic-data-mapping-form-builder");

  var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

  var _AppContext = _interopRequireDefault(require("../../AppContext.es"));

  var _DataLayoutBuilderContext = _interopRequireDefault(require("../../data-layout-builder/DataLayoutBuilderContext.es"));

  var _client = require("../../utils/client.es");

  function _getRequireWildcardCache() {
    if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
      return cache;
    };return cache;
  }

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
      return { "default": obj };
    }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
      return cache.get(obj);
    }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
      if (Object.prototype.hasOwnProperty.call(obj, key)) {
        var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
          Object.defineProperty(newObj, key, desc);
        } else {
          newObj[key] = obj[key];
        }
      }
    }newObj["default"] = obj;if (cache) {
      cache.set(obj, newObj);
    }return newObj;
  }

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(Object(source), true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  function _slicedToArray(arr, i) {
    return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
  }

  function _nonIterableRest() {
    throw new TypeError("Invalid attempt to destructure non-iterable instance");
  }

  function _iterableToArrayLimit(arr, i) {
    if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
      return;
    }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
      for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
        _arr.push(_s.value);if (i && _arr.length === i) break;
      }
    } catch (err) {
      _d = true;_e = err;
    } finally {
      try {
        if (!_n && _i["return"] != null) _i["return"]();
      } finally {
        if (_d) throw _e;
      }
    }return _arr;
  }

  function _arrayWithHoles(arr) {
    if (Array.isArray(arr)) return arr;
  }

  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  var RuleEditorWrapper =
  /*#__PURE__*/
  function (_RuleEditor) {
    _inherits(RuleEditorWrapper, _RuleEditor);

    function RuleEditorWrapper() {
      _classCallCheck(this, RuleEditorWrapper);

      return _possibleConstructorReturn(this, _getPrototypeOf(RuleEditorWrapper).apply(this, arguments));
    }

    _createClass(RuleEditorWrapper, [{
      key: "getChildContext",
      value: function getChildContext() {
        return {
          store: {
            editingLanguageId: 'en_US'
          }
        };
      }
    }]);

    return RuleEditorWrapper;
  }(_dynamicDataMappingFormBuilder.RuleEditor);

  var RuleEditorModalContent = function RuleEditorModalContent(_ref) {
    var onClose = _ref.onClose,
        rule = _ref.rule;
    var ruleEditorRef = (0, _react.useRef)();

    var _useState = (0, _react.useState)(null),
        _useState2 = _slicedToArray(_useState, 2),
        ruleEditor = _useState2[0],
        setRuleEditor = _useState2[1];

    var _useState3 = (0, _react.useState)(''),
        _useState4 = _slicedToArray(_useState3, 2),
        ruleName = _useState4[0],
        setRuleName = _useState4[1];

    var _useContext = (0, _react.useContext)(_AppContext["default"]),
        _useContext2 = _slicedToArray(_useContext, 1),
        _useContext2$ = _useContext2[0],
        ruleSettings = _useContext2$.config.ruleSettings,
        spritemap = _useContext2$.spritemap;

    var _useContext3 = (0, _react.useContext)(_DataLayoutBuilderContext["default"]),
        _useContext4 = _slicedToArray(_useContext3, 1),
        dataLayoutBuilder = _useContext4[0];

    var _dataLayoutBuilder$ge = dataLayoutBuilder.getStore(),
        pages = _dataLayoutBuilder$ge.pages;

    var _useState5 = (0, _react.useState)({
      isLoading: true,
      roles: []
    }),
        _useState6 = _slicedToArray(_useState5, 2),
        state = _useState6[0],
        setState = _useState6[1];

    var onChangeRuleName = (0, _react.useCallback)(function (value) {
      setRuleName(value);
    }, []);
    (0, _react.useEffect)(function () {
      if (rule) {
        onChangeRuleName(rule.name.en_US);
      }
    }, [onChangeRuleName, rule]);
    (0, _react.useEffect)(function () {
      var isLoading = state.isLoading,
          roles = state.roles;

      if (isLoading || ruleEditor !== null) {
        return;
      }

      var ruleEditorWrapper = new RuleEditorWrapper(_objectSpread({}, ruleSettings, {
        actions: [],
        conditions: [],
        events: {
          ruleAdded: function ruleAdded(rule) {
            dataLayoutBuilder.dispatch('ruleAdded', rule);
            onClose();
          },
          ruleCancelled: function ruleCancelled() {},
          ruleDeleted: function ruleDeleted() {},
          ruleEdited: function ruleEdited(rule) {
            dataLayoutBuilder.dispatch('ruleEdited', rule);
            onClose();
          }
        },
        key: 'create',
        pages: pages,
        ref: 'RuleEditor',
        roles: roles,
        rule: rule,
        spritemap: spritemap
      }, rule && {
        ruleEditedIndex: rule.ruleEditedIndex
      }), ruleEditorRef.current);
      setRuleEditor(ruleEditorWrapper);
    }, [dataLayoutBuilder, onClose, pages, ruleEditor, ruleEditorRef, rule, ruleSettings, spritemap, state]);
    (0, _react.useEffect)(function () {
      return function () {
        return ruleEditor && ruleEditor.dispose();
      };
    }, [ruleEditor]);
    (0, _react.useEffect)(function () {
      (0, _client.getItem)('/o/headless-admin-user/v1.0/roles').then(function (_ref2) {
        var _ref2$items = _ref2.items,
            roles = _ref2$items === void 0 ? [] : _ref2$items;
        roles = roles.map(function (_ref3) {
          var id = _ref3.id,
              name = _ref3.name;
          return {
            id: "".concat(id),
            label: name,
            name: name,
            value: "".concat(id)
          };
        });
        setState(function (prevState) {
          return _objectSpread({}, prevState, {
            isLoading: false,
            roles: roles
          });
        });
      });
    }, []);
    return _react["default"].createElement(_react["default"].Fragment, null, _react["default"].createElement(_modal["default"].Header, null, rule ? Liferay.Language.get('edit-rule') : Liferay.Language.get('add-rule')), _react["default"].createElement(_modal["default"].Header, {
      withTitle: false
    }, _react["default"].createElement(_form.ClayInput.Group, {
      className: "pl-4 pr-4"
    }, _react["default"].createElement(_form.ClayInput.GroupItem, null, _react["default"].createElement(_form.ClayInput, {
      "aria-label": Liferay.Language.get('untitled-rule'),
      className: "form-control-inline",
      onChange: function onChange(_ref4) {
        var value = _ref4.target.value;
        return onChangeRuleName(value);
      },
      placeholder: Liferay.Language.get('untitled-rule'),
      type: "text",
      value: ruleName
    })))), _react["default"].createElement(_modal["default"].Body, null, _react["default"].createElement("div", {
      className: "pl-4 pr-4",
      ref: ruleEditorRef
    })), _react["default"].createElement(_modal["default"].Footer, {
      last: _react["default"].createElement(_button["default"].Group, {
        spaced: true
      }, _react["default"].createElement(_button["default"], {
        displayType: "secondary",
        onClick: onClose
      }, Liferay.Language.get('cancel')), _react["default"].createElement(_button["default"], {
        disabled: !ruleName,
        onClick: function onClick() {
          return rule ? ruleEditor.handleRuleEdited({
            ruleName: ruleName
          }) : ruleEditor.handleRuleAdded({
            ruleName: ruleName
          });
        }
      }, Liferay.Language.get('save')))
    }));
  };

  var RuleEditorModal = function RuleEditorModal(_ref5) {
    var isVisible = _ref5.isVisible,
        onClose = _ref5.onClose,
        rule = _ref5.rule;

    var _useModal = (0, _modal.useModal)({
      onClose: onClose
    }),
        observer = _useModal.observer;

    if (!isVisible) {
      return null;
    }

    return _react["default"].createElement(_modal["default"], {
      className: "data-layout-builder-rule-editor-modal",
      observer: observer,
      size: "full-screen"
    }, _react["default"].createElement(RuleEditorModalContent, {
      onClose: onClose,
      rule: rule
    }));
  };

  var _default = RuleEditorModal;
  exports["default"] = _default;
  //# sourceMappingURL=RuleEditorModal.es.js.map
});
//# sourceMappingURL=RuleEditorModal.es.js.map