Liferay.Loader.define("data-engine-taglib@2.4.1/data_layout_builder/js/drag-and-drop/DataLayoutBuilderColumnDropZone.es", ['module', 'exports', 'require', 'dynamic-data-mapping-form-renderer/js/components/FormRenderer/FormSupport.es', 'frontend-js-metal-web$metal-dom', 'frontend-js-react-web$react', 'frontend-js-react-web$react-dnd', '../AppContext.es', '../actions.es', './dragTypes.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = void 0;

  var _FormSupport = require("dynamic-data-mapping-form-renderer/js/components/FormRenderer/FormSupport.es");

  var _metalDom = _interopRequireDefault(require("frontend-js-metal-web$metal-dom"));

  var _react = require("frontend-js-react-web$react");

  var _reactDnd = require("frontend-js-react-web$react-dnd");

  var _AppContext = _interopRequireDefault(require("../AppContext.es"));

  var _actions = require("../actions.es");

  var _dragTypes = require("./dragTypes.es");

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(Object(source), true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  function _slicedToArray(arr, i) {
    return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
  }

  function _nonIterableRest() {
    throw new TypeError("Invalid attempt to destructure non-iterable instance");
  }

  function _iterableToArrayLimit(arr, i) {
    if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
      return;
    }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
      for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
        _arr.push(_s.value);if (i && _arr.length === i) break;
      }
    } catch (err) {
      _d = true;_e = err;
    } finally {
      try {
        if (!_n && _i["return"] != null) _i["return"]();
      } finally {
        if (_d) throw _e;
      }
    }return _arr;
  }

  function _arrayWithHoles(arr) {
    if (Array.isArray(arr)) return arr;
  }

  var replaceColumn = function replaceColumn(node) {
    if (node.parentNode) {
      node.parentNode.replaceChild(node.cloneNode(true), node);
    }
  };

  var _default = function _default(_ref) {
    var dataLayoutBuilder = _ref.dataLayoutBuilder,
        node = _ref.node;

    var _useContext = (0, _react.useContext)(_AppContext["default"]),
        _useContext2 = _slicedToArray(_useContext, 1),
        dataDefinition = _useContext2[0].dataDefinition;

    var onDrop = (0, _react.useCallback)(function (_ref2, monitor) {
      var data = _ref2.data,
          type = _ref2.type;

      if (monitor.didDrop()) {
        return;
      }

      var fieldName = node.dataset.fieldName;
      var indexes = (0, _FormSupport.getIndexes)(node.parentElement);
      var parentFieldName;

      var parentFieldNode = _metalDom["default"].closest(node.parentElement, '.ddm-field');

      if (parentFieldNode) {
        parentFieldName = parentFieldNode.dataset.fieldName;
      }

      if (type === _dragTypes.DRAG_FIELD_TYPE) {
        var payload = (0, _actions.dropLayoutBuilderField)({
          dataLayoutBuilder: dataLayoutBuilder,
          fieldName: fieldName,
          fieldTypeName: data.name,
          indexes: indexes,
          parentFieldName: parentFieldName
        });

        if (_metalDom["default"].closest(node, '.col-empty')) {
          var addedToPlaceholder = _metalDom["default"].closest(node, '.placeholder');

          dataLayoutBuilder.dispatch('fieldAdded', _objectSpread({
            addedToPlaceholder: addedToPlaceholder
          }, payload));
        } else {
          dataLayoutBuilder.dispatch('sectionAdded', payload);
        }
      } else if (type === _dragTypes.DRAG_DATA_DEFINITION_FIELD) {
        var _payload = (0, _actions.dropCustomObjectField)({
          dataDefinition: dataDefinition,
          dataDefinitionFieldName: data.name,
          dataLayoutBuilder: dataLayoutBuilder,
          fieldName: fieldName,
          indexes: indexes,
          parentFieldName: parentFieldName
        });

        if (_metalDom["default"].closest(node, '.col-empty')) {
          var _addedToPlaceholder = _metalDom["default"].closest(node, '.placeholder');

          dataLayoutBuilder.dispatch('fieldAdded', _objectSpread({
            addedToPlaceholder: _addedToPlaceholder
          }, _payload));
        } else {
          dataLayoutBuilder.dispatch('sectionAdded', _payload);
        }
      } else if (type === _dragTypes.DRAG_FIELDSET) {
        dataLayoutBuilder.dispatch('fieldSetAdded', (0, _actions.dropFieldSet)({
          dataLayoutBuilder: dataLayoutBuilder,
          fieldName: fieldName,
          fieldSet: data.fieldSet,
          indexes: indexes,
          parentFieldName: parentFieldName
        }));
      }
    }, [dataDefinition, dataLayoutBuilder, node]);

    var _useDrop = (0, _reactDnd.useDrop)({
      accept: [_dragTypes.DRAG_DATA_DEFINITION_FIELD, _dragTypes.DRAG_FIELDSET, _dragTypes.DRAG_FIELD_TYPE],
      collect: function collect(monitor) {
        return {
          canDrop: monitor.canDrop(),
          overTarget: monitor.isOver()
        };
      },
      drop: onDrop
    }),
        _useDrop2 = _slicedToArray(_useDrop, 2),
        _useDrop2$ = _useDrop2[0],
        canDrop = _useDrop2$.canDrop,
        overTarget = _useDrop2$.overTarget,
        dropColumn = _useDrop2[1];

    (0, _react.useEffect)(function () {
      dropColumn(node);
      return function () {
        return replaceColumn(node);
      };
    }, [dropColumn, node]);
    (0, _react.useEffect)(function () {
      var classList = node.classList;

      if (canDrop && classList.contains('ddm-empty-page')) {
        classList.add('target-droppable');
      } else {
        classList.remove('target-droppable');
      }

      var parentFieldNode = _metalDom["default"].closest(node.parentElement, ".ddm-field-container");

      if (overTarget) {
        classList.add('target-over');
        classList.add('targetOver');

        if (parentFieldNode) {
          parentFieldNode.classList.add('active-drop-child');
        }
      } else {
        classList.remove('target-over');
        classList.remove('targetOver');

        if (parentFieldNode && !parentFieldNode.querySelector('.target-over')) {
          parentFieldNode.classList.remove('active-drop-child');
        }
      }
    }, [canDrop, node, overTarget]);
    return null;
  };

  exports["default"] = _default;
  //# sourceMappingURL=DataLayoutBuilderColumnDropZone.es.js.map
});
//# sourceMappingURL=DataLayoutBuilderColumnDropZone.es.js.map