Liferay.Loader.define("data-engine-taglib@2.4.1/data_layout_builder/js/drag-and-drop/DragLayer.es", ['module', 'exports', 'require', 'frontend-js-react-web$react', 'frontend-js-react-web$react-dnd'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = void 0;

  var _react = _interopRequireDefault(require("frontend-js-react-web$react"));

  var _reactDnd = require("frontend-js-react-web$react-dnd");

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(Object(source), true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  var layerStyles = {
    cursor: 'grabbing',
    height: '100%',
    left: 0,
    pointerEvents: 'none',
    position: 'fixed',
    top: 0,
    width: '100%',
    zIndex: 150
  };

  function getItemStyles(initialOffset, currentOffset) {
    if (!initialOffset || !currentOffset) {
      return {
        display: 'none'
      };
    }

    var x = currentOffset.x,
        y = currentOffset.y;
    var transform = "translate(".concat(x, "px, ").concat(y, "px)");
    return {
      WebkitTransform: transform,
      transform: transform
    };
  }

  var _default = function _default() {
    var _useDragLayer = (0, _reactDnd.useDragLayer)(function (monitor) {
      return {
        currentOffset: monitor.getSourceClientOffset(),
        initialOffset: monitor.getInitialSourceClientOffset(),
        isDragging: monitor.isDragging(),
        item: monitor.getItem(),
        itemType: monitor.getItemType()
      };
    }),
        currentOffset = _useDragLayer.currentOffset,
        initialOffset = _useDragLayer.initialOffset,
        isDragging = _useDragLayer.isDragging,
        item = _useDragLayer.item;

    if (!isDragging) {
      return null;
    }

    var preview = item.preview;
    return _react["default"].createElement("div", {
      style: _objectSpread({}, layerStyles, {
        zIndex: 200
      })
    }, _react["default"].createElement("div", {
      style: getItemStyles(initialOffset, currentOffset, isDragging)
    }, preview && preview()));
  };

  exports["default"] = _default;
  //# sourceMappingURL=DragLayer.es.js.map
});
//# sourceMappingURL=DragLayer.es.js.map