Liferay.Loader.define('data-engine-taglib$dnd-core@10.0.1/lib/actions/dragDrop/endDrag', ['module', 'exports', 'require'], function (module, exports, require) {
    var define = undefined;
    import { invariant } from '@react-dnd/invariant';
    import { END_DRAG } from './types';
    export default function createEndDrag(manager) {
        return function endDrag() {
            const monitor = manager.getMonitor();
            const registry = manager.getRegistry();
            verifyIsDragging(monitor);
            const sourceId = monitor.getSourceId();
            const source = registry.getSource(sourceId, true);
            source.endDrag(monitor, sourceId);
            registry.unpinSource();
            return { type: END_DRAG };
        };
    }
    function verifyIsDragging(monitor) {
        invariant(monitor.isDragging(), 'Cannot call endDrag while not dragging.');
    }
});
//# sourceMappingURL=endDrag.js.map