'use strict';

/**
 * Copyright 2015, Yahoo! Inc.
 * Copyrights licensed under the New BSD License. See the accompanying LICENSE file for terms.
 */

Liferay.Loader.define('data-engine-taglib$hoist-non-react-statics@3.3.0/dist/hoist-non-react-statics.cjs', ['module', 'exports', 'require', 'data-engine-taglib$react-is'], function (module, exports, require) {
    var define = undefined;
    var ReactIs = require('data-engine-taglib$react-is');
    var REACT_STATICS = {
        childContextTypes: true,
        contextType: true,
        contextTypes: true,
        defaultProps: true,
        displayName: true,
        getDefaultProps: true,
        getDerivedStateFromError: true,
        getDerivedStateFromProps: true,
        mixins: true,
        propTypes: true,
        type: true
    };

    var KNOWN_STATICS = {
        name: true,
        length: true,
        prototype: true,
        caller: true,
        callee: true,
        arguments: true,
        arity: true
    };

    var FORWARD_REF_STATICS = {
        '$$typeof': true,
        render: true,
        defaultProps: true,
        displayName: true,
        propTypes: true
    };

    var MEMO_STATICS = {
        '$$typeof': true,
        compare: true,
        defaultProps: true,
        displayName: true,
        propTypes: true,
        type: true
    };

    var TYPE_STATICS = {};
    TYPE_STATICS[ReactIs.ForwardRef] = FORWARD_REF_STATICS;

    function getStatics(component) {
        if (ReactIs.isMemo(component)) {
            return MEMO_STATICS;
        }
        return TYPE_STATICS[component['$$typeof']] || REACT_STATICS;
    }

    var defineProperty = Object.defineProperty;
    var getOwnPropertyNames = Object.getOwnPropertyNames;
    var getOwnPropertySymbols = Object.getOwnPropertySymbols;
    var getOwnPropertyDescriptor = Object.getOwnPropertyDescriptor;
    var getPrototypeOf = Object.getPrototypeOf;
    var objectPrototype = Object.prototype;

    function hoistNonReactStatics(targetComponent, sourceComponent, blacklist) {
        if (typeof sourceComponent !== 'string') {
            // don't hoist over string (html) components

            if (objectPrototype) {
                var inheritedComponent = getPrototypeOf(sourceComponent);
                if (inheritedComponent && inheritedComponent !== objectPrototype) {
                    hoistNonReactStatics(targetComponent, inheritedComponent, blacklist);
                }
            }

            var keys = getOwnPropertyNames(sourceComponent);

            if (getOwnPropertySymbols) {
                keys = keys.concat(getOwnPropertySymbols(sourceComponent));
            }

            var targetStatics = getStatics(targetComponent);
            var sourceStatics = getStatics(sourceComponent);

            for (var i = 0; i < keys.length; ++i) {
                var key = keys[i];
                if (!KNOWN_STATICS[key] && !(blacklist && blacklist[key]) && !(sourceStatics && sourceStatics[key]) && !(targetStatics && targetStatics[key])) {
                    var descriptor = getOwnPropertyDescriptor(sourceComponent, key);
                    try {
                        // Avoid failures from read-only properties
                        defineProperty(targetComponent, key, descriptor);
                    } catch (e) {}
                }
            }

            return targetComponent;
        }

        return targetComponent;
    }

    module.exports = hoistNonReactStatics;
});
//# sourceMappingURL=hoist-non-react-statics.cjs.js.map