Liferay.Loader.define("data-engine-taglib@2.4.7/data_layout_builder/js/components/rules/RuleItem.es", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/button', '@frontend-taglib-clay$clayui/label', 'frontend-js-react-web$classnames', 'frontend-js-react-web$react', '../../AppContext.es', '../../actions.es', '../collapsable-panel/CollapsablePanel.es'], function (module, exports, require) {
  var define = undefined;
  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = RuleItem;

  var _button = _interopRequireDefault(require("@frontend-taglib-clay$clayui/button"));

  var _label = _interopRequireDefault(require("@frontend-taglib-clay$clayui/label"));

  var _classnames = _interopRequireDefault(require("frontend-js-react-web$classnames"));

  var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

  var _AppContext = _interopRequireDefault(require("../../AppContext.es"));

  var _actions = require("../../actions.es");

  var _CollapsablePanel = _interopRequireDefault(require("../collapsable-panel/CollapsablePanel.es"));

  function _getRequireWildcardCache() {
    if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
      return cache;
    };return cache;
  }

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
      return { "default": obj };
    }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
      return cache.get(obj);
    }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
      if (Object.prototype.hasOwnProperty.call(obj, key)) {
        var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
          Object.defineProperty(newObj, key, desc);
        } else {
          newObj[key] = obj[key];
        }
      }
    }newObj["default"] = obj;if (cache) {
      cache.set(obj, newObj);
    }return newObj;
  }

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _slicedToArray(arr, i) {
    return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
  }

  function _nonIterableRest() {
    throw new TypeError("Invalid attempt to destructure non-iterable instance");
  }

  function _iterableToArrayLimit(arr, i) {
    if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
      return;
    }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
      for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
        _arr.push(_s.value);if (i && _arr.length === i) break;
      }
    } catch (err) {
      _d = true;_e = err;
    } finally {
      try {
        if (!_n && _i["return"] != null) _i["return"]();
      } finally {
        if (_d) throw _e;
      }
    }return _arr;
  }

  function _arrayWithHoles(arr) {
    if (Array.isArray(arr)) return arr;
  }

  var Text = function Text(_ref) {
    var _ref$capitalize = _ref.capitalize,
        capitalize = _ref$capitalize === void 0 ? false : _ref$capitalize,
        _ref$children = _ref.children,
        children = _ref$children === void 0 ? '' : _ref$children,
        _ref$lowercase = _ref.lowercase,
        lowercase = _ref$lowercase === void 0 ? false : _ref$lowercase;
    return _react["default"].createElement("span", {
      className: (0, _classnames["default"])('pr-1', {
        'text-capitalize': capitalize,
        'text-lowercase': lowercase
      })
    }, children);
  };

  var OPERATOR_LABELS = {
    'belongs-to': Liferay.Language.get('belongs-to'),
    contains: Liferay.Language.get('contains'),
    'equals-to': Liferay.Language.get('equals-to'),
    'is-empty': Liferay.Language.get('is-empty'),
    'not-contains': Liferay.Language.get('not-contains'),
    'not-equals-to': Liferay.Language.get('not-equals-to'),
    'not-is-empty': Liferay.Language.get('not-is-empty')
  };

  function RuleItem(_ref2) {
    var rule = _ref2.rule,
        toggleRulesEditorVisibility = _ref2.toggleRulesEditorVisibility;
    var actions = rule.actions,
        conditions = rule.conditions,
        logicalOperator = rule.logicalOperator,
        name = rule.name.en_US;

    var _useContext = (0, _react.useContext)(_AppContext["default"]),
        _useContext2 = _slicedToArray(_useContext, 2),
        dispatch = _useContext2[1];

    var dropDownActions = [{
      action: function action() {
        return toggleRulesEditorVisibility(rule);
      },
      name: Liferay.Language.get('edit')
    }, {
      action: function action() {
        var confirmed = confirm(Liferay.Language.get('are-you-sure-you-want-to-delete-this'));

        if (confirmed) {
          dispatch({
            payload: rule,
            type: _actions.DELETE_DATA_LAYOUT_RULE
          });
        }
      },
      name: Liferay.Language.get('delete')
    }];
    return _react["default"].createElement(_CollapsablePanel["default"], {
      actions: dropDownActions,
      title: name
    }, _react["default"].createElement(_button["default"], {
      displayType: "unstyled",
      onClick: function onClick() {
        return toggleRulesEditorVisibility(rule);
      }
    }, _react["default"].createElement(Text, {
      capitalize: true
    }, Liferay.Language.get('if')), conditions.map(function (_ref3, index) {
      var operands = _ref3.operands,
          operator = _ref3.operator;

      var _operands = _slicedToArray(operands, 2),
          first = _operands[0],
          last = _operands[1];

      return _react["default"].createElement(_react["default"].Fragment, null, _react["default"].createElement(Text, {
        lowercase: true
      }, Liferay.Language.get('field')), _react["default"].createElement(_label["default"], {
        displayType: "success"
      }, first.value), _react["default"].createElement(_label["default"], {
        displayType: "secondary"
      }, OPERATOR_LABELS[operator] || operator), last && last.value && _react["default"].createElement(_label["default"], {
        displayType: "info"
      }, last.value), index + 1 !== conditions.length && _react["default"].createElement(_label["default"], {
        displayType: "warning"
      }, logicalOperator));
    }), _react["default"].createElement(Text, null, Liferay.Language.get('then')), actions.map(function (_ref4, index) {
      var action = _ref4.action,
          target = _ref4.target;
      return _react["default"].createElement(_react["default"].Fragment, null, _react["default"].createElement(Text, {
        lowercase: true
      }, action), _react["default"].createElement(_label["default"], {
        displayType: "success"
      }, target), index + 1 !== actions.length && _react["default"].createElement(_label["default"], {
        displayType: "warning"
      }, Liferay.Language.get('and')));
    })));
  }
  //# sourceMappingURL=RuleItem.es.js.map
});
//# sourceMappingURL=RuleItem.es.js.map