Liferay.Loader.define("data-engine-taglib@2.4.7/data_layout_builder/js/data-layout-builder/saveDefinitionAndLayout.es", ['module', 'exports', 'require', 'frontend-js-web'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = exports.updateItem = exports.getURL = exports.addItem = void 0;

  var _frontendJsWeb = require("frontend-js-web");

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(Object(source), true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  var HEADERS = {
    Accept: 'application/json',
    'Accept-Language': Liferay.ThemeDisplay.getBCP47LanguageId(),
    'Content-Type': 'application/json'
  };

  var addItem = function addItem(endpoint, item) {
    return (0, _frontendJsWeb.fetch)(getURL(endpoint), {
      body: JSON.stringify(item),
      headers: HEADERS,
      method: 'POST'
    }).then(function (response) {
      return response.json();
    });
  };

  exports.addItem = addItem;

  var getURL = function getURL(path, params) {
    var _objectSpread2;

    params = _objectSpread((_objectSpread2 = {}, _defineProperty(_objectSpread2, 'p_auth', Liferay.authToken), _defineProperty(_objectSpread2, "t", Date.now()), _objectSpread2), params);
    var uri = new URL("".concat(window.location.origin).concat(path));
    var keys = Object.keys(params);
    keys.forEach(function (key) {
      return uri.searchParams.set(key, params[key]);
    });
    return uri.toString();
  };

  exports.getURL = getURL;

  var updateItem = function updateItem(endpoint, item, params) {
    return (0, _frontendJsWeb.fetch)(getURL(endpoint, params), {
      body: JSON.stringify(item),
      headers: HEADERS,
      method: 'PUT'
    }).then(function (response) {
      return response.text();
    }).then(function (text) {
      return text ? JSON.parse(text) : {};
    });
  };

  exports.updateItem = updateItem;

  var _default = function _default(_ref) {
    var contentType = _ref.contentType,
        dataDefinition = _ref.dataDefinition,
        dataDefinitionId = _ref.dataDefinitionId,
        dataLayout = _ref.dataLayout,
        groupId = _ref.groupId,
        _ref$params = _ref.params,
        params = _ref$params === void 0 ? {} : _ref$params;

    var normalizedDataLayout = _objectSpread({}, dataLayout, {
      dataLayoutPages: dataLayout.dataLayoutPages.map(function (dataLayoutPage) {
        return _objectSpread({}, dataLayoutPage, {
          dataLayoutRows: (dataLayoutPage.dataLayoutRows || []).map(function (dataLayoutRow) {
            return _objectSpread({}, dataLayoutRow, {
              dataLayoutColumns: (dataLayoutRow.dataLayoutColumns || []).map(function (dataLayoutColumn) {
                return _objectSpread({}, dataLayoutColumn, {
                  fieldNames: dataLayoutColumn.fieldNames || []
                });
              })
            });
          }),
          description: dataLayoutPage.description || _defineProperty({}, themeDisplay.getLanguageId(), ''),
          title: dataLayoutPage.title || _defineProperty({}, themeDisplay.getLanguageId(), '')
        });
      })
    }, params.dataLayout || {});

    return function saveDataDefinitionDataLayout() {
      if (dataDefinitionId) {
        return updateItem("/o/data-engine/v2.0/data-definitions/".concat(dataDefinitionId), _objectSpread({}, dataDefinition, {}, params.dataDefinition || {}, {
          defaultDataLayout: normalizedDataLayout
        }));
      }

      var endpoint = "/o/data-engine/v2.0/data-definitions/by-content-type/".concat(contentType);

      if (groupId > 0) {
        endpoint = "/o/data-engine/v2.0/sites/".concat(groupId, "/data-definitions/by-content-type/").concat(contentType);
      }

      return addItem(endpoint, _objectSpread({}, dataDefinition, {}, params.dataDefinition || {}, {
        defaultDataLayout: normalizedDataLayout
      }));
    }();
  };

  exports["default"] = _default;
  //# sourceMappingURL=saveDefinitionAndLayout.es.js.map
});
//# sourceMappingURL=saveDefinitionAndLayout.es.js.map