Liferay.Loader.define("data-engine-taglib@2.4.7/data_layout_builder/js/hooks/useLazy.es", ['module', 'exports', 'require', 'frontend-js-react-web$react'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = useLazy;

  var _react = _interopRequireDefault(require("frontend-js-react-web$react"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  /**
   * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
   *
   * This library is free software; you can redistribute it and/or modify it under
   * the terms of the GNU Lesser General Public License as published by the Free
   * Software Foundation; either version 2.1 of the License, or (at your option)
   * any later version.
   *
   * This library is distributed in the hope that it will be useful, but WITHOUT
   * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
   * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
   * details.
   */
  var lazy = _react["default"].lazy,
      useCallback = _react["default"].useCallback,
      useRef = _react["default"].useRef;
  /**
   * Returns a component that takes a `pluginId` and a `getInstance`
   * function (for obtaining a promise of a plugin instance) and wraps it
   * in a `React.lazy` wrapper.
   *
   * The supplied callback will be called with the plugin instance once the
   * promise resolves, and should return something to be rendered.
   */

  function useLazy(callback) {
    var components = useRef(new Map());
    return useCallback(function (_ref) {
      var getInstance = _ref.getInstance,
          pluginId = _ref.pluginId;

      if (!components.current.has(pluginId)) {
        var plugin = getInstance(pluginId);

        var _Component = lazy(function () {
          return plugin.then(function (instance) {
            return {
              "default": function _default() {
                if (instance) {
                  return callback({
                    instance: instance
                  });
                } else {
                  return null;
                }
              }
            };
          });
        });

        components.current.set(pluginId, _Component);
      }

      var Component = components.current.get(pluginId);
      return _react["default"].createElement(Component, null);
    }, [callback]);
  }
  //# sourceMappingURL=useLazy.es.js.map
});
//# sourceMappingURL=useLazy.es.js.map