Liferay.Loader.define("data-engine-taglib@2.4.7/data_layout_builder/js/utils/client.es", ['module', 'exports', 'require', 'frontend-js-web'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.updateItem = exports.getURL = exports.getItem = exports.request = exports.deleteItem = exports.confirmDelete = exports.addItem = void 0;

  var _frontendJsWeb = require("frontend-js-web");

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(Object(source), true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  var HEADERS = {
    Accept: 'application/json',
    'Accept-Language': Liferay.ThemeDisplay.getBCP47LanguageId(),
    'Content-Type': 'application/json'
  };

  var addItem = function addItem(endpoint, item) {
    return (0, _frontendJsWeb.fetch)(getURL(endpoint), {
      body: JSON.stringify(item),
      headers: HEADERS,
      method: 'POST'
    }).then(function (response) {
      return response.json();
    });
  };

  exports.addItem = addItem;

  var confirmDelete = function confirmDelete(endpoint) {
    return function (item) {
      return new Promise(function (resolve, reject) {
        var confirmed = confirm(Liferay.Language.get('are-you-sure-you-want-to-delete-this'));

        if (confirmed) {
          deleteItem(endpoint + item.id).then(function () {
            return resolve(true);
          })["catch"](function (error) {
            return reject(error);
          });
        } else {
          resolve(false);
        }
      });
    };
  };

  exports.confirmDelete = confirmDelete;

  var deleteItem = function deleteItem(endpoint) {
    return (0, _frontendJsWeb.fetch)(getURL(endpoint), {
      method: 'DELETE'
    });
  };

  exports.deleteItem = deleteItem;

  var request = function request(endpoint) {
    var method = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'GET';
    return (0, _frontendJsWeb.fetch)(getURL(endpoint), {
      headers: HEADERS,
      method: method
    });
  };

  exports.request = request;

  var getItem = function getItem(endpoint) {
    return (0, _frontendJsWeb.fetch)(getURL(endpoint), {
      headers: HEADERS,
      method: 'GET'
    }).then(function (response) {
      return response.json();
    });
  };

  exports.getItem = getItem;

  var getURL = function getURL(path, params) {
    var _objectSpread2;

    params = _objectSpread((_objectSpread2 = {}, _defineProperty(_objectSpread2, 'p_auth', Liferay.authToken), _defineProperty(_objectSpread2, "t", Date.now()), _objectSpread2), params);
    var uri = new URL("".concat(window.location.origin).concat(path));
    var keys = Object.keys(params);
    keys.forEach(function (key) {
      return uri.searchParams.set(key, params[key]);
    });
    return uri.toString();
  };

  exports.getURL = getURL;

  var updateItem = function updateItem(endpoint, item, params) {
    return (0, _frontendJsWeb.fetch)(getURL(endpoint, params), {
      body: JSON.stringify(item),
      headers: HEADERS,
      method: 'PUT'
    }).then(function (response) {
      return response.text();
    }).then(function (text) {
      return text ? JSON.parse(text) : {};
    });
  };

  exports.updateItem = updateItem;
  //# sourceMappingURL=client.es.js.map
});
//# sourceMappingURL=client.es.js.map