Liferay.Loader.define("data-engine-taglib@2.4.7/data_layout_builder/js/utils/dataDefinition.es", ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.getOptionLabel = exports.getFieldLabel = exports.getDataDefinitionField = exports.forEachDataDefinitionField = exports.containsFieldSet = void 0;

  /**
   * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
   *
   * This library is free software; you can redistribute it and/or modify it under
   * the terms of the GNU Lesser General Public License as published by the Free
   * Software Foundation; either version 2.1 of the License, or (at your option)
   * any later version.
   *
   * This library is distributed in the hope that it will be useful, but WITHOUT
   * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
   * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
   * details.
   */
  var containsFieldSet = function containsFieldSet(dataDefinition, dataDefinitionId) {
    var hasFieldSet = false;
    forEachDataDefinitionField(dataDefinition, function (dataDefinitionField) {
      var customProperties = dataDefinitionField.customProperties,
          fieldType = dataDefinitionField.fieldType;

      if (fieldType === 'fieldset' && customProperties && customProperties.ddmStructureId == dataDefinitionId) {
        hasFieldSet = true;
      }

      return hasFieldSet;
    });
    return hasFieldSet;
  };

  exports.containsFieldSet = containsFieldSet;

  var forEachDataDefinitionField = function forEachDataDefinitionField() {
    var dataDefinition = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {
      dataDefinitionFields: []
    };
    var fn = arguments.length > 1 ? arguments[1] : undefined;
    var _dataDefinition$dataD = dataDefinition.dataDefinitionFields,
        dataDefinitionFields = _dataDefinition$dataD === void 0 ? [] : _dataDefinition$dataD;

    for (var i = 0; i < dataDefinitionFields.length; i++) {
      var field = dataDefinitionFields[i];

      if (fn(field)) {
        return true;
      }

      if (forEachDataDefinitionField({
        dataDefinitionFields: field.nestedDataDefinitionFields || []
      }, fn)) {
        return true;
      }
    }

    return false;
  };

  exports.forEachDataDefinitionField = forEachDataDefinitionField;

  var getDataDefinitionField = function getDataDefinitionField() {
    var dataDefinition = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {
      dataDefinitionFields: []
    };
    var fieldName = arguments.length > 1 ? arguments[1] : undefined;
    var field = null;
    forEachDataDefinitionField(dataDefinition, function (currentField) {
      if (currentField.name === fieldName) {
        field = currentField;
        return true;
      }

      return false;
    });
    return field;
  };

  exports.getDataDefinitionField = getDataDefinitionField;

  var getFieldLabel = function getFieldLabel(dataDefinition, fieldName) {
    var field = getDataDefinitionField(dataDefinition, fieldName);
    return field ? field.label[themeDisplay.getLanguageId()] : fieldName;
  };

  exports.getFieldLabel = getFieldLabel;

  var getOptionLabel = function getOptionLabel() {
    var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    var value = arguments.length > 1 ? arguments[1] : undefined;
    return (options[themeDisplay.getLanguageId()] || []).reduce(function (result, option) {
      if (option.value === value) {
        return option.label;
      }

      return result;
    }, value);
  };

  exports.getOptionLabel = getOptionLabel;
  //# sourceMappingURL=dataDefinition.es.js.map
});
//# sourceMappingURL=dataDefinition.es.js.map