Liferay.Loader.define("data-engine-taglib@2.4.7/data_layout_builder/js/utils/renderSettingsForm.es", ['module', 'exports', 'require', 'dynamic-data-mapping-form-renderer', 'dynamic-data-mapping-form-renderer/js/containers/Form/Form.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = exports.getFilteredSettingsContext = exports.getEvents = void 0;

  var _dynamicDataMappingFormRenderer = require("dynamic-data-mapping-form-renderer");

  var _Form = _interopRequireDefault(require("dynamic-data-mapping-form-renderer/js/containers/Form/Form.es"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _toConsumableArray(arr) {
    return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread();
  }

  function _nonIterableSpread() {
    throw new TypeError("Invalid attempt to spread non-iterable instance");
  }

  function _iterableToArray(iter) {
    if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
  }

  function _arrayWithoutHoles(arr) {
    if (Array.isArray(arr)) {
      for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) {
        arr2[i] = arr[i];
      }return arr2;
    }
  }

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(Object(source), true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  var getEvents = function getEvents(dispatchEvent, settingsContext) {

    return {
      attached: function handleFormAttached() {
        this.evaluate();
      },
      evaluated: function handleFormEvaluated(pages) {
        dispatchEvent('focusedFieldEvaluationEnded', {
          settingsContext: _objectSpread({}, settingsContext, {
            pages: pages
          })
        });
      },
      fieldBlurred: function handleFieldBlurred(_ref) {
        var fieldInstance = _ref.fieldInstance,
            value = _ref.value;

        if (fieldInstance && !fieldInstance.isDisposed()) {
          var fieldName = fieldInstance.fieldName;
          dispatchEvent('fieldBlurred', {
            editingLanguageId: settingsContext.editingLanguageId,
            propertyName: fieldName,
            propertyValue: value
          });
        }
      },
      fieldEdited: function handleFieldEdited(_ref2) {
        var fieldInstance = _ref2.fieldInstance,
            value = _ref2.value;

        if (fieldInstance && !fieldInstance.isDisposed()) {
          var fieldName = fieldInstance.fieldName;
          dispatchEvent('fieldEdited', {
            editingLanguageId: settingsContext.editingLanguageId,
            propertyName: fieldName,
            propertyValue: value
          });
        }
      }
    };
  };

  exports.getEvents = getEvents;

  var getFilteredSettingsContext = function getFilteredSettingsContext(_ref3) {
    var config = _ref3.config,
        settingsContext = _ref3.settingsContext;

    var unsupportedTabs = _toConsumableArray(config.disabledTabs);

    var pages = settingsContext.pages.filter(function (page) {
      return !unsupportedTabs.includes(page.title);
    });
    var visitor = new _dynamicDataMappingFormRenderer.PagesVisitor(pages);
    var unsupportedProperties = [].concat(_toConsumableArray(config.unimplementedProperties), _toConsumableArray(config.disabledProperties));
    return _objectSpread({}, settingsContext, {
      pages: visitor.mapColumns(function (column) {
        return _objectSpread({}, column, {
          fields: column.fields.map(function (field) {
            var fieldName = field.fieldName;

            if (unsupportedProperties.includes(fieldName)) {
              return _objectSpread({}, field, {
                visibilityExpression: 'FALSE',
                visible: false
              });
            }

            if (fieldName === 'dataSourceType') {
              return _objectSpread({}, field, {
                predefinedValue: '["manual"]',
                readOnly: true
              });
            }

            return field;
          })
        });
      })
    });
  };

  exports.getFilteredSettingsContext = getFilteredSettingsContext;

  var _default = function _default(events, settingsContext, container) {
    var spritemap = "".concat(Liferay.ThemeDisplay.getPathThemeImages(), "/lexicon/icons.svg");
    return new _Form["default"](_objectSpread({}, settingsContext, {
      editable: true,
      events: events,
      spritemap: spritemap
    }), container);
  };

  exports["default"] = _default;
  //# sourceMappingURL=renderSettingsForm.es.js.map
});
//# sourceMappingURL=renderSettingsForm.es.js.map