Liferay.Loader.define('data-engine-taglib$moment@2.24.0/locale/ga', ['module', 'exports', 'require', '../moment'], function (module, exports, require) {
    var define = undefined;
    (function (global, factory) {
        typeof exports === 'object' && typeof module !== 'undefined' && typeof require === 'function' ? factory(require('../moment')) : typeof define === 'function' && define.amd ? define(['../moment'], factory) : factory(global.moment);
    })(this, function (moment) {
        'use strict';

        var ga = moment.defineLocale('ga', {
            months: ['Eanáir', 'Feabhra', 'Márta', 'Aibreán', 'Bealtaine', 'Méitheamh', 'Iúil', 'Lúnasa', 'Meán Fómhair', 'Deaireadh Fómhair', 'Samhain', 'Nollaig'],
            monthsShort: ['Eaná', 'Feab', 'Márt', 'Aibr', 'Beal', 'Méit', 'Iúil', 'Lúna', 'Meán', 'Deai', 'Samh', 'Noll'],
            monthsParseExact: true,
            weekdays: ['Dé Domhnaigh', 'Dé Luain', 'Dé Máirt', 'Dé Céadaoin', 'Déardaoin', 'Dé hAoine', 'Dé Satharn'],
            weekdaysShort: ['Dom', 'Lua', 'Mái', 'Céa', 'Déa', 'hAo', 'Sat'],
            weekdaysMin: ['Do', 'Lu', 'Má', 'Ce', 'Dé', 'hA', 'Sa'],
            longDateFormat: {
                LT: 'HH:mm',
                LTS: 'HH:mm:ss',
                L: 'DD/MM/YYYY',
                LL: 'D MMMM YYYY',
                LLL: 'D MMMM YYYY HH:mm',
                LLLL: 'dddd, D MMMM YYYY HH:mm'
            },
            calendar: {
                sameDay: '[Inniu ag] LT',
                nextDay: '[Amárach ag] LT',
                nextWeek: 'dddd [ag] LT',
                lastDay: '[Inné aig] LT',
                lastWeek: 'dddd [seo caite] [ag] LT',
                sameElse: 'L'
            },
            relativeTime: {
                future: 'i %s',
                past: '%s ó shin',
                s: 'cúpla soicind',
                ss: '%d soicind',
                m: 'nóiméad',
                mm: '%d nóiméad',
                h: 'uair an chloig',
                hh: '%d uair an chloig',
                d: 'lá',
                dd: '%d lá',
                M: 'mí',
                MM: '%d mí',
                y: 'bliain',
                yy: '%d bliain'
            },
            dayOfMonthOrdinalParse: /\d{1,2}(d|na|mh)/,
            ordinal: function (number) {
                var output = number === 1 ? 'd' : number % 10 === 2 ? 'na' : 'mh';
                return number + output;
            },
            week: {
                dow: 1, // Monday is the first day of the week.
                doy: 4 // The week that contains Jan 4th is the first week of the year.
            }
        });

        return ga;
    }); //! moment.js locale configuration
});
//# sourceMappingURL=ga.js.map