Liferay.Loader.define("data-engine-taglib@2.5.10/data_layout_builder/js/components/collapsable-panel/CollapsablePanel.es", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/button', '@frontend-taglib-clay$clayui/icon', '@frontend-taglib-clay$clayui/panel', 'frontend-js-react-web$classnames', 'frontend-js-react-web$react', '../../hooks/index.es', '../drop-down/DropDown.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = void 0;

  var _button = _interopRequireDefault(require("@frontend-taglib-clay$clayui/button"));

  var _icon = _interopRequireDefault(require("@frontend-taglib-clay$clayui/icon"));

  var _panel = _interopRequireDefault(require("@frontend-taglib-clay$clayui/panel"));

  var _classnames = _interopRequireDefault(require("frontend-js-react-web$classnames"));

  var _react = _interopRequireDefault(require("frontend-js-react-web$react"));

  var _index = require("../../hooks/index.es");

  var _DropDown = _interopRequireDefault(require("../drop-down/DropDown.es"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _slicedToArray(arr, i) {
    return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
  }

  function _nonIterableRest() {
    throw new TypeError("Invalid attempt to destructure non-iterable instance");
  }

  function _iterableToArrayLimit(arr, i) {
    if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
      return;
    }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
      for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
        _arr.push(_s.value);if (i && _arr.length === i) break;
      }
    } catch (err) {
      _d = true;_e = err;
    } finally {
      try {
        if (!_n && _i["return"] != null) _i["return"]();
      } finally {
        if (_d) throw _e;
      }
    }return _arr;
  }

  function _arrayWithHoles(arr) {
    if (Array.isArray(arr)) return arr;
  }

  var CollapsablePanel = function CollapsablePanel(_ref) {
    var Header = _ref.Header,
        actions = _ref.actions,
        children = _ref.children,
        className = _ref.className,
        title = _ref.title;

    var panelRef = _react["default"].useRef(null);

    var _React$useState = _react["default"].useState(false),
        _React$useState2 = _slicedToArray(_React$useState, 2),
        expanded = _React$useState2[0],
        setExpanded = _React$useState2[1];

    var _useHeightTransition = (0, _index.useHeightTransition)(expanded, setExpanded, panelRef),
        _useHeightTransition2 = _slicedToArray(_useHeightTransition, 3),
        transitioning = _useHeightTransition2[0],
        handleTransitionEnd = _useHeightTransition2[1],
        startTransition = _useHeightTransition2[2];

    return _react["default"].createElement("div", {
      className: (0, _classnames["default"])('collapsable-panel', 'panel', 'panel-unstyled', className),
      role: "tablist"
    }, _react["default"].createElement(_react["default"].Fragment, null, Header ? _react["default"].createElement(Header, {
      expanded: expanded,
      setExpanded: setExpanded
    }) : _react["default"].createElement(_react["default"].Fragment, null, _react["default"].createElement(_button["default"], {
      "aria-expanded": expanded,
      className: (0, _classnames["default"])('collapse-icon', 'collapse-icon-middle', 'panel-header', 'panel-header-link', {
        collapsed: !(!expanded && transitioning || expanded && !transitioning)
      }),
      displayType: "unstyled",
      onClick: startTransition,
      role: "tab"
    }, _react["default"].createElement(_react["default"].Fragment, null, _react["default"].createElement("span", {
      className: "panel-title"
    }, title), _react["default"].createElement("span", {
      className: (0, _classnames["default"])('actions', 'collapse-icon-closed')
    }, _react["default"].createElement(_icon["default"], {
      symbol: "angle-down"
    })), _react["default"].createElement("span", {
      className: (0, _classnames["default"])('actions', 'collapse-icon-open')
    }, _react["default"].createElement(_icon["default"], {
      symbol: "angle-up"
    })))), actions && _react["default"].createElement("div", {
      className: "collapse-icon-options"
    }, _react["default"].createElement(_DropDown["default"], {
      actions: actions
    }))), _react["default"].createElement("div", {
      className: (0, _classnames["default"])('panel-collapse', {
        collapse: !transitioning,
        collapsing: transitioning,
        show: expanded
      }),
      onTransitionEnd: handleTransitionEnd,
      ref: panelRef,
      role: "tabpanel"
    }, _react["default"].createElement(_panel["default"].Body, null, children))));
  };

  var _default = CollapsablePanel;
  exports["default"] = _default;
  //# sourceMappingURL=CollapsablePanel.es.js.map
});
//# sourceMappingURL=CollapsablePanel.es.js.map