Liferay.Loader.define("data-engine-taglib@2.5.10/data_layout_builder/js/components/field-sets/FieldSetModal.es", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/button', '@frontend-taglib-clay$clayui/form', '@frontend-taglib-clay$clayui/modal', 'frontend-js-react-web$react', '../../App.es', '../../AppContext.es', '../../actions.es', '../../utils/dataLayoutVisitor.es', '../modal/ModalWithEventPrevented.es', './actions/useCreateFieldSet.es', './actions/usePropagateFieldSet.es', './actions/useSaveFieldSet.es'], function (module, exports, require) {
  var define = undefined;
  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = void 0;

  var _button = _interopRequireDefault(require("@frontend-taglib-clay$clayui/button"));

  var _form = require("@frontend-taglib-clay$clayui/form");

  var _modal = _interopRequireWildcard(require("@frontend-taglib-clay$clayui/modal"));

  var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

  var _App = _interopRequireDefault(require("../../App.es"));

  var _AppContext = _interopRequireDefault(require("../../AppContext.es"));

  var _actions = require("../../actions.es");

  var _dataLayoutVisitor = require("../../utils/dataLayoutVisitor.es");

  var _ModalWithEventPrevented = _interopRequireDefault(require("../modal/ModalWithEventPrevented.es"));

  var _useCreateFieldSet = _interopRequireDefault(require("./actions/useCreateFieldSet.es"));

  var _usePropagateFieldSet = _interopRequireDefault(require("./actions/usePropagateFieldSet.es"));

  var _useSaveFieldSet = _interopRequireDefault(require("./actions/useSaveFieldSet.es"));

  function _getRequireWildcardCache() {
    if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
      return cache;
    };return cache;
  }

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
      return { "default": obj };
    }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
      return cache.get(obj);
    }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
      if (Object.prototype.hasOwnProperty.call(obj, key)) {
        var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
          Object.defineProperty(newObj, key, desc);
        } else {
          newObj[key] = obj[key];
        }
      }
    }newObj["default"] = obj;if (cache) {
      cache.set(obj, newObj);
    }return newObj;
  }

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _objectWithoutProperties(source, excluded) {
    if (source == null) return {};var target = _objectWithoutPropertiesLoose(source, excluded);var key, i;if (Object.getOwnPropertySymbols) {
      var sourceSymbolKeys = Object.getOwnPropertySymbols(source);for (i = 0; i < sourceSymbolKeys.length; i++) {
        key = sourceSymbolKeys[i];if (excluded.indexOf(key) >= 0) continue;if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue;target[key] = source[key];
      }
    }return target;
  }

  function _objectWithoutPropertiesLoose(source, excluded) {
    if (source == null) return {};var target = {};var sourceKeys = Object.keys(source);var key, i;for (i = 0; i < sourceKeys.length; i++) {
      key = sourceKeys[i];if (excluded.indexOf(key) >= 0) continue;target[key] = source[key];
    }return target;
  }

  function _extends() {
    _extends = Object.assign || function (target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i];for (var key in source) {
          if (Object.prototype.hasOwnProperty.call(source, key)) {
            target[key] = source[key];
          }
        }
      }return target;
    };return _extends.apply(this, arguments);
  }

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(Object(source), true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  function _toConsumableArray(arr) {
    return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread();
  }

  function _nonIterableSpread() {
    throw new TypeError("Invalid attempt to spread non-iterable instance");
  }

  function _iterableToArray(iter) {
    if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
  }

  function _arrayWithoutHoles(arr) {
    if (Array.isArray(arr)) {
      for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) {
        arr2[i] = arr[i];
      }return arr2;
    }
  }

  function _slicedToArray(arr, i) {
    return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
  }

  function _nonIterableRest() {
    throw new TypeError("Invalid attempt to destructure non-iterable instance");
  }

  function _iterableToArrayLimit(arr, i) {
    if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
      return;
    }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
      for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
        _arr.push(_s.value);if (i && _arr.length === i) break;
      }
    } catch (err) {
      _d = true;_e = err;
    } finally {
      try {
        if (!_n && _i["return"] != null) _i["return"]();
      } finally {
        if (_d) throw _e;
      }
    }return _arr;
  }

  function _arrayWithHoles(arr) {
    if (Array.isArray(arr)) return arr;
  }

  var ModalContent = function ModalContent(_ref) {
    var childrenAppProps = _ref.childrenAppProps,
        defaultLanguageId = _ref.defaultLanguageId,
        editingDataDefinition = _ref.editingDataDefinition,
        fieldSet = _ref.fieldSet,
        onClose = _ref.onClose;

    var _useContext = (0, _react.useContext)(_AppContext["default"]),
        _useContext2 = _slicedToArray(_useContext, 1),
        appProps = _useContext2[0].appProps;

    var _useState = (0, _react.useState)({
      dataLayoutBuilder: null,
      dispatch: function dispatch() {},
      state: {}
    }),
        _useState2 = _slicedToArray(_useState, 2),
        childrenContext = _useState2[0],
        setChildrenContext = _useState2[1];

    var _useState3 = (0, _react.useState)(true),
        _useState4 = _slicedToArray(_useState3, 2),
        dataLayoutIsEmpty = _useState4[0],
        setDataLayoutIsEmpty = _useState4[1];

    var _useState5 = (0, _react.useState)({}),
        _useState6 = _slicedToArray(_useState5, 2),
        name = _useState6[0],
        setName = _useState6[1];

    var dataLayoutBuilder = childrenContext.dataLayoutBuilder,
        dispatch = childrenContext.dispatch,
        _childrenContext$stat = childrenContext.state,
        config = _childrenContext$stat.config,
        dataLayout = _childrenContext$stat.dataLayout;
    var contentType = appProps.contentType;

    var availableLanguageIds = _toConsumableArray(new Set([].concat(_toConsumableArray(Object.keys(name)), [defaultLanguageId])));

    var changeZIndex = function changeZIndex(zIndex) {
      document.querySelectorAll('.ddm-field-actions-container').forEach(function (container) {
        container.style.zIndex = zIndex;
      });
    };

    (0, _react.useEffect)(function () {
      if (fieldSet) {
        setName(fieldSet.name);
      }
    }, [fieldSet]);
    (0, _react.useEffect)(function () {
      if (contentType === 'app-builder') {
        dispatch({
          payload: {
            config: _objectSpread({}, config, {
              allowFieldSets: false
            })
          },
          type: _actions.UPDATE_CONFIG
        });
      } // eslint-disable-next-line react-hooks/exhaustive-deps
    }, [contentType, dispatch]);
    (0, _react.useEffect)(function () {
      if (dataLayout) {
        var dataLayoutPages = dataLayout.dataLayoutPages;
        setDataLayoutIsEmpty((0, _dataLayoutVisitor.isDataLayoutEmpty)(dataLayoutPages));
      }
    }, [dataLayout]);
    (0, _react.useEffect)(function () {
      if (dataLayoutBuilder) {
        changeZIndex('1050');
      }

      return function () {
        changeZIndex(null);
      };
    }, [dataLayoutBuilder]);
    (0, _react.useEffect)(function () {
      if (editingDataDefinition && editingDataDefinition.id) {
        dispatch({
          payload: {
            editingDataDefinitionId: editingDataDefinition.id
          },
          type: _actions.UPDATE_EDITING_DATA_DEFINITION_ID
        });
      }
    }, [dispatch, editingDataDefinition]);
    var actionProps = {
      availableLanguageIds: availableLanguageIds,
      childrenContext: childrenContext,
      editingDataDefinition: editingDataDefinition,
      fieldSet: fieldSet
    };
    var createFieldSet = (0, _useCreateFieldSet["default"])(actionProps);
    var saveFieldSet = (0, _useSaveFieldSet["default"])(actionProps);
    var propagateFieldSet = (0, _usePropagateFieldSet["default"])();

    return _react["default"].createElement(_react["default"].Fragment, null, _react["default"].createElement(_modal["default"].Header, null, fieldSet ? Liferay.Language.get('edit-fieldset') : Liferay.Language.get('create-new-fieldset')), _react["default"].createElement(_modal["default"].Header, {
      withTitle: false
    }, _react["default"].createElement(_form.ClayInput.Group, {
      className: "pl-4 pr-4"
    }, _react["default"].createElement(_form.ClayInput.GroupItem, null, _react["default"].createElement(_form.ClayInput, {
      "aria-label": Liferay.Language.get('untitled-fieldset'),
      autoFocus: true,
      className: "form-control-inline",
      onChange: function onChange(_ref3) {
        var value = _ref3.target.value;
        return setName(_objectSpread({}, name, _defineProperty({}, defaultLanguageId, value)));
      },
      placeholder: Liferay.Language.get('untitled-fieldset'),
      type: "text",
      value: name[defaultLanguageId]
    })))), _react["default"].createElement(_modal["default"].Body, null, _react["default"].createElement("div", {
      className: "pl-4 pr-4"
    }, _react["default"].createElement(_App["default"], _extends({}, appProps, {
      dataLayoutBuilderId: "".concat(appProps.dataLayoutBuilderId, "_2"),
      setChildrenContext: setChildrenContext
    }, childrenAppProps)))), _react["default"].createElement(_modal["default"].Footer, {
      last: _react["default"].createElement(_button["default"].Group, {
        spaced: true
      }, _react["default"].createElement(_button["default"], {
        displayType: "secondary",
        onClick: onClose
      }, Liferay.Language.get('cancel')), _react["default"].createElement(_button["default"], {
        disabled: !name[defaultLanguageId] || dataLayoutIsEmpty,
        onClick: function onSave() {
          var hasRemovedField = function hasRemovedField() {
            var fieldNames = fieldSet.dataDefinitionFields.map(function (_ref2) {
              var name = _ref2.name;
              return name;
            });

            var _map = [fieldSet.defaultDataLayout.dataLayoutPages, dataLayout.dataLayoutPages].map(function (layout) {
              return fieldNames.filter(function (field) {
                return (0, _dataLayoutVisitor.containsField)(layout, field);
              });
            }),
                _map2 = _slicedToArray(_map, 2),
                prevLayoutFields = _map2[0],
                actualLayoutFields = _map2[1];

            return !!prevLayoutFields.filter(function (field) {
              return !actualLayoutFields.includes(field);
            }).length;
          };

          if (fieldSet) {
            propagateFieldSet({
              fieldSet: fieldSet,
              modal: _objectSpread({
                actionMessage: Liferay.Language.get('propagate'),
                fieldSetMessage: Liferay.Language.get('do-you-want-to-propagate-the-changes-to-other-objects-views-using-this-fieldset'),
                headerMessage: Liferay.Language.get('propagate-changes')
              }, hasRemovedField() && {
                warningMessage: Liferay.Language.get('the-changes-include-the-deletion-of-fields-and-may-erase-the-data-collected-permanently')
              }),
              onPropagate: function onPropagate() {
                return saveFieldSet(name);
              }
            }).then(onClose)["catch"](onClose);
          } else {
            createFieldSet(name).then(onClose)["catch"](onClose);
          }
        }
      }, Liferay.Language.get('save')))
    }));
  };

  var FieldSetModal = function FieldSetModal(_ref4) {
    var isVisible = _ref4.isVisible,
        onCloseFn = _ref4.onClose,
        props = _objectWithoutProperties(_ref4, ["isVisible", "onClose"]);

    var _useModal = (0, _modal.useModal)({
      onClose: onCloseFn
    }),
        observer = _useModal.observer,
        onClose = _useModal.onClose;

    if (!isVisible) {
      return null;
    }

    return _react["default"].createElement(_modal["default"], {
      className: "data-layout-builder-editor-modal fieldset-modal",
      observer: observer,
      size: "full-screen"
    }, _react["default"].createElement(ModalContent, _extends({
      onClose: onClose
    }, props)));
  };

  var _default = function _default(props) {
    return _react["default"].createElement(_ModalWithEventPrevented["default"], null, _react["default"].createElement(FieldSetModal, props));
  };

  exports["default"] = _default;
  //# sourceMappingURL=FieldSetModal.es.js.map
});
//# sourceMappingURL=FieldSetModal.es.js.map