Liferay.Loader.define("data-engine-taglib@2.5.10/data_layout_builder/js/components/field-sets/actions/useDeleteFieldSet.es", ['module', 'exports', 'require', 'dynamic-data-mapping-form-renderer', 'frontend-js-react-web$react', '../../../AppContext.es', '../../../actions.es', '../../../utils/client.es', '../../../utils/toast.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = void 0;

  var _dynamicDataMappingFormRenderer = require("dynamic-data-mapping-form-renderer");

  var _react = require("frontend-js-react-web$react");

  var _AppContext = _interopRequireDefault(require("../../../AppContext.es"));

  var _actions = require("../../../actions.es");

  var _client = require("../../../utils/client.es");

  var _toast = require("../../../utils/toast.es");

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _slicedToArray(arr, i) {
    return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
  }

  function _nonIterableRest() {
    throw new TypeError("Invalid attempt to destructure non-iterable instance");
  }

  function _iterableToArrayLimit(arr, i) {
    if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
      return;
    }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
      for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
        _arr.push(_s.value);if (i && _arr.length === i) break;
      }
    } catch (err) {
      _d = true;_e = err;
    } finally {
      try {
        if (!_n && _i["return"] != null) _i["return"]();
      } finally {
        if (_d) throw _e;
      }
    }return _arr;
  }

  function _arrayWithHoles(arr) {
    if (Array.isArray(arr)) return arr;
  }

  var _default = function _default(_ref) {
    var dataLayoutBuilder = _ref.dataLayoutBuilder;

    var _useContext = (0, _react.useContext)(_AppContext["default"]),
        _useContext2 = _slicedToArray(_useContext, 2),
        _useContext2$ = _useContext2[0],
        dataDefinition = _useContext2$.dataDefinition,
        fieldSets = _useContext2$.fieldSets,
        dispatch = _useContext2[1];

    return function (fieldSet) {

      return (0, _client.deleteItem)("".concat('/o/data-engine/v2.0/data-definitions/').concat(fieldSet.id)).then(function deleteField() {
        var dataDefinitionField = dataDefinition.dataDefinitionFields.find(function (_ref3) {
          var ddmStructureId = _ref3.customProperties.ddmStructureId;
          return ddmStructureId == fieldSet.id;
        });

        if (dataDefinitionField) {
          var _dataLayoutBuilder$ge = dataLayoutBuilder.getStore(),
              pages = _dataLayoutBuilder$ge.pages;

          var visitor = new _dynamicDataMappingFormRenderer.PagesVisitor(pages);
          var fieldName = dataDefinitionField.name;


          if (visitor.containsField(fieldName, true)) {
            dataLayoutBuilder.dispatch('fieldDeleted', {
              activePage: 0,
              fieldName: fieldName
            });
          } else {
            dispatch({
              payload: {
                fieldName: fieldName
              },
              type: _actions.DELETE_DATA_DEFINITION_FIELD
            });
          }
        }

        return Promise.resolve();
      }).then(function onSuccess() {
        dispatch({
          payload: {
            fieldSets: fieldSets.filter(function (_ref2) {
              var id = _ref2.id;
              return id !== fieldSet.id;
            })
          },
          type: _actions.UPDATE_FIELDSETS
        });
        (0, _toast.successToast)(Liferay.Language.get('the-item-was-deleted-successfully'));
        return Promise.resolve();
      })["catch"](function onError() {
        return (0, _toast.errorToast)(Liferay.Language.get('the-item-could-not-be-deleted'));
      });
    };
  };

  exports["default"] = _default;
  //# sourceMappingURL=useDeleteFieldSet.es.js.map
});
//# sourceMappingURL=useDeleteFieldSet.es.js.map