Liferay.Loader.define("data-engine-taglib@2.5.10/data_layout_builder/js/data-layout-builder/DataLayoutBuilder.es", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/layout', 'frontend-js-react-web$classnames', 'dynamic-data-mapping-form-builder', 'dynamic-data-mapping-form-renderer', 'frontend-js-metal-web$metal', 'frontend-js-react-web$react', '../drag-and-drop/dragTypes.es', '../utils/dataDefinition.es', '../utils/generateDataDefinitionFieldName.es', './EventEmitter.es', './saveDefinitionAndLayout.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.DataLayoutBuilder = exports["default"] = void 0;

  var _layout = _interopRequireDefault(require("@frontend-taglib-clay$clayui/layout"));

  var _classnames = _interopRequireDefault(require("frontend-js-react-web$classnames"));

  var _dynamicDataMappingFormBuilder = _interopRequireWildcard(require("dynamic-data-mapping-form-builder"));

  var _dynamicDataMappingFormRenderer = require("dynamic-data-mapping-form-renderer");

  var _metal = _interopRequireDefault(require("frontend-js-metal-web$metal"));

  var _react = _interopRequireDefault(require("frontend-js-react-web$react"));

  var _dragTypes = require("../drag-and-drop/dragTypes.es");

  var _dataDefinition = require("../utils/dataDefinition.es");

  var _generateDataDefinitionFieldName = _interopRequireDefault(require("../utils/generateDataDefinitionFieldName.es"));

  var _EventEmitter = _interopRequireDefault(require("./EventEmitter.es"));

  var _saveDefinitionAndLayout = _interopRequireDefault(require("./saveDefinitionAndLayout.es"));

  function _getRequireWildcardCache() {
    if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
      return cache;
    };return cache;
  }

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
      return { "default": obj };
    }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
      return cache.get(obj);
    }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
      if (Object.prototype.hasOwnProperty.call(obj, key)) {
        var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
          Object.defineProperty(newObj, key, desc);
        } else {
          newObj[key] = obj[key];
        }
      }
    }newObj["default"] = obj;if (cache) {
      cache.set(obj, newObj);
    }return newObj;
  }

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function _toConsumableArray(arr) {
    return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread();
  }

  function _nonIterableSpread() {
    throw new TypeError("Invalid attempt to spread non-iterable instance");
  }

  function _iterableToArray(iter) {
    if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
  }

  function _arrayWithoutHoles(arr) {
    if (Array.isArray(arr)) {
      for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) {
        arr2[i] = arr[i];
      }return arr2;
    }
  }

  function _slicedToArray(arr, i) {
    return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
  }

  function _nonIterableRest() {
    throw new TypeError("Invalid attempt to destructure non-iterable instance");
  }

  function _iterableToArrayLimit(arr, i) {
    if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
      return;
    }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
      for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
        _arr.push(_s.value);if (i && _arr.length === i) break;
      }
    } catch (err) {
      _d = true;_e = err;
    } finally {
      try {
        if (!_n && _i["return"] != null) _i["return"]();
      } finally {
        if (_d) throw _e;
      }
    }return _arr;
  }

  function _arrayWithHoles(arr) {
    if (Array.isArray(arr)) return arr;
  }

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(Object(source), true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  /**
   * Data Layout Builder.
   * @extends React.Component
   */
  var DataLayoutBuilder = /*#__PURE__*/function (_React$Component) {
    _inherits(DataLayoutBuilder, _React$Component);

    function DataLayoutBuilder(props) {
      var _this;

      _classCallCheck(this, DataLayoutBuilder);

      _this = _possibleConstructorReturn(this, _getPrototypeOf(DataLayoutBuilder).call(this, props));
      _this.containerRef = _react["default"].createRef();
      _this.eventEmitter = new _EventEmitter["default"]();
      _this.state = {};
      return _this;
    }

    _createClass(DataLayoutBuilder, [{
      key: "componentDidMount",
      value: function componentDidMount() {
        var _this2 = this;

        var _this$props = this.props,
            config = _this$props.config,
            dataLayoutBuilderId = _this$props.dataLayoutBuilderId,
            fieldTypes = _this$props.fieldTypes,
            localizable = _this$props.localizable,
            portletNamespace = _this$props.portletNamespace;

        var context = this._setContext(this.props.context);

        this.formBuilderWithLayoutProvider = new _dynamicDataMappingFormBuilder["default"]({
          events: {
            attached: function attached() {
              _this2.props.onLoad(_this2);

              Liferay.component(dataLayoutBuilderId, _this2);
            }
          },
          formBuilderProps: {
            allowNestedFields: config.allowNestedFields,
            dnd: {
              accept: [_dragTypes.DRAG_DATA_DEFINITION_FIELD, _dragTypes.DRAG_FIELDSET, _dragTypes.DRAG_FIELD_TYPE]
            },
            fieldTypes: fieldTypes,
            portletNamespace: portletNamespace,
            ref: 'builder'
          },
          layoutProviderProps: _objectSpread({}, this.props, {
            allowMultiplePages: config.allowMultiplePages,
            allowSuccessPage: config.allowSuccessPage,
            context: context,
            defaultLanguageId: themeDisplay.getDefaultLanguageId(),
            editingLanguageId: themeDisplay.getDefaultLanguageId(),
            initialPages: context.pages,
            ref: 'layoutProvider',
            rules: context.rules
          })
        }, this.containerRef.current);

        if (localizable) {
          this._localeChangedHandler = Liferay.after('inputLocalized:localeChanged', this._onLocaleChange.bind(this));
        }
      }
    }, {
      key: "componentWillUnmount",
      value: function componentWillUnmount() {
        var dataLayoutBuilderId = this.props.dataLayoutBuilderId;
        var formBuilderWithLayoutProvider = this.formBuilderWithLayoutProvider;

        if (formBuilderWithLayoutProvider) {
          formBuilderWithLayoutProvider.dispose();
        }

        if (this._localeChangedHandler) {
          this._localeChangedHandler.detach();
        }

        Liferay.destroyComponent(dataLayoutBuilderId);
      }
    }, {
      key: "dispatch",
      value: function dispatch(event, payload) {
        var layoutProvider = this.getLayoutProvider();

        if (layoutProvider && layoutProvider.dispatch) {
          layoutProvider.dispatch(event, payload);
        }
      }
    }, {
      key: "dispatchAction",
      value: function dispatchAction(action) {
        var appContext = this.props.appContext;

        var _appContext = _slicedToArray(appContext, 2),
            dispatch = _appContext[1];

        if (dispatch) {
          dispatch(action);
        }
      }
    }, {
      key: "emit",
      value: function emit(event, payload) {
        var error = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
        this.eventEmitter.emit(event, payload, error);
      }
    }, {
      key: "fieldNameGenerator",
      value: function fieldNameGenerator(dataDefinitionFields) {
        var layoutProvider = this.getLayoutProvider();
        layoutProvider.props = _objectSpread({}, layoutProvider.props, {
          fieldNameGenerator: function fieldNameGenerator(desiredFieldName, currentFieldName, blacklist) {
            return (0, _generateDataDefinitionFieldName["default"])(dataDefinitionFields, desiredFieldName, currentFieldName, blacklist);
          },
          shouldAutoGenerateName: function shouldAutoGenerateName() {
            return false;
          }
        });
      }
    }, {
      key: "getDataDefinitionAndDataLayout",
      value: function getDataDefinitionAndDataLayout(pages, rules) {
        var _this3 = this;

        var _this$props$defaultLa = this.props.defaultLanguageId,
            defaultLanguageId = _this$props$defaultLa === void 0 ? themeDisplay.getDefaultLanguageId() : _this$props$defaultLa;
        var availableLanguageIds = this.state.availableLanguageIds || this.props.availableLanguageIds || [themeDisplay.getDefaultLanguageId()];
        var fieldDefinitions = [];
        var pagesVisitor = new _dynamicDataMappingFormRenderer.PagesVisitor(pages);
        var newPages = pagesVisitor.mapFields(function (field) {
          fieldDefinitions.push(_this3.getDataDefinitionField(field, availableLanguageIds, defaultLanguageId));
          return field.fieldName;
        }, false);
        var layoutProvider = this.getLayoutProvider();
        return {
          definition: {
            availableLanguageIds: availableLanguageIds,
            dataDefinitionFields: fieldDefinitions,
            defaultLanguageId: defaultLanguageId
          },
          layout: {
            dataLayoutPages: newPages.map(function (page) {
              var rows = page.rows.map(function (row) {
                var columns = row.columns.map(function (column) {
                  return {
                    columnSize: column.size,
                    fieldNames: column.fields
                  };
                });
                return {
                  dataLayoutColumns: columns
                };
              });
              return {
                dataLayoutRows: rows,
                description: page.localizedDescription,
                title: page.localizedTitle
              };
            }),
            dataRules: rules.map(function (rule) {
              if (typeof rule.name === 'string') {
                rule.name = _defineProperty({}, defaultLanguageId, rule.name);
              }

              delete rule.ruleEditedIndex;
              return rule;
            }),
            paginationMode: layoutProvider.getPaginationMode()
          }
        };
      }
    }, {
      key: "getDataDefinitionField",
      value: function getDataDefinitionField(_ref) {
        var _this4 = this;

        var _ref$nestedFields = _ref.nestedFields,
            nestedFields = _ref$nestedFields === void 0 ? [] : _ref$nestedFields,
            settingsContext = _ref.settingsContext;
        var availableLanguageIds = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];
        var defaultLanguageId = arguments.length > 2 ? arguments[2] : undefined;
        var fieldConfig = {
          customProperties: {},
          nestedDataDefinitionFields: nestedFields.map(function (nestedField) {
            return _this4.getDataDefinitionField(nestedField, availableLanguageIds, defaultLanguageId);
          })
        };
        var settingsContextVisitor = new _dynamicDataMappingFormRenderer.PagesVisitor(settingsContext.pages);
        settingsContextVisitor.mapFields(function (_ref2) {
          var dataType = _ref2.dataType,
              fieldName = _ref2.fieldName,
              localizable = _ref2.localizable,
              _ref2$localizedValue = _ref2.localizedValue,
              localizedValue = _ref2$localizedValue === void 0 ? {} : _ref2$localizedValue,
              value = _ref2.value;

          if (fieldName === 'predefinedValue') {
            fieldName = 'defaultValue';
          } else if (fieldName === 'type') {
            fieldName = 'fieldType';
          }

          if (localizable) {
            availableLanguageIds.forEach(function (languageId) {
              if (!localizedValue[languageId]) {
                localizedValue[languageId] = localizedValue[defaultLanguageId] || '';
              }
            });

            if (_this4._isCustomProperty(fieldName)) {
              fieldConfig.customProperties[fieldName] = localizedValue;
            } else {
              fieldConfig[fieldName] = localizedValue;
            }
          } else {
            var formattedValue = _this4.getDataDefinitionFieldFormattedValue(dataType, value);

            if (_this4._isCustomProperty(fieldName)) {
              fieldConfig.customProperties[fieldName] = formattedValue;
            } else {
              fieldConfig[fieldName] = formattedValue;
            }
          }
        }, false);
        return fieldConfig;
      }
    }, {
      key: "getDataDefinitionFieldFormattedValue",
      value: function getDataDefinitionFieldFormattedValue(dataType, value) {
        if (dataType === 'json' && typeof value !== 'string') {
          return JSON.stringify(value);
        }

        return value;
      }
    }, {
      key: "getDDMForm",
      value: function getDDMForm(dataDefinition) {
        var _this5 = this;

        var dataLayout = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : this.getDefaultDataLayout(dataDefinition);
        var _this$props$editingLa = this.props.editingLanguageId,
            editingLanguageId = _this$props$editingLa === void 0 ? themeDisplay.getDefaultLanguageId() : _this$props$editingLa;
        var defaultLanguageId = dataDefinition.defaultLanguageId,
            name = dataDefinition.name;
        return {
          description: dataDefinition.description[editingLanguageId],
          id: dataDefinition.id,
          localizedDescription: dataDefinition.description,
          localizedTitle: name,
          pages: dataLayout.dataLayoutPages.map(function (dataLayoutPage) {
            return {
              rows: dataLayoutPage.dataLayoutRows.map(function (dataLayoutRow) {
                return {
                  columns: dataLayoutRow.dataLayoutColumns.map(function (_ref3) {
                    var columnSize = _ref3.columnSize,
                        fieldNames = _ref3.fieldNames;
                    return {
                      fields: fieldNames.map(function (fieldName) {
                        return _this5.getDDMFormField(dataDefinition, fieldName);
                      }),
                      size: columnSize
                    };
                  })
                };
              })
            };
          }),
          title: name[editingLanguageId] || name[defaultLanguageId]
        };
      }
    }, {
      key: "getDDMFormField",
      value: function getDDMFormField(dataDefinition, fieldName) {
        var _this6 = this;

        var dataDefinitionField = (0, _dataDefinition.getDataDefinitionField)(dataDefinition, fieldName);

        if (dataDefinitionField.fieldType === 'ddm-text-html') {
          dataDefinitionField.fieldType = 'rich_text';
        }

        var _this$props$editingLa2 = this.props.editingLanguageId,
            editingLanguageId = _this$props$editingLa2 === void 0 ? themeDisplay.getDefaultLanguageId() : _this$props$editingLa2;
        var settingsContext = this.getDDMFormFieldSettingsContext(dataDefinitionField);
        var ddmFormField = {
          nestedFields: dataDefinitionField.nestedDataDefinitionFields,
          settingsContext: settingsContext
        };
        var visitor = new _dynamicDataMappingFormRenderer.PagesVisitor(settingsContext.pages);
        visitor.mapFields(function (field) {
          var fieldName = field.fieldName;
          var value = field.value;

          if (fieldName === 'options' && value) {
            value = value[editingLanguageId];
          } else if (fieldName === 'name') {
            ddmFormField.fieldName = value;
          }

          ddmFormField[fieldName] = value;
        });

        if (ddmFormField.nestedFields.length > 0) {
          ddmFormField.nestedFields = ddmFormField.nestedFields.map(function (nestedField) {
            return _this6.getDDMFormField(dataDefinition, nestedField.name);
          });
        }

        if (!ddmFormField.instanceId) {
          ddmFormField.instanceId = _dynamicDataMappingFormBuilder.FieldSupport.generateInstanceId(8);
        }

        return ddmFormField;
      }
    }, {
      key: "getDDMFormFieldSettingsContext",
      value: function getDDMFormFieldSettingsContext(dataDefinitionField) {
        var _this7 = this;

        var _this$props$editingLa3 = this.props.editingLanguageId,
            editingLanguageId = _this$props$editingLa3 === void 0 ? themeDisplay.getDefaultLanguageId() : _this$props$editingLa3;
        var fieldTypes = this.getFieldTypes();

        var _fieldTypes$find = fieldTypes.find(function (_ref4) {
          var name = _ref4.name;
          return name === dataDefinitionField.fieldType;
        }),
            settingsContext = _fieldTypes$find.settingsContext;

        var visitor = new _dynamicDataMappingFormRenderer.PagesVisitor(settingsContext.pages);
        return _objectSpread({}, settingsContext, {
          pages: visitor.mapFields(function (field) {
            var fieldName = field.fieldName,
                localizable = field.localizable;

            var propertyValue = _this7._getDataDefinitionfieldPropertyValue(dataDefinitionField, _this7._fromDDMFormToDataDefinitionPropertyName(fieldName));

            var value = propertyValue || field.value;

            if (localizable && propertyValue && Object.prototype.hasOwnProperty.call(propertyValue, editingLanguageId) && fieldName !== 'label') {
              value = propertyValue[editingLanguageId];
            }

            var localizedValue = {};

            if (localizable) {
              localizedValue = _objectSpread({}, propertyValue);
            }

            var options = [];

            if (field.type === 'select' && field.fieldName === 'predefinedValue') {
              options = dataDefinitionField.customProperties.options[editingLanguageId];
            }

            return _objectSpread({}, field, {
              localizedValue: localizedValue,
              options: options,
              value: value
            });
          })
        });
      }
    }, {
      key: "getDefaultDataLayout",
      value: function getDefaultDataLayout(dataDefinition) {
        var dataDefinitionFields = dataDefinition.dataDefinitionFields;
        return {
          dataLayoutPages: [{
            dataLayoutRows: dataDefinitionFields.map(function (_ref5) {
              var name = _ref5.name;
              return {
                dataLayoutColumns: [{
                  columnSize: 12,
                  fieldNames: [name]
                }]
              };
            })
          }]
        };
      }
    }, {
      key: "getFieldTypes",
      value: function getFieldTypes() {
        var fieldTypes = this.props.fieldTypes;
        return fieldTypes;
      }
    }, {
      key: "getFormData",
      value: function getFormData() {
        var _this$getStore = this.getStore(),
            pages = _this$getStore.pages,
            rules = _this$getStore.rules;

        return this.getDataDefinitionAndDataLayout(pages, rules || []);
      }
    }, {
      key: "getLayoutProvider",
      value: function getLayoutProvider() {
        var layoutProvider = this.formBuilderWithLayoutProvider.refs.layoutProvider;
        return layoutProvider;
      }
    }, {
      key: "getState",
      value: function getState() {
        var appContext = this.props.appContext;

        var _appContext2 = _slicedToArray(appContext, 1),
            state = _appContext2[0];

        return state;
      }
    }, {
      key: "getStore",
      value: function getStore() {
        var layoutProvider = this.getLayoutProvider();
        return _objectSpread({}, layoutProvider.state);
      }
    }, {
      key: "on",
      value: function on(eventName, listener) {
        this.eventEmitter.on(eventName, listener);
      }
    }, {
      key: "onEditingLanguageIdChange",
      value: function onEditingLanguageIdChange(_ref6) {
        var editingLanguageId = _ref6.editingLanguageId,
            _ref6$defaultLanguage = _ref6.defaultLanguageId,
            defaultLanguageId = _ref6$defaultLanguage === void 0 ? themeDisplay.getDefaultLanguageId() : _ref6$defaultLanguage;
        var layoutProvider = this.getLayoutProvider();

        var availableLanguageIds = _toConsumableArray(new Set([].concat(_toConsumableArray(layoutProvider.props.availableLanguageIds), [editingLanguageId])));

        var focusedField = layoutProvider.getFocusedField();
        this.setState({
          availableLanguageIds: availableLanguageIds
        });
        var props = {
          availableLanguageIds: availableLanguageIds,
          defaultLanguageId: defaultLanguageId,
          editingLanguageId: editingLanguageId
        };
        layoutProvider.props = _objectSpread({}, layoutProvider.props, {}, props);
        this.formBuilderWithLayoutProvider.props.layoutProviderProps = _objectSpread({}, this.formBuilderWithLayoutProvider.props.layoutProviderProps, {}, props);
        this.formBuilderWithLayoutProvider.props.layoutProviderProps = this.formBuilderWithLayoutProvider.props.layoutProviderProps; // eslint-disable-line

        if (Object.keys(focusedField).length) {
          layoutProvider.getEvents().fieldClicked(_objectSpread({
            activePage: 0
          }, focusedField));
        }
      }
    }, {
      key: "removeEventListener",
      value: function removeEventListener(eventName, listener) {
        this.eventEmitter.removeListener(eventName, listener);
      }
    }, {
      key: "render",
      value: function render() {
        var _this$getState = this.getState(),
            _this$getState$sideba = _this$getState.sidebarOpen,
            sidebarOpen = _this$getState$sideba === void 0 ? false : _this$getState$sideba;

        return _react["default"].createElement("div", {
          className: (0, _classnames["default"])('data-engine-form-builder ddm-form-builder', {
            'ddm-form-builder--sidebar-open': sidebarOpen
          })
        }, _react["default"].createElement(_layout["default"].Sheet, {
          ref: this.containerRef
        }));
      }
    }, {
      key: "save",
      value: function save() {
        var params = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
        var _this$props2 = this.props,
            contentType = _this$props2.contentType,
            dataDefinitionId = _this$props2.dataDefinitionId,
            dataLayoutId = _this$props2.dataLayoutId,
            groupId = _this$props2.groupId;

        var _this$getFormData = this.getFormData(),
            dataDefinition = _this$getFormData.definition,
            dataLayout = _this$getFormData.layout;

        return (0, _saveDefinitionAndLayout["default"])({
          contentType: contentType,
          dataDefinition: dataDefinition,
          dataDefinitionId: dataDefinitionId,
          dataLayout: dataLayout,
          dataLayoutId: dataLayoutId,
          groupId: groupId,
          params: params
        });
      }
    }, {
      key: "serialize",
      value: function serialize(pages, rules) {
        var _this$getDataDefiniti = this.getDataDefinitionAndDataLayout(pages, rules || []),
            definition = _this$getDataDefiniti.definition,
            layout = _this$getDataDefiniti.layout;

        return {
          definition: JSON.stringify(definition),
          layout: JSON.stringify(layout)
        };
      }
    }, {
      key: "_fromDataDefinitionToDDMFormPropertyName",
      value: function _fromDataDefinitionToDDMFormPropertyName(propertyName) {
        return {
          defaultValue: 'predefinedValue',
          fieldType: 'type',
          name: 'fieldName',
          nestedDataDefinitionFields: 'nestedFields'
        }[propertyName] || propertyName;
      }
    }, {
      key: "_fromDDMFormToDataDefinitionPropertyName",
      value: function _fromDDMFormToDataDefinitionPropertyName(propertyName) {
        return {
          fieldName: 'name',
          nestedFields: 'nestedDataDefinitionFields',
          predefinedValue: 'defaultValue',
          type: 'fieldType'
        }[propertyName] || propertyName;
      }
    }, {
      key: "_getDataDefinitionfieldPropertyValue",
      value: function _getDataDefinitionfieldPropertyValue(dataDefinitionField, propertyName) {
        var customProperties = dataDefinitionField.customProperties;

        if (customProperties && this._isCustomProperty(propertyName)) {
          return customProperties[propertyName];
        }

        return dataDefinitionField[propertyName];
      }
    }, {
      key: "_isCustomProperty",
      value: function _isCustomProperty(name) {
        return ['defaultValue', 'fieldType', 'indexable', 'indexType', 'label', 'localizable', 'name', 'readOnly', 'repeatable', 'required', 'showLabel', 'tip'].indexOf(name) === -1;
      }
    }, {
      key: "_onLocaleChange",
      value: function _onLocaleChange(event) {
        var layoutProvider = this.getLayoutProvider();
        var selectedLanguageId = event.item.getAttribute('data-value');
        var defaultLanguageId = layoutProvider.props.defaultLanguageId;
        this.onEditingLanguageIdChange({
          defaultLanguageId: defaultLanguageId,
          editingLanguageId: selectedLanguageId
        });
      }
    }, {
      key: "_setContext",
      value: function _setContext(context) {
        var _this$props3 = this.props,
            config = _this$props3.config,
            defaultLanguageId = _this$props3.defaultLanguageId;

        var emptyLocalizableValue = _defineProperty({}, defaultLanguageId, '');

        var pages = context.pages || [];

        if (!pages.length) {
          context = _objectSpread({}, context, {
            pages: [{
              description: '',
              localizedDescription: emptyLocalizableValue,
              localizedTitle: emptyLocalizableValue,
              rows: [{
                columns: [{
                  fields: [],
                  size: 12
                }]
              }],
              title: ''
            }],
            paginationMode: config.paginationMode || 'wizard',
            rules: context.rules || []
          });
        }

        return _objectSpread({}, context, {
          pages: context.pages.map(function (page) {
            var _page$description = page.description,
                description = _page$description === void 0 ? '' : _page$description,
                localizedDescription = page.localizedDescription,
                localizedTitle = page.localizedTitle,
                _page$title = page.title,
                title = _page$title === void 0 ? '' : _page$title;
            description = description === null ? '' : description;
            title = title === null ? '' : title;

            if (!_metal["default"].isString(description)) {
              description = description[defaultLanguageId];
              localizedDescription = _defineProperty({}, defaultLanguageId, description);
            }

            if (!_metal["default"].isString(title)) {
              title = title[defaultLanguageId];
              localizedTitle = _defineProperty({}, defaultLanguageId, title);
            }

            return _objectSpread({}, page, {
              description: description,
              localizedDescription: localizedDescription,
              localizedTitle: localizedTitle,
              title: title
            });
          }),
          rules: context.rules || []
        });
      }
    }]);

    return DataLayoutBuilder;
  }(_react["default"].Component);

  exports.DataLayoutBuilder = DataLayoutBuilder;
  var _default = DataLayoutBuilder;
  exports["default"] = _default;
  //# sourceMappingURL=DataLayoutBuilder.es.js.map
});
//# sourceMappingURL=DataLayoutBuilder.es.js.map