/**
 * Copyright (c) 2014-present, Facebook, Inc.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */

'use strict';

/**
 * Similar to invariant but only logs a warning if the condition is not met.
 * This can be used to log issues in development environments in critical
 * paths. Removing the logging code for production environments will keep the
 * same logic and follow the same code paths.
 */

Liferay.Loader.define('data-engine-taglib$warning@4.0.3/warning', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  var __DEV__ = false;

  var warning = function () {};

  var printWarning;


  module.exports = warning;
});
//# sourceMappingURL=warning.js.map