Liferay.Loader.define("data-engine-taglib@2.5.34/data_layout_builder/js/AppContext.es", ['module', 'exports', 'require', 'dynamic-data-mapping-form-builder', 'dynamic-data-mapping-form-renderer', 'frontend-js-react-web$react', './actions.es', './utils/dataDefinition.es', './utils/dataLayoutVisitor.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.createReducer = exports.initialState = exports.default = void 0;

    var _dynamicDataMappingFormBuilder = require("dynamic-data-mapping-form-builder");

    var _dynamicDataMappingFormRenderer = require("dynamic-data-mapping-form-renderer");

    var _react = require("frontend-js-react-web$react");

    var _actions = require("./actions.es");

    var _dataDefinition = require("./utils/dataDefinition.es");

    var DataLayoutVisitor = _interopRequireWildcard(require("./utils/dataLayoutVisitor.es"));

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return { default: obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj.default = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });keys.push.apply(keys, symbols);
      }return keys;
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
          ownKeys(Object(source), true).forEach(function (key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function (key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }return target;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    const AppContext = /*#__PURE__*/(0, _react.createContext)();
    const initialState = {
      appProps: {},
      config: {
        allowFieldSets: false,
        allowNestedFields: true,
        allowRules: false,
        disabledProperties: [],
        disabledTabs: [],
        multiPage: true,
        ruleSettings: {},
        unimplementedProperties: []
      },
      dataDefinition: {
        availableLanguageIds: [],
        dataDefinitionFields: [],
        name: {}
      },
      dataDefinitionId: 0,
      dataLayout: {
        dataLayoutPages: [],
        dataRules: [],
        name: {},
        paginationMode: 'wizard'
      },
      dataLayoutId: 0,
      editingDataDefinitionId: 0,
      editingLanguageId: themeDisplay.getLanguageId(),
      fieldSets: [],
      fieldTypes: [],
      focusedCustomObjectField: {},
      focusedField: {},
      hoveredField: {},
      initialAvailableLanguageIds: [],
      sidebarOpen: true,
      sidebarPanelId: 'fields',
      spritemap: "".concat(Liferay.ThemeDisplay.getPathThemeImages(), "/clay/icons.svg")
    };
    exports.initialState = initialState;

    const addCustomObjectField = ({
      dataLayoutBuilder,
      fieldTypeName,
      fieldTypes
    }) => {
      const fieldType = fieldTypes.find(({
        name
      }) => name === fieldTypeName);
      const dataDefinitionField = dataLayoutBuilder.getDataDefinitionField(fieldType);
      return _objectSpread(_objectSpread({}, dataDefinitionField), {}, {
        label: {
          [themeDisplay.getLanguageId()]: fieldType.label
        },
        name: _dynamicDataMappingFormBuilder.FieldSupport.getDefaultFieldName()
      });
    };

    const deleteDataDefinitionField = (dataDefinition, fieldName) => {
      return _objectSpread(_objectSpread({}, dataDefinition), {}, {
        dataDefinitionFields: dataDefinition.dataDefinitionFields.filter(field => field.name !== fieldName)
      });
    };

    const deleteDataLayoutField = (dataLayout, fieldName) => {
      return _objectSpread(_objectSpread({}, dataLayout), {}, {
        dataLayoutPages: DataLayoutVisitor.deleteField(dataLayout.dataLayoutPages, fieldName)
      });
    };

    const editFocusedCustomObjectField = ({
      focusedCustomObjectField,
      propertyName,
      propertyValue
    }) => {
      let localizableProperty = false;
      const {
        settingsContext
      } = focusedCustomObjectField;
      const visitor = new _dynamicDataMappingFormRenderer.PagesVisitor(settingsContext.pages);

      const newSettingsContext = _objectSpread(_objectSpread({}, settingsContext), {}, {
        pages: visitor.mapFields(field => {
          const {
            fieldName,
            localizable
          } = field;

          if (fieldName === propertyName) {
            localizableProperty = localizable;
            return _objectSpread(_objectSpread({}, field), {}, {
              localizedValue: _objectSpread(_objectSpread({}, field.localizedValue), {}, {
                [themeDisplay.getLanguageId()]: propertyValue
              }),
              value: propertyValue
            });
          }

          return field;
        })
      });

      if (localizableProperty) {
        propertyValue = {
          [themeDisplay.getLanguageId()]: propertyValue
        };
      }

      return _objectSpread(_objectSpread({}, focusedCustomObjectField), {}, {
        [propertyName]: propertyValue,
        settingsContext: newSettingsContext
      });
    };

    const setDataDefinitionFields = (dataLayoutBuilder, dataDefinition, dataLayout) => {
      const {
        dataDefinitionFields
      } = dataDefinition;
      const {
        dataLayoutPages
      } = dataLayout;
      const {
        pages
      } = dataLayoutBuilder.getStore();
      const visitor = new _dynamicDataMappingFormRenderer.PagesVisitor(pages);
      const newFields = [];
      visitor.mapFields(field => {
        const definitionField = dataLayoutBuilder.getDataDefinitionField(field);
        newFields.push(definitionField);
      });
      return newFields.concat(dataDefinitionFields.filter(field => !DataLayoutVisitor.containsField(dataLayoutPages, field.name) && !newFields.some(({
        name
      }) => name === field.name)));
    };

    const setDataLayout = (dataLayout, dataLayoutBuilder) => {
      const {
        dataRules
      } = dataLayout;
      const {
        pages
      } = dataLayoutBuilder.getStore();
      const {
        layout
      } = dataLayoutBuilder.getDataDefinitionAndDataLayout(pages, dataRules || []);
      return layout;
    };

    const createReducer = dataLayoutBuilder => {
      return (state = initialState, action) => {
        switch (action.type) {
          case _actions.ADD_CUSTOM_OBJECT_FIELD:
            {
              const {
                fieldTypeName
              } = action.payload;
              const {
                dataDefinition,
                fieldSets,
                fieldTypes
              } = state;
              const newCustomObjectField = addCustomObjectField({
                dataDefinition,
                dataLayoutBuilder,
                fieldSets,
                fieldTypeName,
                fieldTypes
              });
              return _objectSpread(_objectSpread({}, state), {}, {
                dataDefinition: _objectSpread(_objectSpread({}, dataDefinition), {}, {
                  dataDefinitionFields: [...dataDefinition.dataDefinitionFields, newCustomObjectField]
                }),
                focusedCustomObjectField: _objectSpread(_objectSpread({}, newCustomObjectField), {}, {
                  settingsContext: dataLayoutBuilder.getDDMFormFieldSettingsContext(newCustomObjectField)
                })
              });
            }

          case _actions.ADD_DATA_LAYOUT_RULE:
            {
              let {
                dataRule
              } = action.payload;
              const {
                dataLayout: {
                  dataRules
                }
              } = state;
              dataRule = DataLayoutVisitor.normalizeRule(dataRule);
              return _objectSpread(_objectSpread({}, state), {}, {
                dataLayout: _objectSpread(_objectSpread({}, state.dataLayout), {}, {
                  dataRules: dataRules.concat(dataRule)
                })
              });
            }

          case _actions.DELETE_DATA_DEFINITION_FIELD:
            {
              const {
                fieldName
              } = action.payload;
              const {
                dataDefinition
              } = state;
              return _objectSpread(_objectSpread({}, state), {}, {
                dataDefinition: deleteDataDefinitionField(dataDefinition, fieldName)
              });
            }

          case _actions.DELETE_DATA_LAYOUT_FIELD:
            {
              const {
                fieldName
              } = action.payload;
              const {
                dataLayout
              } = state;
              return _objectSpread(_objectSpread({}, state), {}, {
                dataLayout: deleteDataLayoutField(dataLayout, fieldName)
              });
            }

          case _actions.DELETE_DATA_LAYOUT_RULE:
            {
              const {
                ruleEditedIndex
              } = action.payload;
              const {
                dataLayout: {
                  dataRules
                }
              } = state;
              dataLayoutBuilder.dispatch('ruleDeleted', {
                ruleId: ruleEditedIndex
              });
              return _objectSpread(_objectSpread({}, state), {}, {
                dataLayout: _objectSpread(_objectSpread({}, state.dataLayout), {}, {
                  dataRules: dataRules.filter((_rule, index) => index !== ruleEditedIndex)
                })
              });
            }

          case _actions.EDIT_CUSTOM_OBJECT_FIELD:
            {
              const {
                dataDefinition,
                focusedCustomObjectField
              } = state;
              const editedFocusedCustomObjectField = editFocusedCustomObjectField(_objectSpread(_objectSpread({}, action.payload), {}, {
                focusedCustomObjectField
              }));
              const {
                nestedDataDefinitionFields,
                settingsContext
              } = editedFocusedCustomObjectField;
              return _objectSpread(_objectSpread({}, state), {}, {
                dataDefinition: _objectSpread(_objectSpread({}, dataDefinition), {}, {
                  dataDefinitionFields: dataDefinition.dataDefinitionFields.map(dataDefinitionField => {
                    if (dataDefinitionField.name === focusedCustomObjectField.name) {
                      return _objectSpread(_objectSpread({}, dataLayoutBuilder.getDataDefinitionField(editedFocusedCustomObjectField)), {}, {
                        nestedDataDefinitionFields
                      });
                    }

                    return dataDefinitionField;
                  })
                }),
                focusedCustomObjectField: _objectSpread(_objectSpread({}, editedFocusedCustomObjectField), {}, {
                  settingsContext
                })
              });
            }

          case _actions.SWITCH_SIDEBAR_PANEL:
            {
              const {
                sidebarOpen,
                sidebarPanelId
              } = action.payload;
              return _objectSpread(_objectSpread({}, state), {}, {
                sidebarOpen,
                sidebarPanelId
              });
            }

          case _actions.UPDATE_APP_PROPS:
            {
              return _objectSpread(_objectSpread({}, state), {}, {
                appProps: action.payload
              });
            }

          case _actions.UPDATE_DATA_DEFINITION:
            {
              const {
                dataDefinition
              } = action.payload;
              return _objectSpread(_objectSpread({}, state), {}, {
                dataDefinition: _objectSpread(_objectSpread({}, state.dataDefinition), dataDefinition),
                initialAvailableLanguageIds: dataDefinition.availableLanguageIds
              });
            }

          case _actions.UPDATE_DATA_LAYOUT:
            {
              const {
                dataLayout
              } = action.payload;
              return _objectSpread(_objectSpread({}, state), {}, {
                dataLayout: _objectSpread(_objectSpread(_objectSpread({}, state.dataLayout), dataLayout), {}, {
                  dataRules: dataLayoutBuilder.getLayoutProvider().getRules()
                })
              });
            }

          case _actions.UPDATE_DATA_LAYOUT_NAME:
            {
              const {
                name
              } = action.payload;
              return _objectSpread(_objectSpread({}, state), {}, {
                dataLayout: _objectSpread(_objectSpread({}, state.dataLayout), {}, {
                  name
                })
              });
            }

          case _actions.UPDATE_DATA_LAYOUT_RULE:
            {
              let {
                dataRule
              } = action.payload;
              const {
                dataLayout: {
                  dataRules
                }
              } = state;
              dataRule = DataLayoutVisitor.normalizeRule(dataRule);
              return _objectSpread(_objectSpread({}, state), {}, {
                dataLayout: _objectSpread(_objectSpread({}, state.dataLayout), {}, {
                  dataRules: dataRules.map((rule, index) => {
                    if (index === dataRule.ruleEditedIndex) {
                      return dataRule;
                    }

                    return rule;
                  })
                })
              });
            }

          case _actions.UPDATE_EDITING_DATA_DEFINITION_ID:
            {
              const {
                editingDataDefinitionId
              } = action.payload;
              return _objectSpread(_objectSpread({}, state), {}, {
                editingDataDefinitionId
              });
            }

          case _actions.UPDATE_EDITING_LANGUAGE_ID:
            {
              const {
                dataDefinition
              } = state;
              return _objectSpread(_objectSpread({}, state), {}, {
                dataDefinition: _objectSpread(_objectSpread({}, dataDefinition), {}, {
                  availableLanguageIds: [...new Set([...dataDefinition.availableLanguageIds, action.payload])]
                }),
                editingLanguageId: action.payload
              });
            }

          case _actions.UPDATE_FIELD_TYPES:
            {
              const {
                fieldTypes
              } = action.payload;
              return _objectSpread(_objectSpread({}, state), {}, {
                fieldTypes
              });
            }

          case _actions.UPDATE_FIELDSETS:
            {
              const {
                dataDefinitionId,
                editingDataDefinitionId
              } = state;
              let {
                fieldSets
              } = action.payload;

              if (dataDefinitionId) {
                fieldSets = fieldSets.filter(item => item.id !== dataDefinitionId);
              }

              if (editingDataDefinitionId) {
                fieldSets = fieldSets.filter(item => item.id !== editingDataDefinitionId);
              }

              return _objectSpread(_objectSpread({}, state), {}, {
                fieldSets
              });
            }

          case _actions.UPDATE_FOCUSED_CUSTOM_OBJECT_FIELD:
            {
              const {
                dataDefinitionField
              } = action.payload;
              let focusedCustomObjectField = {};

              if (Object.keys(dataDefinitionField).length > 0) {
                focusedCustomObjectField = _objectSpread(_objectSpread({}, dataDefinitionField), {}, {
                  settingsContext: dataLayoutBuilder.getDDMFormFieldSettingsContext(dataDefinitionField)
                });
                return _objectSpread(_objectSpread({}, state), {}, {
                  focusedCustomObjectField,
                  focusedField: {}
                });
              }

              return _objectSpread(_objectSpread({}, state), {}, {
                focusedCustomObjectField: {}
              });
            }

          case _actions.UPDATE_FOCUSED_FIELD:
            {
              const {
                focusedField
              } = action.payload;

              if (Object.keys(focusedField).length > 0) {
                return _objectSpread(_objectSpread({}, state), {}, {
                  focusedCustomObjectField: {},
                  focusedField: _objectSpread(_objectSpread({}, focusedField), {}, {
                    settingsContext: _objectSpread(_objectSpread({}, focusedField.settingsContext), {}, {
                      editingLanguageId: state.editingLanguageId
                    })
                  }),
                  sidebarPanelId: 'fields'
                });
              }

              return _objectSpread(_objectSpread({}, state), {}, {
                focusedCustomObjectField: {},
                focusedField: {}
              });
            }

          case _actions.UPDATE_HOVERED_FIELD:
            {
              const {
                hoveredField = {}
              } = action.payload;
              const newHoveredField = (0, _dataDefinition.getDataDefinitionField)(state.dataDefinition, hoveredField.fieldName);
              return _objectSpread(_objectSpread({}, state), {}, {
                hoveredField: newHoveredField || state.hoveredField
              });
            }

          case _actions.UPDATE_CONFIG:
            {
              const {
                config
              } = action.payload;
              return _objectSpread(_objectSpread({}, state), {}, {
                config: config || state.config
              });
            }

          case _actions.UPDATE_IDS:
            {
              const {
                dataDefinitionId,
                dataLayoutId
              } = action.payload;
              return _objectSpread(_objectSpread({}, state), {}, {
                dataDefinitionId,
                dataLayoutId
              });
            }

          case _actions.UPDATE_PAGES:
            {
              const {
                dataDefinition,
                dataLayout
              } = state;
              return _objectSpread(_objectSpread({}, state), {}, {
                dataDefinition: _objectSpread(_objectSpread({}, dataDefinition), {}, {
                  dataDefinitionFields: setDataDefinitionFields(dataLayoutBuilder, dataDefinition, dataLayout)
                }),
                dataLayout: _objectSpread(_objectSpread({}, dataLayout), setDataLayout(dataLayout, dataLayoutBuilder))
              });
            }

          default:
            return state;
        }
      };
    };

    exports.createReducer = createReducer;
    var _default = AppContext;
    exports.default = _default;
    //# sourceMappingURL=AppContext.es.js.map
  }
});
//# sourceMappingURL=AppContext.es.js.map