Liferay.Loader.define("data-engine-taglib@2.5.34/data_layout_builder/js/AppContextProvider.es", ['module', 'exports', 'require', 'frontend-js-react-web$react', './AppContext.es', './actions.es', './utils/client.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _AppContext = _interopRequireWildcard(require("./AppContext.es"));

    var _actions = require("./actions.es");

    var _client = require("./utils/client.es");

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return { default: obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj.default = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * This library is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Lesser General Public License as published by the Free
     * Software Foundation; either version 2.1 of the License, or (at your option)
     * any later version.
     *
     * This library is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
     * details.
     */
    var _default = ({
      children,
      config,
      contentType,
      dataDefinitionId,
      dataLayoutBuilder,
      dataLayoutId,
      fieldSetContentType,
      groupId
    }) => {
      const reducer = (0, _AppContext.createReducer)(dataLayoutBuilder);
      const [state, dispatch] = (0, _react.useReducer)(reducer, _AppContext.initialState);
      (0, _react.useEffect)(() => dispatch({
        payload: {
          config
        },
        type: _actions.UPDATE_CONFIG
      }), [config, dispatch]);
      (0, _react.useEffect)(() => {
        dispatch({
          payload: {
            dataDefinitionId,
            dataLayoutId
          },
          type: _actions.UPDATE_IDS
        });
      }, [dataDefinitionId, dataLayoutId, dispatch]);
      (0, _react.useEffect)(() => {
        if (dataLayoutId) {
          (0, _client.getItem)("/o/data-engine/v2.0/data-layouts/".concat(dataLayoutId)).then(dataLayout => dispatch({
            payload: {
              dataLayout
            },
            type: _actions.UPDATE_DATA_LAYOUT
          }));
        }
      }, [dataLayoutId, dispatch]);
      (0, _react.useEffect)(() => {
        if (dataDefinitionId) {
          (0, _client.getItem)("/o/data-engine/v2.0/data-definitions/".concat(dataDefinitionId)).then(dataDefinition => dispatch({
            payload: {
              dataDefinition
            },
            type: _actions.UPDATE_DATA_DEFINITION
          }));
        }
      }, [dataDefinitionId, dispatch]);
      (0, _react.useEffect)(() => {
        if (config.allowFieldSets && contentType) {
          let _fieldSetContentType = fieldSetContentType;

          if (!_fieldSetContentType) {
            _fieldSetContentType = contentType;
          }

          let globalFieldSetsPromise = [];

          if (groupId) {
            globalFieldSetsPromise = (0, _client.getItem)("/o/data-engine/v2.0/sites/".concat(groupId, "/data-definitions/by-content-type/").concat(_fieldSetContentType));
          }

          const groupFieldSetsPromise = (0, _client.getItem)("/o/data-engine/v2.0/data-definitions/by-content-type/".concat(_fieldSetContentType));
          Promise.all([globalFieldSetsPromise, groupFieldSetsPromise]).then(([{
            items: globalFieldSets = []
          }, {
            items: groupFieldSets = []
          }]) => {
            dispatch({
              payload: {
                fieldSets: [...globalFieldSets, ...groupFieldSets]
              },
              type: _actions.UPDATE_FIELDSETS
            });
          }).catch(error => {});
        }
      }, [config.allowFieldSets, contentType, dispatch, fieldSetContentType, groupId]);
      return (/*#__PURE__*/_react.default.createElement(_AppContext.default.Provider, {
          value: [state, dispatch]
        }, children)
      );
    };

    exports.default = _default;
    //# sourceMappingURL=AppContextProvider.es.js.map
  }
});
//# sourceMappingURL=AppContextProvider.es.js.map