Liferay.Loader.define("data-engine-taglib@2.5.34/data_layout_builder/js/components/collapsable-panel/CollapsablePanel.es", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/button', '@frontend-taglib-clay$clayui/icon', '@frontend-taglib-clay$clayui/panel', 'frontend-js-react-web$classnames', 'frontend-js-react-web$react', '../../hooks/index.es', '../drop-down/DropDown.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;

    var _button = _interopRequireDefault(require("@frontend-taglib-clay$clayui/button"));

    var _icon = _interopRequireDefault(require("@frontend-taglib-clay$clayui/icon"));

    var _panel = _interopRequireDefault(require("@frontend-taglib-clay$clayui/panel"));

    var _classnames = _interopRequireDefault(require("frontend-js-react-web$classnames"));

    var _react = _interopRequireDefault(require("frontend-js-react-web$react"));

    var _index = require("../../hooks/index.es");

    var _DropDown = _interopRequireDefault(require("../drop-down/DropDown.es"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * This library is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Lesser General Public License as published by the Free
     * Software Foundation; either version 2.1 of the License, or (at your option)
     * any later version.
     *
     * This library is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
     * details.
     */
    const CollapsablePanel = ({
      Header,
      actions,
      children,
      className,
      title
    }) => {
      const panelRef = _react.default.useRef(null);

      const [expanded, setExpanded] = _react.default.useState(false);

      const [transitioning, handleTransitionEnd, startTransition] = (0, _index.useHeightTransition)(expanded, setExpanded, panelRef);

      return (/*#__PURE__*/_react.default.createElement("div", {
          className: (0, _classnames.default)('collapsable-panel', 'panel', 'panel-unstyled', className),
          role: "tablist"
        }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, Header ? /*#__PURE__*/_react.default.createElement(Header, {
          expanded: expanded,
          setExpanded: setExpanded
        }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_button.default, {
          "aria-expanded": expanded,
          className: (0, _classnames.default)('collapse-icon', 'collapse-icon-middle', 'panel-header', 'panel-header-link', {
            collapsed: !(!expanded && transitioning || expanded && !transitioning)
          }),
          displayType: "unstyled",
          onClick: startTransition,
          role: "tab"
        }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("span", {
          className: "panel-title"
        }, title), /*#__PURE__*/_react.default.createElement("span", {
          className: (0, _classnames.default)('actions', 'collapse-icon-closed')
        }, /*#__PURE__*/_react.default.createElement(_icon.default, {
          symbol: "angle-down"
        })), /*#__PURE__*/_react.default.createElement("span", {
          className: (0, _classnames.default)('actions', 'collapse-icon-open')
        }, /*#__PURE__*/_react.default.createElement(_icon.default, {
          symbol: "angle-up"
        })))), actions && /*#__PURE__*/_react.default.createElement("div", {
          className: "collapse-icon-options"
        }, /*#__PURE__*/_react.default.createElement(_DropDown.default, {
          actions: actions
        }))), /*#__PURE__*/_react.default.createElement("div", {
          className: (0, _classnames.default)('panel-collapse', {
            collapse: !transitioning,
            collapsing: transitioning,
            show: expanded
          }),
          onTransitionEnd: handleTransitionEnd,
          ref: panelRef,
          role: "tabpanel"
        }, /*#__PURE__*/_react.default.createElement(_panel.default.Body, null, children))))
      );
    };

    var _default = CollapsablePanel;
    exports.default = _default;
    //# sourceMappingURL=CollapsablePanel.es.js.map
  }
});
//# sourceMappingURL=CollapsablePanel.es.js.map