Liferay.Loader.define("data-engine-taglib@2.5.34/data_layout_builder/js/components/drop-down/DropDown.es", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/button', '@frontend-taglib-clay$clayui/drop-down', '@frontend-taglib-clay$clayui/popover', 'frontend-js-react-web$react'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;

    var _button = require("@frontend-taglib-clay$clayui/button");

    var _dropDown = _interopRequireWildcard(require("@frontend-taglib-clay$clayui/drop-down"));

    var _popover = _interopRequireDefault(require("@frontend-taglib-clay$clayui/popover"));

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return { default: obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj.default = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * This library is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Lesser General Public License as published by the Free
     * Software Foundation; either version 2.1 of the License, or (at your option)
     * any later version.
     *
     * This library is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
     * details.
     */
    const {
      Item,
      ItemList
    } = _dropDown.default;

    var _default = ({
      actions,
      disabled
    }) => {
      const [active, setActive] = (0, _react.useState)(false);
      const [showPopover, setShowPopover] = (0, _react.useState)(false);

      const DropdownButton = /*#__PURE__*/_react.default.createElement(_button.ClayButtonWithIcon, {
        className: "page-link",
        disabled: disabled,
        displayType: "unstyled",
        symbol: "ellipsis-v"
      });

      if (actions.length === 0) {
        return DropdownButton;
      }

      const onSelectItem = (event, action) => {
        event.preventDefault();

        if (typeof action.action === 'function') {
          action.action();
        }

        setActive(false);
      };

      (0, _react.useEffect)(() => {
        if (showPopover && !active) {
          setShowPopover(false);
        }
      }, [active, showPopover]);
      return (/*#__PURE__*/_react.default.createElement(_dropDown.default, {
          active: active,
          alignmentPosition: _dropDown.Align.RightCenter,
          className: "dropdown-action",
          onActiveChange: item => setActive(item),
          trigger: DropdownButton
        }, /*#__PURE__*/_react.default.createElement(ItemList, null, actions.map((action, index) => {
          const ItemWrapper = () => /*#__PURE__*/_react.default.createElement(Item, {
            className: action.className,
            key: index,
            onClick: event => onSelectItem(event, action)
          }, action.name);

          if (action.popover) {
            const {
              alignPosition,
              body,
              header
            } = action.popover;
            return (/*#__PURE__*/_react.default.createElement(_popover.default, {
                alignPosition: alignPosition,
                disableScroll: true,
                header: header,
                show: showPopover,
                style: {
                  zIndex: 1420
                },
                trigger: /*#__PURE__*/_react.default.createElement("div", {
                  onMouseOut: () => setShowPopover(false),
                  onMouseOver: () => setShowPopover(true)
                }, /*#__PURE__*/_react.default.createElement(ItemWrapper, null))
              }, body)
            );
          }

          return (/*#__PURE__*/_react.default.createElement(ItemWrapper, {
              key: index
            })
          );
        })))
      );
    };

    exports.default = _default;
    //# sourceMappingURL=DropDown.es.js.map
  }
});
//# sourceMappingURL=DropDown.es.js.map