Liferay.Loader.define("data-engine-taglib@2.5.34/data_layout_builder/js/components/field-sets/FieldSetModal.es", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/button', '@frontend-taglib-clay$clayui/form', '@frontend-taglib-clay$clayui/modal', 'frontend-js-react-web$react', '../../App.es', '../../AppContext.es', '../../actions.es', '../../utils/dataLayoutVisitor.es', '../modal/ModalWithEventPrevented.es', './actions/useCreateFieldSet.es', './actions/usePropagateFieldSet.es', './actions/useSaveFieldSet.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;

    var _button = _interopRequireDefault(require("@frontend-taglib-clay$clayui/button"));

    var _form = require("@frontend-taglib-clay$clayui/form");

    var _modal = _interopRequireWildcard(require("@frontend-taglib-clay$clayui/modal"));

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _App = _interopRequireDefault(require("../../App.es"));

    var _AppContext = _interopRequireDefault(require("../../AppContext.es"));

    var _actions = require("../../actions.es");

    var _dataLayoutVisitor = require("../../utils/dataLayoutVisitor.es");

    var _ModalWithEventPrevented = _interopRequireDefault(require("../modal/ModalWithEventPrevented.es"));

    var _useCreateFieldSet = _interopRequireDefault(require("./actions/useCreateFieldSet.es"));

    var _usePropagateFieldSet = _interopRequireDefault(require("./actions/usePropagateFieldSet.es"));

    var _useSaveFieldSet = _interopRequireDefault(require("./actions/useSaveFieldSet.es"));

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return { default: obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj.default = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function _objectWithoutProperties(source, excluded) {
      if (source == null) return {};var target = _objectWithoutPropertiesLoose(source, excluded);var key, i;if (Object.getOwnPropertySymbols) {
        var sourceSymbolKeys = Object.getOwnPropertySymbols(source);for (i = 0; i < sourceSymbolKeys.length; i++) {
          key = sourceSymbolKeys[i];if (excluded.indexOf(key) >= 0) continue;if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue;target[key] = source[key];
        }
      }return target;
    }

    function _objectWithoutPropertiesLoose(source, excluded) {
      if (source == null) return {};var target = {};var sourceKeys = Object.keys(source);var key, i;for (i = 0; i < sourceKeys.length; i++) {
        key = sourceKeys[i];if (excluded.indexOf(key) >= 0) continue;target[key] = source[key];
      }return target;
    }

    function _extends() {
      _extends = Object.assign || function (target) {
        for (var i = 1; i < arguments.length; i++) {
          var source = arguments[i];for (var key in source) {
            if (Object.prototype.hasOwnProperty.call(source, key)) {
              target[key] = source[key];
            }
          }
        }return target;
      };return _extends.apply(this, arguments);
    }

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });keys.push.apply(keys, symbols);
      }return keys;
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
          ownKeys(Object(source), true).forEach(function (key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function (key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }return target;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    const ModalContent = ({
      childrenAppProps,
      defaultLanguageId,
      editingDataDefinition,
      fieldSet,
      onClose
    }) => {
      const [{
        appProps,
        config: appConfig
      }] = (0, _react.useContext)(_AppContext.default);
      const [childrenContext, setChildrenContext] = (0, _react.useState)({
        dataLayoutBuilder: null,
        dispatch: () => {},
        state: {}
      });
      const [dataLayoutIsEmpty, setDataLayoutIsEmpty] = (0, _react.useState)(true);
      const [name, setName] = (0, _react.useState)({});
      const {
        dataLayoutBuilder,
        dispatch,
        state: {
          dataLayout
        }
      } = childrenContext;
      const {
        contentType
      } = appProps;
      const availableLanguageIds = [...new Set([...Object.keys(name), defaultLanguageId])];

      const changeZIndex = zIndex => {
        document.querySelectorAll('.ddm-field-actions-container').forEach(container => {
          container.style.zIndex = zIndex;
        });
      };

      (0, _react.useEffect)(() => {
        if (fieldSet) {
          setName(fieldSet.name);
        }
      }, [fieldSet]);
      (0, _react.useEffect)(() => {
        if (contentType === 'app-builder') {
          dispatch({
            payload: {
              config: _objectSpread(_objectSpread({}, appConfig), {}, {
                allowFieldSets: false
              })
            },
            type: _actions.UPDATE_CONFIG
          });
        } // eslint-disable-next-line react-hooks/exhaustive-deps
      }, [contentType, dispatch]);
      (0, _react.useEffect)(() => {
        if (dataLayout) {
          const {
            dataLayoutPages
          } = dataLayout;
          setDataLayoutIsEmpty((0, _dataLayoutVisitor.isDataLayoutEmpty)(dataLayoutPages));
        }
      }, [dataLayout]);
      (0, _react.useEffect)(() => {
        if (dataLayoutBuilder) {
          changeZIndex('1050');
        }

        return () => {
          changeZIndex(null);
        };
      }, [dataLayoutBuilder]);
      (0, _react.useEffect)(() => {
        if (editingDataDefinition && editingDataDefinition.id) {
          dispatch({
            payload: {
              editingDataDefinitionId: editingDataDefinition.id
            },
            type: _actions.UPDATE_EDITING_DATA_DEFINITION_ID
          });
        }
      }, [dispatch, editingDataDefinition]);
      const actionProps = {
        availableLanguageIds,
        childrenContext,
        editingDataDefinition,
        fieldSet
      };
      const createFieldSet = (0, _useCreateFieldSet.default)(actionProps);
      const saveFieldSet = (0, _useSaveFieldSet.default)(actionProps);
      const propagateFieldSet = (0, _usePropagateFieldSet.default)();

      return (/*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_modal.default.Header, null, fieldSet ? Liferay.Language.get('edit-fieldset') : Liferay.Language.get('create-new-fieldset')), /*#__PURE__*/_react.default.createElement(_modal.default.Header, {
          withTitle: false
        }, /*#__PURE__*/_react.default.createElement(_form.ClayInput.Group, {
          className: "pl-4 pr-4"
        }, /*#__PURE__*/_react.default.createElement(_form.ClayInput.GroupItem, null, /*#__PURE__*/_react.default.createElement(_form.ClayInput, {
          "aria-label": Liferay.Language.get('untitled-fieldset'),
          autoFocus: true,
          className: "form-control-inline",
          onChange: ({
            target: {
              value
            }
          }) => setName(_objectSpread(_objectSpread({}, name), {}, {
            [defaultLanguageId]: value
          })),
          placeholder: Liferay.Language.get('untitled-fieldset'),
          type: "text",
          value: name[defaultLanguageId]
        })))), /*#__PURE__*/_react.default.createElement(_modal.default.Body, null, /*#__PURE__*/_react.default.createElement("div", {
          className: "pl-4 pr-4"
        }, /*#__PURE__*/_react.default.createElement(_App.default, _extends({}, appProps, {
          dataLayoutBuilderId: "".concat(appProps.dataLayoutBuilderId, "_2"),
          setChildrenContext: setChildrenContext
        }, childrenAppProps)))), /*#__PURE__*/_react.default.createElement(_modal.default.Footer, {
          last: /*#__PURE__*/_react.default.createElement(_button.default.Group, {
            spaced: true
          }, /*#__PURE__*/_react.default.createElement(_button.default, {
            displayType: "secondary",
            onClick: onClose
          }, Liferay.Language.get('cancel')), /*#__PURE__*/_react.default.createElement(_button.default, {
            disabled: !name[defaultLanguageId] || dataLayoutIsEmpty,
            onClick: () => {
              const hasRemovedField = () => {
                const fieldNames = fieldSet.dataDefinitionFields.map(({
                  name
                }) => name);
                const [prevLayoutFields, actualLayoutFields] = [fieldSet.defaultDataLayout.dataLayoutPages, dataLayout.dataLayoutPages].map(layout => fieldNames.filter(field => (0, _dataLayoutVisitor.containsField)(layout, field)));
                return !!prevLayoutFields.filter(field => !actualLayoutFields.includes(field)).length;
              };

              if (fieldSet) {
                propagateFieldSet({
                  fieldSet,
                  modal: _objectSpread({
                    actionMessage: Liferay.Language.get('propagate'),
                    fieldSetMessage: Liferay.Language.get('do-you-want-to-propagate-the-changes-to-other-objects-views-using-this-fieldset'),
                    headerMessage: Liferay.Language.get('propagate-changes')
                  }, hasRemovedField() && {
                    warningMessage: Liferay.Language.get('the-changes-include-the-deletion-of-fields-and-may-erase-the-data-collected-permanently')
                  }),
                  onPropagate: () => saveFieldSet(name)
                }).then(onClose).catch(onClose);
              } else {
                createFieldSet(name).then(onClose).catch(onClose);
              }
            }
          }, Liferay.Language.get('save')))
        }))
      );
    };

    const FieldSetModal = _ref => {
      let {
        isVisible,
        onClose: onCloseFn
      } = _ref,
          props = _objectWithoutProperties(_ref, ["isVisible", "onClose"]);

      const {
        observer,
        onClose
      } = (0, _modal.useModal)({
        onClose: onCloseFn
      });

      if (!isVisible) {
        return null;
      }

      return (/*#__PURE__*/_react.default.createElement(_modal.default, {
          className: "data-layout-builder-editor-modal fieldset-modal",
          observer: observer,
          size: "full-screen"
        }, /*#__PURE__*/_react.default.createElement(ModalContent, _extends({
          onClose: onClose
        }, props)))
      );
    };

    var _default = props => /*#__PURE__*/_react.default.createElement(_ModalWithEventPrevented.default, null, /*#__PURE__*/_react.default.createElement(FieldSetModal, props));

    exports.default = _default;
    //# sourceMappingURL=FieldSetModal.es.js.map
  }
});
//# sourceMappingURL=FieldSetModal.es.js.map