Liferay.Loader.define("data-engine-taglib@2.5.34/data_layout_builder/js/components/field-sets/FieldSets.es", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/button', 'frontend-js-react-web$react', '../../AppContext.es', '../../actions.es', '../../data-layout-builder/DataLayoutBuilderContext.es', '../../drag-and-drop/dragTypes.es', '../../utils/dataDefinition.es', '../../utils/lang.es', '../empty-state/EmptyState.es', '../field-types/FieldType.es', './FieldSetModal.es', './actions/useDeleteFieldSet.es', './actions/usePropagateFieldSet.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = FieldSets;

    var _button = _interopRequireDefault(require("@frontend-taglib-clay$clayui/button"));

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _AppContext = _interopRequireDefault(require("../../AppContext.es"));

    var _actions = require("../../actions.es");

    var _DataLayoutBuilderContext = _interopRequireDefault(require("../../data-layout-builder/DataLayoutBuilderContext.es"));

    var _dragTypes = require("../../drag-and-drop/dragTypes.es");

    var _dataDefinition = require("../../utils/dataDefinition.es");

    var _lang = require("../../utils/lang.es");

    var _EmptyState = _interopRequireDefault(require("../empty-state/EmptyState.es"));

    var _FieldType = _interopRequireDefault(require("../field-types/FieldType.es"));

    var _FieldSetModal = _interopRequireDefault(require("./FieldSetModal.es"));

    var _useDeleteFieldSet = _interopRequireDefault(require("./actions/useDeleteFieldSet.es"));

    var _usePropagateFieldSet = _interopRequireDefault(require("./actions/usePropagateFieldSet.es"));

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return { default: obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj.default = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function _extends() {
      _extends = Object.assign || function (target) {
        for (var i = 1; i < arguments.length; i++) {
          var source = arguments[i];for (var key in source) {
            if (Object.prototype.hasOwnProperty.call(source, key)) {
              target[key] = source[key];
            }
          }
        }return target;
      };return _extends.apply(this, arguments);
    }

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });keys.push.apply(keys, symbols);
      }return keys;
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
          ownKeys(Object(source), true).forEach(function (key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function (key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }return target;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    function FieldSets({
      keywords
    }) {
      const [dataLayoutBuilder] = (0, _react.useContext)(_DataLayoutBuilderContext.default);
      const [{
        appProps,
        dataDefinition,
        fieldSets
      }] = (0, _react.useContext)(_AppContext.default);
      const [state, setState] = (0, _react.useState)({
        childrenAppProps: {},
        editingDataDefinition: null,
        fieldSet: null,
        isVisible: false
      });
      let defaultLanguageId = themeDisplay.getDefaultLanguageId();

      const toggleFieldSet = (fieldSet, editingDataDefinition) => {
        let childrenAppProps = {
          availableLanguageIds: [defaultLanguageId],
          context: {},
          dataDefinitionId: null,
          dataLayoutId: null,
          editingLanguageId: defaultLanguageId
        };

        if (fieldSet) {
          const {
            context
          } = appProps;
          const {
            defaultDataLayout,
            id: dataDefinitionId
          } = fieldSet;
          const ddmForm = dataLayoutBuilder.getDDMForm(fieldSet, defaultDataLayout);
          const [{
            rows
          }] = ddmForm.pages;
          delete ddmForm.pages;
          defaultLanguageId = fieldSet.defaultLanguageId;
          childrenAppProps = {
            availableLanguageIds: fieldSet.availableLanguageIds,
            context: _objectSpread(_objectSpread({}, context), {}, {
              pages: [_objectSpread(_objectSpread({}, ddmForm), {}, {
                description: '',
                rows,
                title: ''
              })]
            }),
            dataDefinitionId,
            dataLayoutId: defaultDataLayout.id,
            editingLanguageId: defaultLanguageId
          };
        }

        setState({
          childrenAppProps,
          defaultLanguageId,
          editingDataDefinition,
          fieldSet,
          isVisible: !state.isVisible
        });
      };

      const deleteFieldSet = (0, _useDeleteFieldSet.default)({
        dataLayoutBuilder
      });
      const propagateFieldSet = (0, _usePropagateFieldSet.default)();

      const onDoubleClick = ({
        fieldSet: {
          name: fieldName
        },
        fieldSet
      }) => {
        const {
          activePage,
          pages
        } = dataLayoutBuilder.getStore();
        dataLayoutBuilder.dispatch('fieldSetAdded', (0, _actions.dropFieldSet)({
          dataLayoutBuilder,
          fieldName,
          fieldSet,
          indexes: {
            columnIndex: 0,
            pageIndex: activePage,
            rowIndex: pages[activePage].rows.length
          }
        }));
      };

      const filteredFieldSets = fieldSets.filter(({
        defaultLanguageId,
        name
      }) => new RegExp(keywords, 'ig').test((0, _lang.getLocalizedValue)(defaultLanguageId, name))).sort((a, b) => {
        const localizedValueA = (0, _lang.getLocalizedValue)(a.defaultLanguageId, a.name);
        const localizedValueB = (0, _lang.getLocalizedValue)(b.defaultLanguageId, b.name);
        return localizedValueA.localeCompare(localizedValueB);
      });

      const AddButton = () => /*#__PURE__*/_react.default.createElement(_button.default, {
        block: true,
        className: "add-fieldset",
        displayType: "secondary",
        onClick: () => toggleFieldSet(null, dataDefinition)
      }, Liferay.Language.get('create-new-fieldset'));

      return (/*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, filteredFieldSets.length ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(AddButton, null), /*#__PURE__*/_react.default.createElement("div", {
          className: "mt-3"
        }, filteredFieldSets.map(fieldSet => {
          const fieldSetLanguageId = fieldSet.defaultLanguageId;
          const fieldSetName = (0, _lang.getLocalizedValue)(fieldSetLanguageId, fieldSet.name);
          let editAction = {
            action: () => toggleFieldSet(fieldSet),
            name: Liferay.Language.get('edit')
          };

          if (defaultLanguageId !== fieldSetLanguageId) {
            editAction = _objectSpread(_objectSpread({}, editAction), {}, {
              className: 'disabled',
              popover: {
                alignPosition: 'left',
                body: Liferay.Language.get('the-fieldset-cannot-be-edited-because-the-instance-language-does-not-match-the-current-language-of-the-fieldset-recreate-the-fieldset-if-changes-are-required'),
                header: Liferay.Language.get('edit-not-allowed')
              }
            });
          }

          const dropDownActions = [editAction, {
            action: () => propagateFieldSet({
              fieldSet,
              isDeleteAction: true,
              modal: {
                actionMessage: Liferay.Language.get('delete'),
                fieldSetMessage: Liferay.Language.get('the-fieldset-will-be-deleted-permanently-from'),
                headerMessage: Liferay.Language.get('delete'),
                status: 'danger',
                warningMessage: Liferay.Language.get('this-action-may-erase-data-permanently')
              },
              onPropagate: deleteFieldSet
            }),
            name: Liferay.Language.get('delete')
          }];
          const disabled = dataDefinition.name[defaultLanguageId] === fieldSetName;
          return (/*#__PURE__*/_react.default.createElement(_FieldType.default, {
              actions: dropDownActions,
              description: "".concat(fieldSet.dataDefinitionFields.length, " ").concat(Liferay.Language.get('fields')),
              disabled: disabled || (0, _dataDefinition.containsFieldSet)(dataDefinition, fieldSet.id),
              dragType: _dragTypes.DRAG_FIELDSET,
              fieldSet: fieldSet,
              icon: "forms",
              key: fieldSet.dataDefinitionKey,
              label: fieldSetName,
              onDoubleClick: onDoubleClick
            })
          );
        }))) : /*#__PURE__*/_react.default.createElement("div", {
          className: "mt-2"
        }, /*#__PURE__*/_react.default.createElement(_EmptyState.default, {
          emptyState: {
            button: AddButton,
            description: Liferay.Language.get('there-are-no-fieldsets-description'),
            title: Liferay.Language.get('there-are-no-fieldsets')
          },
          keywords: keywords,
          small: true
        })), /*#__PURE__*/_react.default.createElement(_FieldSetModal.default, _extends({
          defaultLanguageId: defaultLanguageId,
          onClose: () => toggleFieldSet()
        }, state)))
      );
    }
    //# sourceMappingURL=FieldSets.es.js.map
  }
});
//# sourceMappingURL=FieldSets.es.js.map