Liferay.Loader.define("data-engine-taglib@2.5.34/data_layout_builder/js/components/field-sets/actions/useCreateFieldSet.es", ['module', 'exports', 'require', 'frontend-js-react-web$react', '../../../AppContext.es', '../../../actions.es', '../../../data-layout-builder/DataLayoutBuilderContext.es', '../../../utils/client.es', '../../../utils/toast.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;

    var _react = require("frontend-js-react-web$react");

    var _AppContext = _interopRequireDefault(require("../../../AppContext.es"));

    var _actions = require("../../../actions.es");

    var _DataLayoutBuilderContext = _interopRequireDefault(require("../../../data-layout-builder/DataLayoutBuilderContext.es"));

    var _client = require("../../../utils/client.es");

    var _toast = require("../../../utils/toast.es");

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * This library is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Lesser General Public License as published by the Free
     * Software Foundation; either version 2.1 of the License, or (at your option)
     * any later version.
     *
     * This library is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
     * details.
     */
    var _default = ({
      availableLanguageIds,
      childrenContext
    }) => {
      const [{
        fieldSets
      }, dispatch] = (0, _react.useContext)(_AppContext.default);
      const {
        state: childrenState
      } = childrenContext;
      const [dataLayoutBuilder] = (0, _react.useContext)(_DataLayoutBuilderContext.default);
      const {
        contentType,
        fieldSetContentType
      } = dataLayoutBuilder.props;
      return name => {
        const {
          dataDefinition: {
            dataDefinitionFields
          },
          dataLayout: {
            dataLayoutPages
          }
        } = childrenState;

        return (0, _client.addItem)("/o/data-engine/v2.0/data-definitions/by-content-type/".concat(fieldSetContentType || contentType), {
          availableLanguageIds,
          dataDefinitionFields,
          defaultDataLayout: {
            dataLayoutPages,
            name
          },
          name
        }).then(dataDefinitionFieldSet => {
          dispatch({
            payload: {
              fieldSets: [...fieldSets, dataDefinitionFieldSet]
            },
            type: _actions.UPDATE_FIELDSETS
          });
          (0, _toast.successToast)(Liferay.Language.get('fieldset-saved'));
          return Promise.resolve();
        }).catch(({
          message
        }) => (0, _toast.errorToast)(message));
      };
    };

    exports.default = _default;
    //# sourceMappingURL=useCreateFieldSet.es.js.map
  }
});
//# sourceMappingURL=useCreateFieldSet.es.js.map