Liferay.Loader.define("data-engine-taglib@2.5.34/data_layout_builder/js/components/field-sets/actions/useDeleteFieldSet.es", ['module', 'exports', 'require', 'dynamic-data-mapping-form-renderer', 'frontend-js-react-web$react', '../../../AppContext.es', '../../../actions.es', '../../../utils/client.es', '../../../utils/toast.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;

    var _dynamicDataMappingFormRenderer = require("dynamic-data-mapping-form-renderer");

    var _react = require("frontend-js-react-web$react");

    var _AppContext = _interopRequireDefault(require("../../../AppContext.es"));

    var _actions = require("../../../actions.es");

    var _client = require("../../../utils/client.es");

    var _toast = require("../../../utils/toast.es");

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * This library is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Lesser General Public License as published by the Free
     * Software Foundation; either version 2.1 of the License, or (at your option)
     * any later version.
     *
     * This library is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
     * details.
     */
    var _default = ({
      dataLayoutBuilder
    }) => {
      const [{
        dataDefinition,
        fieldSets
      }, dispatch] = (0, _react.useContext)(_AppContext.default);
      return fieldSet => {

        return (0, _client.deleteItem)("".concat('/o/data-engine/v2.0/data-definitions/').concat(fieldSet.id)).then(() => {
          const dataDefinitionField = dataDefinition.dataDefinitionFields.find(({
            customProperties: {
              ddmStructureId
            }
          }) => ddmStructureId == fieldSet.id);

          if (dataDefinitionField) {
            const {
              pages
            } = dataLayoutBuilder.getStore();
            const visitor = new _dynamicDataMappingFormRenderer.PagesVisitor(pages);
            const fieldName = dataDefinitionField.name;


            if (visitor.containsField(fieldName, true)) {
              dataLayoutBuilder.dispatch('fieldDeleted', {
                activePage: 0,
                fieldName
              });
            } else {
              dispatch({
                payload: {
                  fieldName
                },
                type: _actions.DELETE_DATA_DEFINITION_FIELD
              });
            }
          }

          return Promise.resolve();
        }).then(() => {
          dispatch({
            payload: {
              fieldSets: fieldSets.filter(({
                id
              }) => id !== fieldSet.id)
            },
            type: _actions.UPDATE_FIELDSETS
          });
          (0, _toast.successToast)(Liferay.Language.get('the-item-was-deleted-successfully'));
          return Promise.resolve();
        }).catch(() => (0, _toast.errorToast)(Liferay.Language.get('the-item-could-not-be-deleted')));
      };
    };

    exports.default = _default;
    //# sourceMappingURL=useDeleteFieldSet.es.js.map
  }
});
//# sourceMappingURL=useDeleteFieldSet.es.js.map