Liferay.Loader.define("data-engine-taglib@2.5.34/data_layout_builder/js/components/field-sets/actions/usePropagateFieldSet.es", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/alert', '@frontend-taglib-clay$clayui/button/lib/Button', '@frontend-taglib-clay$clayui/modal', '@frontend-taglib-clay$clayui/panel', 'frontend-js-react-web$react', '../../../AppContext.es', '../../../utils/client.es', '../../../utils/dataDefinition.es', '../../../utils/dataLayoutVisitor.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;

    var _alert = _interopRequireDefault(require("@frontend-taglib-clay$clayui/alert"));

    var _Button = _interopRequireDefault(require("@frontend-taglib-clay$clayui/button/lib/Button"));

    var _modal = require("@frontend-taglib-clay$clayui/modal");

    var _panel = _interopRequireDefault(require("@frontend-taglib-clay$clayui/panel"));

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _AppContext = _interopRequireDefault(require("../../../AppContext.es"));

    var _client = require("../../../utils/client.es");

    var _dataDefinition = require("../../../utils/dataDefinition.es");

    var _dataLayoutVisitor = require("../../../utils/dataLayoutVisitor.es");

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return { default: obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj.default = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });keys.push.apply(keys, symbols);
      }return keys;
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
          ownKeys(Object(source), true).forEach(function (key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function (key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }return target;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    function _objectWithoutProperties(source, excluded) {
      if (source == null) return {};var target = _objectWithoutPropertiesLoose(source, excluded);var key, i;if (Object.getOwnPropertySymbols) {
        var sourceSymbolKeys = Object.getOwnPropertySymbols(source);for (i = 0; i < sourceSymbolKeys.length; i++) {
          key = sourceSymbolKeys[i];if (excluded.indexOf(key) >= 0) continue;if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue;target[key] = source[key];
        }
      }return target;
    }

    function _objectWithoutPropertiesLoose(source, excluded) {
      if (source == null) return {};var target = {};var sourceKeys = Object.keys(source);var key, i;for (i = 0; i < sourceKeys.length; i++) {
        key = sourceKeys[i];if (excluded.indexOf(key) >= 0) continue;target[key] = source[key];
      }return target;
    }

    const getName = ({
      name = {}
    }) => {
      const defaultLanguageId = Liferay.ThemeDisplay.getDefaultLanguageId();
      return name[defaultLanguageId] || Liferay.Language.get('untitled');
    };

    const FieldInfo = ({
      label,
      value
    }) => /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement("label", null, "".concat(label, ":")), /*#__PURE__*/_react.default.createElement("span", null, value));

    const FieldListItems = ({
      items,
      name
    }) => {
      return items.map((item, index) => {
        if (!item[name].length) {
          return null;
        }

        return (/*#__PURE__*/_react.default.createElement("div", {
            className: "mb-4",
            key: index
          }, /*#__PURE__*/_react.default.createElement("label", null, getName(item.dataDefinition)), /*#__PURE__*/_react.default.createElement("ol", null, item[name].map((content, index) => /*#__PURE__*/_react.default.createElement("li", {
            key: index
          }, getName(content)))))
        );
      });
    };

    var _default = () => {
      const [{
        dataDefinition,
        dataLayout
      }] = (0, _react.useContext)(_AppContext.default);
      const [{
        onClose
      }, dispatchModal] = (0, _react.useContext)(_modal.Context);
      const defaultLanguageId = Liferay.ThemeDisplay.getDefaultLanguageId();
      return ({
        fieldSet,
        isDeleteAction,
        modal,
        onPropagate
      }) => {
        return (0, _client.getItem)("/o/data-engine/v2.0/data-definitions/".concat(fieldSet.id, "/data-definition-field-links")).then(({
          items: response
        }) => {
          const items = response;
          const dataDefinitionFieldSet = (0, _dataDefinition.getDataDefinitionFieldSet)(dataDefinition.dataDefinitionFields, fieldSet.id);
          const fieldInDataLayout = dataDefinitionFieldSet && (0, _dataLayoutVisitor.containsField)(dataLayout.dataLayoutPages, dataDefinitionFieldSet.name);
          const item = items.find(({
            dataDefinition: linkedDataDefinition
          }) => linkedDataDefinition.id === dataDefinition.id);

          if (item) {
            const {
              dataLayouts
            } = item;
            const dataLayoutIndex = dataLayouts.findIndex(({
              id
            }) => id === dataLayout.id);

            if (dataLayoutIndex === -1 && fieldInDataLayout) {
              dataLayouts.push(dataLayout);
            } else if (dataLayoutIndex !== -1 && !fieldInDataLayout) {
              dataLayouts.splice(dataLayoutIndex, 1);
            }
          } else if (fieldInDataLayout) {
            items.push({
              dataDefinition,
              dataLayouts: [dataLayout],
              dataListViews: []
            });
          }

          const dataLayouts = [];
          const dataListViews = [];
          items.forEach(item => {
            dataLayouts.push(...item.dataLayouts);
            dataListViews.push(...item.dataListViews);
          });
          const isFieldSetUsed = !!dataLayouts.length || !!dataListViews.length;

          if (!isDeleteAction && (!items.length || !isFieldSetUsed)) {
            return onPropagate(fieldSet);
          }

          return new Promise(resolve => {
            const {
              actionMessage,
              fieldSetMessage,
              headerMessage,
              warningMessage
            } = modal,
                  otherModalProps = _objectWithoutProperties(modal, ["actionMessage", "fieldSetMessage", "headerMessage", "warningMessage"]);

            const payload = {
              payload: _objectSpread({
                body: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isFieldSetUsed && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, warningMessage && /*#__PURE__*/_react.default.createElement(_alert.default, {
                  displayType: "warning"
                }, /*#__PURE__*/_react.default.createElement("strong", null, Liferay.Language.get('warning'), ":"), warningMessage), fieldSetMessage && /*#__PURE__*/_react.default.createElement("p", {
                  className: "fieldset-message"
                }, fieldSetMessage)), isDeleteAction && !isFieldSetUsed && /*#__PURE__*/_react.default.createElement(_panel.default, {
                  className: "remove-object-field-panel",
                  displayTitle: Liferay.Language.get('field'),
                  displayType: "secondary"
                }, /*#__PURE__*/_react.default.createElement(_panel.default.Body, null, dataDefinitionFieldSet && /*#__PURE__*/_react.default.createElement(FieldInfo, {
                  label: Liferay.Language.get('name'),
                  value: dataDefinitionFieldSet.name
                }), /*#__PURE__*/_react.default.createElement(FieldInfo, {
                  label: Liferay.Language.get('label'),
                  value: fieldSet.name[defaultLanguageId]
                }), /*#__PURE__*/_react.default.createElement(FieldInfo, {
                  label: Liferay.Language.get('value'),
                  value: Liferay.Language.get('fieldset')
                }))), dataLayouts.length > 0 && /*#__PURE__*/_react.default.createElement(_panel.default, {
                  className: "remove-object-field-panel",
                  displayTitle: Liferay.Language.get('form-views'),
                  displayType: "secondary"
                }, /*#__PURE__*/_react.default.createElement(_panel.default.Body, null, /*#__PURE__*/_react.default.createElement(FieldListItems, {
                  items: items,
                  name: "dataLayouts"
                }))), dataListViews.length > 0 && /*#__PURE__*/_react.default.createElement(_panel.default, {
                  className: "remove-object-field-panel",
                  displayTitle: Liferay.Language.get('table-views'),
                  displayType: "secondary"
                }, /*#__PURE__*/_react.default.createElement(_panel.default.Body, null, /*#__PURE__*/_react.default.createElement(FieldListItems, {
                  items: items,
                  name: "dataListViews"
                }))), isDeleteAction && !isFieldSetUsed && /*#__PURE__*/_react.default.createElement("p", {
                  className: "remove-object-field-message"
                }, Liferay.Language.get('are-you-sure-you-want-to-delete-this-fieldset-it-will-be-deleted-immediately'))),
                footer: [/*#__PURE__*/_react.default.createElement(_react.default.Fragment, null), /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null), /*#__PURE__*/_react.default.createElement(_Button.default.Group, {
                  key: 0,
                  spaced: true
                }, /*#__PURE__*/_react.default.createElement(_Button.default, {
                  displayType: "secondary",
                  key: 1,
                  onClick: onClose
                }, Liferay.Language.get('cancel')), /*#__PURE__*/_react.default.createElement(_Button.default, {
                  key: 2,
                  onClick: () => {
                    onPropagate(fieldSet);
                    onClose();
                  }
                }, actionMessage))],
                header: headerMessage,
                size: 'md'
              }, otherModalProps),
              type: 1
            };
            resolve(dispatchModal(payload));
          });
        });
      };
    };

    exports.default = _default;
    //# sourceMappingURL=usePropagateFieldSet.es.js.map
  }
});
//# sourceMappingURL=usePropagateFieldSet.es.js.map