Liferay.Loader.define("data-engine-taglib@2.5.34/data_layout_builder/js/components/field-sets/actions/useSaveFieldSet.es", ['module', 'exports', 'require', 'frontend-js-react-web$react', '../../../AppContext.es', '../../../actions.es', '../../../data-layout-builder/DataLayoutBuilderContext.es', '../../../utils/client.es', '../../../utils/dataDefinition.es', '../../../utils/dataLayoutVisitor.es', '../../../utils/toast.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;

    var _react = require("frontend-js-react-web$react");

    var _AppContext = _interopRequireDefault(require("../../../AppContext.es"));

    var _actions = require("../../../actions.es");

    var _DataLayoutBuilderContext = _interopRequireDefault(require("../../../data-layout-builder/DataLayoutBuilderContext.es"));

    var _client = require("../../../utils/client.es");

    var _dataDefinition = require("../../../utils/dataDefinition.es");

    var _dataLayoutVisitor = require("../../../utils/dataLayoutVisitor.es");

    var _toast = require("../../../utils/toast.es");

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });keys.push.apply(keys, symbols);
      }return keys;
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
          ownKeys(Object(source), true).forEach(function (key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function (key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }return target;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    var _default = ({
      availableLanguageIds,
      childrenContext,
      fieldSet
    }) => {
      const [context, dispatch] = (0, _react.useContext)(_AppContext.default);
      const [dataLayoutBuilder] = (0, _react.useContext)(_DataLayoutBuilderContext.default);
      const {
        dataDefinition,
        dataLayout,
        fieldSets
      } = context;
      const {
        state: childrenState
      } = childrenContext;
      return name => {
        const {
          dataDefinition: {
            dataDefinitionFields
          },
          dataLayout: {
            dataLayoutPages
          }
        } = childrenState;

        const normalizedFieldSet = _objectSpread(_objectSpread({}, fieldSet), {}, {
          availableLanguageIds,
          dataDefinitionFields,
          defaultDataLayout: _objectSpread(_objectSpread({}, fieldSet.defaultDataLayout), {}, {
            dataLayoutPages
          }),
          name
        });

        return (0, _client.updateItem)("/o/data-engine/v2.0/data-definitions/".concat(fieldSet.id), normalizedFieldSet).then(() => {
          const dataDefinitionFieldSet = (0, _dataDefinition.getDataDefinitionFieldSet)(dataDefinition.dataDefinitionFields, fieldSet.id);

          const normalizedDataDefinitionFields = () => dataDefinition.dataDefinitionFields.map(field => {
            const {
              customProperties: {
                ddmStructureId
              }
            } = field;

            if (ddmStructureId == fieldSet.id) {
              return _objectSpread(_objectSpread({}, field), {}, {
                nestedDataDefinitionFields: dataDefinitionFields
              });
            }

            return field;
          });

          if (dataDefinitionFieldSet) {
            const fieldName = dataDefinitionFieldSet.name;

            if ((0, _dataLayoutVisitor.containsField)(dataLayout.dataLayoutPages, fieldName)) {
              dataLayoutBuilder.dispatch('fieldEditedProperties', {
                defaultLanguageId: fieldSet.defaultLanguageId,
                fieldName,
                properties: [{
                  name: 'nestedFields',
                  value: dataDefinitionFields.map(({
                    name
                  }) => dataLayoutBuilder.getDDMFormField(childrenState.dataDefinition, name))
                }, {
                  name: 'rows',
                  value: (0, _dataLayoutVisitor.normalizeDataLayoutRows)(dataLayoutPages)
                }]
              });
            } else {
              dispatch({
                payload: {
                  dataDefinition: _objectSpread(_objectSpread({}, dataDefinition), {}, {
                    dataDefinitionFields: normalizedDataDefinitionFields()
                  })
                },
                type: _actions.UPDATE_DATA_DEFINITION
              });
            }
          }

          return Promise.resolve();
        }).then(() => {
          dispatch({
            payload: {
              fieldSets: fieldSets.map(field => {
                if (fieldSet.id === field.id) {
                  return normalizedFieldSet;
                }

                return field;
              })
            },
            type: _actions.UPDATE_FIELDSETS
          });
          (0, _toast.successToast)(Liferay.Language.get('fieldset-saved'));
          return Promise.resolve();
        }).catch(({
          message
        }) => (0, _toast.errorToast)(message));
      };
    };

    exports.default = _default;
    //# sourceMappingURL=useSaveFieldSet.es.js.map
  }
});
//# sourceMappingURL=useSaveFieldSet.es.js.map