Liferay.Loader.define("data-engine-taglib@2.5.34/data_layout_builder/js/components/field-types/FieldType.es", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/icon', '@frontend-taglib-clay$clayui/layout', '@frontend-taglib-clay$clayui/loading-indicator', '@frontend-taglib-clay$clayui/sticker', '@frontend-taglib-clay$clayui/tooltip', 'frontend-js-react-web$classnames', 'frontend-js-react-web$react', 'frontend-js-react-web$react-dnd', 'frontend-js-react-web$react-dnd-html5-backend', '../../drag-and-drop/dragTypes.es', '../button/Button.es', '../drop-down/DropDown.es', './FieldTypeDragPreview.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;

    var _icon = _interopRequireDefault(require("@frontend-taglib-clay$clayui/icon"));

    var _layout = _interopRequireDefault(require("@frontend-taglib-clay$clayui/layout"));

    var _loadingIndicator = _interopRequireDefault(require("@frontend-taglib-clay$clayui/loading-indicator"));

    var _sticker = _interopRequireDefault(require("@frontend-taglib-clay$clayui/sticker"));

    var _tooltip = require("@frontend-taglib-clay$clayui/tooltip");

    var _classnames = _interopRequireDefault(require("frontend-js-react-web$classnames"));

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _reactDnd = require("frontend-js-react-web$react-dnd");

    var _reactDndHtml5Backend = require("frontend-js-react-web$react-dnd-html5-backend");

    var _dragTypes = require("../../drag-and-drop/dragTypes.es");

    var _Button = _interopRequireDefault(require("../button/Button.es"));

    var _DropDown = _interopRequireDefault(require("../drop-down/DropDown.es"));

    var _FieldTypeDragPreview = _interopRequireDefault(require("./FieldTypeDragPreview.es"));

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return { default: obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj.default = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });keys.push.apply(keys, symbols);
      }return keys;
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
          ownKeys(Object(source), true).forEach(function (key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function (key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }return target;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    const ICONS = {
      checkbox_multiple: 'select-from-list',
      document_library: 'upload',
      numeric: 'caret-double',
      radio: 'radio-button',
      select: 'list'
    };

    var _default = props => {
      const {
        actions,
        active,
        className,
        deleteLabel = Liferay.Language.get('delete'),
        description,
        disabled,
        dragAlignment = 'left',
        draggable = true,
        dragType = _dragTypes.DRAG_FIELD_TYPE,
        icon,
        label,
        name,
        onClick,
        onDelete,
        onDoubleClick
      } = props;
      const [{
        dragging
      }, drag, preview] = (0, _reactDnd.useDrag)({
        canDrag: _ => !disabled && draggable,
        collect: monitor => ({
          dragging: monitor.isDragging()
        }),
        item: {
          data: _objectSpread({}, props),
          preview: () => /*#__PURE__*/_react.default.createElement(_FieldTypeDragPreview.default, props),
          type: dragType
        }
      });
      (0, _react.useEffect)(() => {
        preview((0, _reactDndHtml5Backend.getEmptyImage)(), {
          captureDraggingState: true
        });
      }, [preview]);

      const [loading, setLoading] = (0, _react.useState)(false);
      const fieldIcon = ICONS[icon] ? ICONS[icon] : icon;
      return (/*#__PURE__*/_react.default.createElement(_layout.default.ContentRow, {
          className: (0, _classnames.default)(className, 'field-type', {
            active,
            disabled,
            dragging,
            loading
          }),
          "data-field-type-name": name,
          onClick: onClick && (() => {
            onClick(_objectSpread({}, props));
          }),
          onDoubleClick: onDoubleClick && (() => {
            if (disabled) {
              return;
            }

            onDoubleClick(_objectSpread({}, props));
          }),
          ref: drag,
          verticalAlign: "center"
        }, draggable && dragAlignment === 'left' && /*#__PURE__*/_react.default.createElement(_layout.default.ContentCol, {
          className: "pl-2 pr-2"
        }, /*#__PURE__*/_react.default.createElement(_icon.default, {
          symbol: "drag"
        })), /*#__PURE__*/_react.default.createElement(_layout.default.ContentCol, {
          className: (0, _classnames.default)('pr-2', {
            'pl-2': dragAlignment === 'right'
          })
        }, /*#__PURE__*/_react.default.createElement(_sticker.default, {
          className: "data-layout-builder-field-sticker",
          displayType: "light",
          size: "md"
        }, /*#__PURE__*/_react.default.createElement(_icon.default, {
          symbol: fieldIcon
        }))), /*#__PURE__*/_react.default.createElement(_layout.default.ContentCol, {
          className: "pr-2",
          expand: true
        }, /*#__PURE__*/_react.default.createElement("h4", {
          className: "list-group-title text-truncate"
        }, /*#__PURE__*/_react.default.createElement("span", null, label)), description && /*#__PURE__*/_react.default.createElement("p", {
          className: "list-group-subtitle text-truncate"
        }, /*#__PURE__*/_react.default.createElement("small", null, description))), /*#__PURE__*/_react.default.createElement("div", {
          className: "autofit-col pr-2"
        }, actions && /*#__PURE__*/_react.default.createElement(_DropDown.default, {
          actions: actions
        })), draggable && dragAlignment === 'right' && /*#__PURE__*/_react.default.createElement(_layout.default.ContentCol, {
          className: "pr-2"
        }, /*#__PURE__*/_react.default.createElement(_icon.default, {
          symbol: "drag"
        })), onDelete && /*#__PURE__*/_react.default.createElement("div", {
          className: "field-type-remove-icon"
        }, loading ? /*#__PURE__*/_react.default.createElement(_loadingIndicator.default, null) : /*#__PURE__*/_react.default.createElement(_tooltip.ClayTooltipProvider, null, /*#__PURE__*/_react.default.createElement(_Button.default, {
          borderless: true,
          "data-tooltip-align": "right",
          "data-tooltip-delay": "200",
          displayType: "secondary",
          onClick: event => {
            event.stopPropagation();
            setLoading(true);
            onDelete(name).then(() => setLoading(false)).catch(error => {
              setLoading(false);
              throw error;
            });
          },
          symbol: "times-circle",
          title: deleteLabel
        }))))
      );
    };

    exports.default = _default;
    //# sourceMappingURL=FieldType.es.js.map
  }
});
//# sourceMappingURL=FieldType.es.js.map