Liferay.Loader.define("data-engine-taglib@2.5.34/data_layout_builder/js/components/rules/RuleEditorModal.es", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/button', '@frontend-taglib-clay$clayui/form', '@frontend-taglib-clay$clayui/modal', 'dynamic-data-mapping-form-builder', 'frontend-js-react-web$react', '../../AppContext.es', '../../data-layout-builder/DataLayoutBuilderContext.es', '../../utils/client.es', '../modal/ModalWithEventPrevented.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;

    var _button = _interopRequireDefault(require("@frontend-taglib-clay$clayui/button"));

    var _form = require("@frontend-taglib-clay$clayui/form");

    var _modal = _interopRequireWildcard(require("@frontend-taglib-clay$clayui/modal"));

    var _dynamicDataMappingFormBuilder = require("dynamic-data-mapping-form-builder");

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _AppContext = _interopRequireDefault(require("../../AppContext.es"));

    var _DataLayoutBuilderContext = _interopRequireDefault(require("../../data-layout-builder/DataLayoutBuilderContext.es"));

    var _client = require("../../utils/client.es");

    var _ModalWithEventPrevented = _interopRequireDefault(require("../modal/ModalWithEventPrevented.es"));

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return { default: obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj.default = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });keys.push.apply(keys, symbols);
      }return keys;
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
          ownKeys(Object(source), true).forEach(function (key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function (key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }return target;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    class RuleEditorWrapper extends _dynamicDataMappingFormBuilder.RuleEditor {
      getChildContext() {
        return {
          store: {
            editingLanguageId: Liferay.ThemeDisplay.getDefaultLanguageId()
          }
        };
      }

    }

    const RuleEditorModalContent = ({
      onClose,
      rule
    }) => {
      const ruleEditorRef = (0, _react.useRef)();
      const [invalidRule, setInvalidRule] = (0, _react.useState)(true);
      const [ruleEditor, setRuleEditor] = (0, _react.useState)(null);
      const [ruleName, setRuleName] = (0, _react.useState)('');
      const [{
        config: {
          ruleSettings
        },
        spritemap
      }] = (0, _react.useContext)(_AppContext.default);
      const [dataLayoutBuilder] = (0, _react.useContext)(_DataLayoutBuilderContext.default);
      const {
        pages
      } = dataLayoutBuilder.getStore();
      const [state, setState] = (0, _react.useState)({
        isLoading: true,
        roles: []
      });
      const onChangeRuleName = (0, _react.useCallback)(value => {
        setRuleName(value);
      }, []);
      (0, _react.useEffect)(() => {
        if (rule) {
          onChangeRuleName(rule.name.en_US);
        }
      }, [onChangeRuleName, rule]);
      (0, _react.useEffect)(() => {
        const {
          isLoading,
          roles
        } = state;

        if (isLoading || ruleEditor !== null) {
          return;
        }

        const ruleEditorWrapper = new RuleEditorWrapper(_objectSpread(_objectSpread({}, ruleSettings), {}, {
          actions: [],
          conditions: [],
          events: {
            ruleAdded: rule => {
              dataLayoutBuilder.dispatch('ruleAdded', rule);
              onClose();
            },
            ruleCancelled: () => {},
            ruleDeleted: () => {},
            ruleEdited: rule => {
              dataLayoutBuilder.dispatch('ruleEdited', rule);
              onClose();
            },
            ruleValidatorChanged: isInvalid => setInvalidRule(isInvalid)
          },
          key: 'create',
          pages,
          ref: 'RuleEditor',
          roles,
          rule,
          spritemap
        }, rule && {
          ruleEditedIndex: rule.ruleEditedIndex
        }), ruleEditorRef.current);
        setRuleEditor(ruleEditorWrapper);
      }, [dataLayoutBuilder, onClose, pages, ruleEditor, ruleEditorRef, rule, ruleSettings, spritemap, state]);
      (0, _react.useEffect)(() => {
        return () => ruleEditor && ruleEditor.dispose();
      }, [ruleEditor]);
      (0, _react.useEffect)(() => {
        (0, _client.getItem)('/o/headless-admin-user/v1.0/roles').then(({
          items: roles = []
        }) => {
          roles = roles.map(({
            id,
            name
          }) => ({
            id: "".concat(id),
            label: name,
            name,
            value: name
          }));
          setState(prevState => _objectSpread(_objectSpread({}, prevState), {}, {
            isLoading: false,
            roles
          }));
        });
      }, []);
      return (/*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_modal.default.Header, null, rule ? Liferay.Language.get('edit-rule') : Liferay.Language.get('create-new-rule')), /*#__PURE__*/_react.default.createElement(_modal.default.Header, {
          withTitle: false
        }, /*#__PURE__*/_react.default.createElement(_form.ClayInput.Group, {
          className: "pl-4 pr-4"
        }, /*#__PURE__*/_react.default.createElement(_form.ClayInput.GroupItem, null, /*#__PURE__*/_react.default.createElement(_form.ClayInput, {
          "aria-label": Liferay.Language.get('untitled-rule'),
          className: "form-control-inline",
          onChange: ({
            target: {
              value
            }
          }) => onChangeRuleName(value),
          placeholder: Liferay.Language.get('untitled-rule'),
          type: "text",
          value: ruleName
        })))), /*#__PURE__*/_react.default.createElement(_modal.default.Body, null, /*#__PURE__*/_react.default.createElement("div", {
          className: "pl-4 pr-4",
          ref: ruleEditorRef
        })), /*#__PURE__*/_react.default.createElement(_modal.default.Footer, {
          last: /*#__PURE__*/_react.default.createElement(_button.default.Group, {
            spaced: true
          }, /*#__PURE__*/_react.default.createElement(_button.default, {
            displayType: "secondary",
            onClick: onClose
          }, Liferay.Language.get('cancel')), /*#__PURE__*/_react.default.createElement(_button.default, {
            disabled: invalidRule || !ruleName,
            onClick: () => rule ? ruleEditor.handleRuleEdited({
              ruleName
            }) : ruleEditor.handleRuleAdded({
              ruleName
            })
          }, Liferay.Language.get('save')))
        }))
      );
    };

    const RuleEditorModal = ({
      isVisible,
      onClose: onCloseFn,
      rule
    }) => {
      const {
        observer,
        onClose
      } = (0, _modal.useModal)({
        onClose: onCloseFn
      });

      if (!isVisible) {
        return null;
      }

      return (/*#__PURE__*/_react.default.createElement(_modal.default, {
          className: "data-layout-builder-editor-modal",
          observer: observer,
          size: "full-screen"
        }, /*#__PURE__*/_react.default.createElement(RuleEditorModalContent, {
          onClose: onClose,
          rule: rule
        }))
      );
    };

    var _default = props => /*#__PURE__*/_react.default.createElement(_ModalWithEventPrevented.default, null, /*#__PURE__*/_react.default.createElement(RuleEditorModal, props));

    exports.default = _default;
    //# sourceMappingURL=RuleEditorModal.es.js.map
  }
});
//# sourceMappingURL=RuleEditorModal.es.js.map