Liferay.Loader.define("data-engine-taglib@2.5.34/data_layout_builder/js/components/rules/RuleItem.es", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/button', '@frontend-taglib-clay$clayui/label', 'frontend-js-react-web$classnames', 'frontend-js-react-web$react', '../../AppContext.es', '../../actions.es', '../../utils/dataDefinition.es', '../../utils/lang.es', '../collapsable-panel/CollapsablePanel.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = RuleItem;

    var _button = _interopRequireDefault(require("@frontend-taglib-clay$clayui/button"));

    var _label = _interopRequireDefault(require("@frontend-taglib-clay$clayui/label"));

    var _classnames = _interopRequireDefault(require("frontend-js-react-web$classnames"));

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _AppContext = _interopRequireDefault(require("../../AppContext.es"));

    var _actions = require("../../actions.es");

    var _dataDefinition = require("../../utils/dataDefinition.es");

    var _lang = require("../../utils/lang.es");

    var _CollapsablePanel = _interopRequireDefault(require("../collapsable-panel/CollapsablePanel.es"));

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return { default: obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj.default = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * This library is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Lesser General Public License as published by the Free
     * Software Foundation; either version 2.1 of the License, or (at your option)
     * any later version.
     *
     * This library is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
     * details.
     */
    const ACTION_LABELS = {
      autofill: Liferay.Language.get('autofill'),
      calculate: Liferay.Language.get('calculate'),
      enable: Liferay.Language.get('enable'),
      require: Liferay.Language.get('require'),
      show: Liferay.Language.get('show')
    };
    const OPERATOR_LABELS = {
      'belongs-to': Liferay.Language.get('belongs-to'),
      contains: Liferay.Language.get('contains'),
      'equals-to': Liferay.Language.get('equals-to'),
      'is-empty': Liferay.Language.get('is-empty'),
      'not-contains': Liferay.Language.get('not-contains'),
      'not-equals-to': Liferay.Language.get('not-equals-to'),
      'not-is-empty': Liferay.Language.get('not-is-empty')
    };

    const Text = ({
      capitalize = false,
      children = '',
      lowercase = false
    }) => /*#__PURE__*/_react.default.createElement("span", {
      className: (0, _classnames.default)('pr-1', {
        'text-capitalize': capitalize,
        'text-lowercase': lowercase
      })
    }, children);

    function RuleItem({
      rule,
      toggleRulesEditorVisibility
    }) {
      const {
        actions,
        conditions,
        logicalOperator,
        name: ruleName
      } = rule;
      const [{
        dataDefinition
      }, dispatch] = (0, _react.useContext)(_AppContext.default);
      const {
        defaultLanguageId
      } = dataDefinition;
      const name = (0, _lang.getLocalizedValue)(defaultLanguageId, ruleName);
      const dropDownActions = [{
        action: () => toggleRulesEditorVisibility(rule),
        name: Liferay.Language.get('edit')
      }, {
        action: () => {
          const confirmed = confirm(Liferay.Language.get('are-you-sure-you-want-to-delete-this'));

          if (confirmed) {
            dispatch({
              payload: rule,
              type: _actions.DELETE_DATA_LAYOUT_RULE
            });
          }
        },
        name: Liferay.Language.get('delete')
      }];

      const replaceExpressionLabels = expression => {
        (0, _dataDefinition.forEachDataDefinitionField)(dataDefinition, ({
          name
        }) => {
          expression = expression.replace(new RegExp("\\[".concat(name, "\\]"), 'g'), (0, _dataDefinition.getFieldLabel)(dataDefinition, name));
        });
        return expression;
      };

      return (/*#__PURE__*/_react.default.createElement(_CollapsablePanel.default, {
          actions: dropDownActions,
          title: name
        }, /*#__PURE__*/_react.default.createElement(_button.default, {
          displayType: "unstyled",
          onClick: () => toggleRulesEditorVisibility(rule)
        }, /*#__PURE__*/_react.default.createElement(Text, {
          capitalize: true
        }, Liferay.Language.get('if')), conditions.map(({
          operands,
          operator
        }, index) => {
          const [first, last] = operands;
          const lastValue = last === null || last === void 0 ? void 0 : last.value;

          return (/*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(Text, {
              lowercase: true
            }, Liferay.Language.get('field')), /*#__PURE__*/_react.default.createElement(_label.default, {
              displayType: "success"
            }, (0, _dataDefinition.getFieldLabel)(dataDefinition, first.value)), /*#__PURE__*/_react.default.createElement(_label.default, {
              displayType: "secondary"
            }, OPERATOR_LABELS[operator] || operator), lastValue && /*#__PURE__*/_react.default.createElement(_label.default, {
              displayType: "info"
            }, (() => {
              const field = (0, _dataDefinition.getDataDefinitionField)(dataDefinition, lastValue);

              if (field) {
                return (0, _dataDefinition.getFieldLabel)(dataDefinition, lastValue);
              }

              const parent = (0, _dataDefinition.getDataDefinitionField)(dataDefinition, first.value);

              if (parent) {
                var _parent$customPropert;

                const optionLabel = (0, _dataDefinition.getOptionLabel)((_parent$customPropert = parent.customProperties) === null || _parent$customPropert === void 0 ? void 0 : _parent$customPropert.options, lastValue, defaultLanguageId);
                return optionLabel || lastValue;
              }

              return lastValue;
            })()), index + 1 !== conditions.length && /*#__PURE__*/_react.default.createElement(_label.default, {
              displayType: "warning"
            }, logicalOperator))
          );
        }), actions.map(({
          action,
          expression,
          target
        }, index) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(Text, {
          lowercase: true
        }, ACTION_LABELS[action] || action), expression && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_label.default, {
          displayType: "secondary"
        }, replaceExpressionLabels(expression)), /*#__PURE__*/_react.default.createElement(Text, {
          lowercase: true
        }, Liferay.Language.get('into'))), /*#__PURE__*/_react.default.createElement(_label.default, {
          displayType: "success"
        }, (0, _dataDefinition.getFieldLabel)(dataDefinition, target)), index + 1 !== actions.length && /*#__PURE__*/_react.default.createElement(_label.default, {
          displayType: "warning"
        }, Liferay.Language.get('and'))))))
      );
    }
    //# sourceMappingURL=RuleItem.es.js.map
  }
});
//# sourceMappingURL=RuleItem.es.js.map