Liferay.Loader.define("data-engine-taglib@2.5.34/data_layout_builder/js/components/search-input/SearchInput.es", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/button', '@frontend-taglib-clay$clayui/form', 'frontend-js-react-web$react'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.SearchInputWithForm = exports.default = void 0;

    var _button = require("@frontend-taglib-clay$clayui/button");

    var _form = _interopRequireWildcard(require("@frontend-taglib-clay$clayui/form"));

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return { default: obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj.default = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _extends() {
      _extends = Object.assign || function (target) {
        for (var i = 1; i < arguments.length; i++) {
          var source = arguments[i];for (var key in source) {
            if (Object.prototype.hasOwnProperty.call(source, key)) {
              target[key] = source[key];
            }
          }
        }return target;
      };return _extends.apply(this, arguments);
    }

    function _objectWithoutProperties(source, excluded) {
      if (source == null) return {};var target = _objectWithoutPropertiesLoose(source, excluded);var key, i;if (Object.getOwnPropertySymbols) {
        var sourceSymbolKeys = Object.getOwnPropertySymbols(source);for (i = 0; i < sourceSymbolKeys.length; i++) {
          key = sourceSymbolKeys[i];if (excluded.indexOf(key) >= 0) continue;if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue;target[key] = source[key];
        }
      }return target;
    }

    function _objectWithoutPropertiesLoose(source, excluded) {
      if (source == null) return {};var target = {};var sourceKeys = Object.keys(source);var key, i;for (i = 0; i < sourceKeys.length; i++) {
        key = sourceKeys[i];if (excluded.indexOf(key) >= 0) continue;target[key] = source[key];
      }return target;
    }

    const SearchInput = /*#__PURE__*/_react.default.forwardRef((_ref, ref) => {
      let {
        clearButton = true,
        onChange: _onChange = () => {},
        onSubmit = () => {},
        searchText = ''
      } = _ref,
          restProps = _objectWithoutProperties(_ref, ["clearButton", "onChange", "onSubmit", "searchText"]);

      const [value, setValue] = (0, _react.useState)(searchText);
      const fallbackRef = (0, _react.useRef)(null);
      const searchInputRef = ref ? ref : fallbackRef;
      (0, _react.useEffect)(() => {
        setValue(searchText);
      }, [searchText]);

      const onClear = () => {
        setValue('');

        _onChange('');

        searchInputRef.current.focus();
      };

      let SearchButton = /*#__PURE__*/_react.default.createElement(_button.ClayButtonWithIcon, _extends({
        displayType: "unstyled",
        key: "searcgButton",
        onClick: _ => onSubmit(value),
        symbol: "search"
      }, restProps));

      if (clearButton && value) {
        SearchButton = /*#__PURE__*/_react.default.createElement(_button.ClayButtonWithIcon, {
          displayType: "unstyled",
          key: "clearButton",
          onClick: onClear,
          symbol: "times"
        });
      }

      return (/*#__PURE__*/_react.default.createElement(_form.ClayInput.Group, null, /*#__PURE__*/_react.default.createElement(_form.ClayInput.GroupItem, null, /*#__PURE__*/_react.default.createElement(_form.ClayInput, _extends({
          "aria-label": Liferay.Language.get('search'),
          className: "input-group-inset input-group-inset-after",
          onChange: ({
            target: {
              value
            }
          }) => {
            setValue(value);

            _onChange(value);
          },
          placeholder: "".concat(Liferay.Language.get('search'), "..."),
          ref: searchInputRef,
          type: "text",
          value: value
        }, restProps)), /*#__PURE__*/_react.default.createElement(_form.ClayInput.GroupInsetItem, {
          after: true
        }, SearchButton)))
      );
    });

    const SearchInputWithForm = _ref2 => {
      let {
        onSubmit = () => {}
      } = _ref2,
          restProps = _objectWithoutProperties(_ref2, ["onSubmit"]);

      const [searchText, setSearchText] = (0, _react.useState)('');

      const handleSubmit = value => {
        onSubmit(value.trim());
      };

      return (/*#__PURE__*/_react.default.createElement(_form.default, {
          onSubmit: event => {
            event.preventDefault();
            handleSubmit(searchText);
          }
        }, /*#__PURE__*/_react.default.createElement(SearchInput, _extends({
          clearButton: false,
          onChange: searchText => setSearchText(searchText),
          onSubmit: handleSubmit
        }, restProps)))
      );
    };

    exports.SearchInputWithForm = SearchInputWithForm;
    var _default = SearchInput;
    exports.default = _default;
    //# sourceMappingURL=SearchInput.es.js.map
  }
});
//# sourceMappingURL=SearchInput.es.js.map