Liferay.Loader.define("data-engine-taglib@2.5.34/data_layout_builder/js/components/sidebar/MultiPanelSidebar.es", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/button', '@frontend-taglib-clay$clayui/icon', '@frontend-taglib-clay$clayui/loading-indicator', '@frontend-taglib-clay$clayui/tooltip', 'frontend-js-react-web$classnames', 'frontend-js-react-web', 'frontend-js-react-web$react', '../../AppContext.es', '../../hooks/useLazy.es', '../../hooks/useLoad.es', '../../hooks/usePlugins.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = MultiPanelSidebar;

    var _button = _interopRequireWildcard(require("@frontend-taglib-clay$clayui/button"));

    var _icon = _interopRequireDefault(require("@frontend-taglib-clay$clayui/icon"));

    var _loadingIndicator = _interopRequireDefault(require("@frontend-taglib-clay$clayui/loading-indicator"));

    var _tooltip = require("@frontend-taglib-clay$clayui/tooltip");

    var _classnames = _interopRequireDefault(require("frontend-js-react-web$classnames"));

    var _frontendJsReactWeb = require("frontend-js-react-web");

    var _react = _interopRequireDefault(require("frontend-js-react-web$react"));

    var _AppContext = _interopRequireDefault(require("../../AppContext.es"));

    var _useLazy = _interopRequireDefault(require("../../hooks/useLazy.es"));

    var _useLoad = _interopRequireDefault(require("../../hooks/useLoad.es"));

    var _usePlugins = _interopRequireDefault(require("../../hooks/usePlugins.es"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return { default: obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj.default = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * This library is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Lesser General Public License as published by the Free
     * Software Foundation; either version 2.1 of the License, or (at your option)
     * any later version.
     *
     * This library is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
     * details.
     */
    const {
      Suspense,
      useCallback,
      useContext,
      useEffect
    } = _react.default;
    /**
     * Failure to preload is a non-critical failure, so we'll use this to swallow
     * rejected promises silently.
     */

    const swallow = [value => value, _error => undefined];

    function MultiPanelSidebar({
      panels,
      sidebarPanels,
      variant = 'dark'
    }) {
      const [{
        sidebarOpen,
        sidebarPanelId
      }, dispatch] = useContext(_AppContext.default);
      const [hasError, setHasError] = (0, _frontendJsReactWeb.useStateSafe)(false);
      const isMounted = (0, _frontendJsReactWeb.useIsMounted)();
      const load = (0, _useLoad.default)();
      const {
        getInstance,
        register
      } = (0, _usePlugins.default)();
      const panel = sidebarPanels[sidebarPanelId];
      const promise = panel ? load(sidebarPanelId, panel.pluginEntryPoint) : Promise.resolve();

      let registerPanel;

      if (sidebarPanelId) {
        registerPanel = register(sidebarPanelId, promise, {
          app: {
            dispatch,
            panel,
            sidebarOpen,
            sidebarPanelId
          },
          panel
        });
      }

      const togglePlugin = () => {
        if (hasError) {
          setHasError(false);
        }

        if (registerPanel) {
          registerPanel.then(plugin => {
            if (plugin && typeof plugin.activate === 'function' && isMounted()) {
              plugin.activate();
            } else if (!plugin) {
              setHasError(true);
            }
          });
        }
      };

      useEffect(() => {
        if (panel) {
          togglePlugin(panel);
        } else if (sidebarPanelId) {
          dispatch({
            payload: {
              sidebarOpen: false,
              sidebarPanelId: null
            },
            type: 'SWITCH_SIDEBAR_PANEL'
          });
        }
      },
      /* eslint-disable react-hooks/exhaustive-deps */
      [panel, sidebarOpen, sidebarPanelId]);

      const changeAlertClassName = styleName => {
        const formBuilderMessage = document.querySelector('.data-engine-form-builder-messages');
        const className = formBuilderMessage.className;
        formBuilderMessage.className = className.replace(formBuilderMessage.className, styleName);
      };

      useEffect(() => {
        const sideNavigation = Liferay.SideNavigation.instance(document.querySelector('.product-menu-toggle'));

        if (sideNavigation) {

          const sideNavigationListener = sideNavigation.on('openStart.lexicon.sidenav', () => {
            if (sidebarOpen) {
              changeAlertClassName('data-engine-form-builder-messages');
            }

            dispatch({
              payload: {
                sidebarOpen: false,
                sidebarPanelId: null
              },
              type: 'SWITCH_SIDEBAR_PANEL'
            });
          });
          return () => {
            sideNavigationListener.removeListener();
          };
        }
      }, []);
      const SidebarPanel = (0, _useLazy.default)(useCallback(({
        instance
      }) => {
        if (typeof instance.renderSidebar === 'function') {
          return instance.renderSidebar();
        } else if (typeof instance === 'function') {
          return instance;
        } else {
          return null;
        }
      }, []));

      const handleClick = panel => {
        const open = panel.sidebarPanelId === sidebarPanelId ? !sidebarOpen : true;
        const productMenuToggle = document.querySelector('.product-menu-toggle');

        if (productMenuToggle && !sidebarOpen) {
          Liferay.SideNavigation.hide(productMenuToggle);
        }

        if (open) {
          changeAlertClassName('data-engine-form-builder-messages data-engine-form-builder-messages--collapsed');
        } else {
          changeAlertClassName('data-engine-form-builder-messages');
        }

        dispatch({
          payload: {
            sidebarOpen: open,
            sidebarPanelId: panel.sidebarPanelId
          },
          type: 'SWITCH_SIDEBAR_PANEL'
        });
      };

      return (/*#__PURE__*/_react.default.createElement(_tooltip.ClayTooltipProvider, null, /*#__PURE__*/_react.default.createElement("div", {
          className: (0, _classnames.default)('multi-panel-sidebar', "multi-panel-sidebar-".concat(variant), {
            'publications-enabled': document.querySelector('.change-tracking-indicator')
          })
        }, /*#__PURE__*/_react.default.createElement("nav", {
          className: (0, _classnames.default)('multi-panel-sidebar-buttons', 'tbar', 'tbar-stacked', variant === 'dark' ? "tbar-".concat(variant, "-d1") : "tbar-".concat(variant))
        }, /*#__PURE__*/_react.default.createElement("ul", {
          className: "tbar-nav"
        }, panels.reduce((elements, group, groupIndex) => {
          const buttons = group.map(panelId => {
            const panel = sidebarPanels[panelId];
            const active = sidebarOpen && sidebarPanelId === panelId;
            const {
              icon,
              isLink,
              label,
              pluginEntryPoint,
              url
            } = panel;

            const prefetch = () => load(panel.sidebarPanelId, pluginEntryPoint).then(...swallow);

            const btnClasses = (0, _classnames.default)('tbar-btn tbar-btn-monospaced', {
              active
            });
            return (/*#__PURE__*/_react.default.createElement("li", {
                className: (0, _classnames.default)('tbar-item', "tbar-item--".concat(panel.sidebarPanelId)),
                key: panel.sidebarPanelId
              }, isLink ? /*#__PURE__*/_react.default.createElement("a", {
                className: btnClasses,
                href: url
              }, /*#__PURE__*/_react.default.createElement(_icon.default, {
                symbol: icon
              })) : /*#__PURE__*/_react.default.createElement(_button.ClayButtonWithIcon, {
                "aria-pressed": active,
                className: btnClasses,
                "data-tooltip-align": "left",
                displayType: "unstyled",
                id: panel.sidebarPanelId,
                onClick: () => handleClick(panel),
                onFocus: prefetch,
                onMouseEnter: prefetch,
                symbol: icon,
                title: label
              }))
            );
          });

          if (groupIndex === panels.length - 1) {
            return elements.concat(buttons);
          } else {
            return elements.concat([...buttons, /*#__PURE__*/_react.default.createElement("hr", {
              key: "separator-".concat(groupIndex)
            })]);
          }
        }, []))), /*#__PURE__*/_react.default.createElement("div", {
          className: (0, _classnames.default)('multi-panel-sidebar-content', {
            'multi-panel-sidebar-content-open': sidebarOpen
          })
        }, hasError ? /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_button.default, {
          block: true,
          displayType: "secondary",
          onClick: () => {
            dispatch({
              payload: {
                sidebarOpen: false,
                sidebarPanelId: panels[0] && panels[0][0]
              },
              type: 'SWITCH_SIDEBAR_PANEL'
            });
            setHasError(false);
          },
          small: true
        }, Liferay.Language.get('refresh'))) : /*#__PURE__*/_react.default.createElement(ErrorBoundary, {
          handleError: () => {
            setHasError(true);
          }
        }, /*#__PURE__*/_react.default.createElement(Suspense, {
          fallback: /*#__PURE__*/_react.default.createElement(_loadingIndicator.default, null)
        }, /*#__PURE__*/_react.default.createElement(SidebarPanel, {
          getInstance: getInstance,
          pluginId: sidebarPanelId
        }))))))
      );
    }

    class ErrorBoundary extends _react.default.Component {
      static getDerivedStateFromError(_error) {
        return {
          hasError: true
        };
      }

      constructor(props) {
        super(props);
        this.state = {
          hasError: false
        };
      }

      componentDidCatch(error) {
        if (this.props.handleError) {
          this.props.handleError(error);
        }
      }

      render() {
        if (this.state.hasError) {
          return null;
        } else {
          return this.props.children;
        }
      }

    }
    //# sourceMappingURL=MultiPanelSidebar.es.js.map
  }
});
//# sourceMappingURL=MultiPanelSidebar.es.js.map