Liferay.Loader.define("data-engine-taglib@2.5.34/data_layout_builder/js/components/sidebar/Sidebar.es", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/layout', 'frontend-js-react-web$classnames', 'frontend-js-react-web$react', '../search-input/SearchInput.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = exports.SidebarTabContent = exports.SidebarTabs = exports.SidebarTab = exports.SidebarSearchInput = exports.SidebarHeader = exports.SidebarFooter = exports.SidebarBody = void 0;

    var _layout = _interopRequireDefault(require("@frontend-taglib-clay$clayui/layout"));

    var _classnames = _interopRequireDefault(require("frontend-js-react-web$classnames"));

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _SearchInput = _interopRequireDefault(require("../search-input/SearchInput.es"));

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return { default: obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj.default = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * This library is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Lesser General Public License as published by the Free
     * Software Foundation; either version 2.1 of the License, or (at your option)
     * any later version.
     *
     * This library is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
     * details.
     */
    const Sidebar = /*#__PURE__*/_react.default.forwardRef(({
      children,
      className
    }, ref) => {
      return (/*#__PURE__*/_react.default.createElement("div", {
          className: (0, _classnames.default)(className, 'data-layout-builder-sidebar'),
          ref: ref
        }, /*#__PURE__*/_react.default.createElement("div", {
          className: "sidebar sidebar-light"
        }, children))
      );
    });

    const SidebarBody = ({
      children,
      className
    }) => {
      return (/*#__PURE__*/_react.default.createElement("div", {
          className: (0, _classnames.default)(className, 'sidebar-body')
        }, children)
      );
    };

    exports.SidebarBody = SidebarBody;

    const SidebarFooter = ({
      children
    }) => {
      return (/*#__PURE__*/_react.default.createElement("div", {
          className: "sidebar-footer"
        }, children)
      );
    };

    exports.SidebarFooter = SidebarFooter;

    const SidebarHeader = ({
      children,
      className
    }) => {
      return (/*#__PURE__*/_react.default.createElement("div", {
          className: (0, _classnames.default)(className, 'sidebar-header')
        }, children)
      );
    };

    exports.SidebarHeader = SidebarHeader;

    const SidebarSearchInput = ({
      children,
      onSearch,
      searchText
    }) => /*#__PURE__*/_react.default.createElement(_layout.default.ContentRow, {
      className: "sidebar-section"
    }, /*#__PURE__*/_react.default.createElement(_layout.default.ContentCol, {
      expand: true
    }, onSearch && /*#__PURE__*/_react.default.createElement(_SearchInput.default, {
      onChange: searchText => onSearch(searchText),
      searchText: searchText
    })), children);

    exports.SidebarSearchInput = SidebarSearchInput;

    const SidebarTabs = ({
      initialSelectedTab = 0,
      setKeywords = () => {},
      tabs
    }) => {
      const [selectedTab, setSelectedTab] = (0, _react.useState)(initialSelectedTab);
      return (/*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(SidebarTab, {
          onTabClick: value => {
            setSelectedTab(value);
            setKeywords('');
          },
          selectedTab: selectedTab,
          tabs: tabs
        }), /*#__PURE__*/_react.default.createElement(SidebarTabContent, null, tabs[selectedTab].render()))
      );
    };

    exports.SidebarTabs = SidebarTabs;

    const SidebarTab = ({
      onTabClick,
      selectedTab,
      tabs
    }) => {
      return (/*#__PURE__*/_react.default.createElement("nav", {
          className: "component-tbar tbar"
        }, /*#__PURE__*/_react.default.createElement(_layout.default.ContainerFluid, null, /*#__PURE__*/_react.default.createElement("ul", {
          className: "nav nav-underline",
          role: "tablist"
        }, tabs.map(({
          label
        }, index) => /*#__PURE__*/_react.default.createElement("li", {
          className: "nav-item",
          key: index
        }, /*#__PURE__*/_react.default.createElement("button", {
          className: (0, _classnames.default)('btn btn-unstyled nav-link', {
            active: selectedTab === index
          }),
          "data-senna-off": true,
          onClick: event => {
            event.preventDefault();
            onTabClick(index);
          },
          role: "tab"
        }, label))))))
      );
    };

    exports.SidebarTab = SidebarTab;

    const SidebarTabContent = ({
      children
    }) => {
      return (/*#__PURE__*/_react.default.createElement("div", {
          className: "tab-content"
        }, /*#__PURE__*/_react.default.createElement("div", {
          className: "active fade mt-3 show tab-pane",
          role: "tabpanel"
        }, children))
      );
    };

    exports.SidebarTabContent = SidebarTabContent;

    const SidebarTitle = ({
      title
    }) => /*#__PURE__*/_react.default.createElement(_layout.default.ContentRow, {
      className: "mb-3 sidebar-section"
    }, /*#__PURE__*/_react.default.createElement(_layout.default.ContentCol, {
      expand: true
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "component-title"
    }, /*#__PURE__*/_react.default.createElement("span", {
      className: "text-truncate-inline"
    }, title))));

    Sidebar.Body = SidebarBody;
    Sidebar.Footer = SidebarFooter;
    Sidebar.Header = SidebarHeader;
    Sidebar.SearchInput = SidebarSearchInput;
    Sidebar.Tab = SidebarTab;
    Sidebar.Tabs = SidebarTabs;
    Sidebar.TabContent = SidebarTabContent;
    Sidebar.Title = SidebarTitle;
    var _default = Sidebar;
    exports.default = _default;
    //# sourceMappingURL=Sidebar.es.js.map
  }
});
//# sourceMappingURL=Sidebar.es.js.map