Liferay.Loader.define('data-engine-taglib@2.5.34/data_layout_builder/js/components/sidebar/initializeSidebarConfig.es', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = initializeSidebarConfig;
    exports.config = void 0;

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });keys.push.apply(keys, symbols);
      }return keys;
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
          ownKeys(Object(source), true).forEach(function (key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function (key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }return target;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * This library is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Lesser General Public License as published by the Free
     * Software Foundation; either version 2.1 of the License, or (at your option)
     * any later version.
     *
     * This library is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
     * details.
     */
    const DEFAULT_CONFIG = {
      sidebarVariant: 'light',
      toolbarId: 'dataEngineToolbar'
    };
    const config = null;
    /**
     * Extracts the immutable parts from the server data.
     *
     * Unlike data in the store, this config does not change over the lifetime of
     * the app, so we can safely store is as a variable.
     */

    exports.config = config;

    function initializeSidebarConfig(backendInfo) {
      const toolbarId = "".concat(backendInfo.portletNamespace).concat(DEFAULT_CONFIG.toolbarId); // Special items requiring augmentation, creation, or transformation.

      const augmentedPanels = augmentPanelData(Object.values(backendInfo.sidebarPanels));
      const syntheticItems = {
        panels: generatePanels(augmentedPanels),
        sidebarPanels: partitionPanels(augmentedPanels),
        toolbarId
      };
      return _objectSpread(_objectSpread({}, DEFAULT_CONFIG), syntheticItems);
    }
    /**
     * In general, we expect the sidebarPanelId to correspond with the name
     * of a plugin. Here we deal with the exceptions by mapping IDs to
     * plugin names.
     */

    const SIDEBAR_PANEL_IDS_TO_PLUGINS = {
      elements: 'fragments'
    };

    function augmentPanelData(sidebarPanels) {
      return sidebarPanels.map(panel => {
        if (isSeparator(panel) || panel.isLink) {
          return panel;
        }

        const mapping = SIDEBAR_PANEL_IDS_TO_PLUGINS[panel.sidebarPanelId];
        const sidebarPanelId = mapping || panel.sidebarPanelId;
        return _objectSpread(_objectSpread({}, panel), {}, {
          sidebarPanelId
        });
      });
    }

    function generatePanels(sidebarPanels) {
      return sidebarPanels.reduce((groups, panel) => {
        if (isSeparator(panel)) {
          groups.push([]);
        } else {
          groups[groups.length - 1].push(panel.sidebarPanelId);
        }

        return groups;
      }, [[]]);
    }

    function isSeparator(panel) {
      return panel.sidebarPanelId === 'separator';
    }
    /**
     * Instead of using fake panels with an ID of `separator`, partition the panels
     * array into an array of arrays; we'll draw a separator between each group.
     */

    function partitionPanels(panels) {
      return panels.reduce((map, panel) => {
        const {
          sidebarPanelId
        } = panel;

        if (!isSeparator(panel)) {
          map[sidebarPanelId] = panel;
        }

        return map;
      }, {});
    }
    //# sourceMappingURL=initializeSidebarConfig.es.js.map
  }
});
//# sourceMappingURL=initializeSidebarConfig.es.js.map