Liferay.Loader.define("data-engine-taglib@2.5.34/data_layout_builder/js/components/translation-manager/TranslationManager.es", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/button', '@frontend-taglib-clay$clayui/drop-down', '@frontend-taglib-clay$clayui/icon', 'frontend-js-react-web$classnames', 'frontend-js-react-web$react'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = exports.TranslationManagerLabel = exports.formatIcon = exports.formatLabel = void 0;

    var _button = _interopRequireDefault(require("@frontend-taglib-clay$clayui/button"));

    var _dropDown = _interopRequireDefault(require("@frontend-taglib-clay$clayui/drop-down"));

    var _icon = _interopRequireDefault(require("@frontend-taglib-clay$clayui/icon"));

    var _classnames = _interopRequireDefault(require("frontend-js-react-web$classnames"));

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return { default: obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj.default = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * This library is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Lesser General Public License as published by the Free
     * Software Foundation; either version 2.1 of the License, or (at your option)
     * any later version.
     *
     * This library is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
     * details.
     */
    const formatLabel = label => label.replace('_', '-');

    exports.formatLabel = formatLabel;

    const formatIcon = label => formatLabel(label).toLowerCase();

    exports.formatIcon = formatIcon;

    const TranslationManagerLabel = ({
      defaultLanguageId,
      languageId,
      translatedLanguageIds
    }) => {
      let className = 'label-warning';
      let label = Liferay.Language.get('not-translated');

      if (languageId === defaultLanguageId) {
        className = 'label-info';
        label = Liferay.Language.get('default');
      } else if (translatedLanguageIds[languageId]) {
        className = 'label-success';
        label = Liferay.Language.get('translated');
      }

      return (/*#__PURE__*/_react.default.createElement("span", {
          className: "autofit-col"
        }, /*#__PURE__*/_react.default.createElement("span", {
          className: (0, _classnames.default)('label', className)
        }, /*#__PURE__*/_react.default.createElement("span", {
          className: "label-item label-item-expand"
        }, label)))
      );
    };

    exports.TranslationManagerLabel = TranslationManagerLabel;

    var _default = ({
      availableLanguageIds,
      defaultLanguageId,
      editingLanguageId,
      onActiveChange = () => {},
      onEditingLanguageIdChange,
      showUserView = false,
      translatedLanguageIds,
      className
    }) => {
      const [active, setActive] = (0, _react.useState)(false);
      const [_availableLanguageIds, setAvailableLanguageIds] = (0, _react.useState)({});
      const [available, setAvailable] = (0, _react.useState)({});
      (0, _react.useEffect)(() => {
        AUI().use('portal-available-languages', () => {
          setAvailable(Liferay.Language.available);
        });
      }, []);
      (0, _react.useEffect)(() => {
        setAvailableLanguageIds(availableLanguageIds || available);
      }, [available, availableLanguageIds]);
      (0, _react.useEffect)(() => {
        onActiveChange(active);
      }, [active, onActiveChange]);
      return (/*#__PURE__*/_react.default.createElement(_dropDown.default, {
          active: active,
          className: (0, _classnames.default)('localizable-dropdown', className),
          onActiveChange: newVal => setActive(newVal),
          trigger: /*#__PURE__*/_react.default.createElement(_button.default, {
            displayType: "secondary",
            monospaced: !showUserView,
            small: showUserView,
            symbol: formatLabel(editingLanguageId)
          }, /*#__PURE__*/_react.default.createElement("span", {
            className: "inline-item"
          }, /*#__PURE__*/_react.default.createElement(_icon.default, {
            symbol: formatIcon(editingLanguageId)
          })), showUserView ? /*#__PURE__*/_react.default.createElement("span", {
            className: "localizable-dropdown-label ml-2"
          }, available[editingLanguageId]) : /*#__PURE__*/_react.default.createElement("span", {
            className: "btn-section"
          }, formatLabel(editingLanguageId)), showUserView && /*#__PURE__*/_react.default.createElement(_icon.default, {
            className: "ml-2",
            symbol: "caret-bottom"
          }))
        }, /*#__PURE__*/_react.default.createElement(_dropDown.default.ItemList, {
          className: "localizable-dropdown-ul"
        }, Object.keys(_availableLanguageIds).map((languageId, index) => /*#__PURE__*/_react.default.createElement(_dropDown.default.Item, {
          className: (0, _classnames.default)('autofit-row', {
            ['localizable-item-default']: languageId === defaultLanguageId
          }),
          key: index,
          onClick: () => {
            onEditingLanguageIdChange(languageId);
            setActive(false);
          }
        }, /*#__PURE__*/_react.default.createElement("span", {
          className: "autofit-col autofit-col-expand"
        }, /*#__PURE__*/_react.default.createElement("span", {
          className: "autofit-section"
        }, /*#__PURE__*/_react.default.createElement("span", {
          className: "inline-item inline-item-before"
        }, /*#__PURE__*/_react.default.createElement(_icon.default, {
          symbol: formatIcon(languageId)
        })), showUserView ? available[languageId] : formatLabel(languageId))), !showUserView && /*#__PURE__*/_react.default.createElement(TranslationManagerLabel, {
          defaultLanguageId: defaultLanguageId,
          languageId: languageId,
          translatedLanguageIds: translatedLanguageIds
        })))))
      );
    };

    exports.default = _default;
    //# sourceMappingURL=TranslationManager.es.js.map
  }
});
//# sourceMappingURL=TranslationManager.es.js.map