Liferay.Loader.define("data-engine-taglib@2.5.34/data_layout_builder/js/data-layout-builder/DataLayoutBuilder.es", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/layout', 'frontend-js-react-web$classnames', 'dynamic-data-mapping-form-builder', 'dynamic-data-mapping-form-renderer', 'frontend-js-metal-web$metal', 'frontend-js-react-web$react', '../drag-and-drop/dragTypes.es', '../utils/dataDefinition.es', '../utils/generateDataDefinitionFieldName.es', './EventEmitter.es', './saveDefinitionAndLayout.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.DataLayoutBuilder = exports.default = void 0;

    var _layout = _interopRequireDefault(require("@frontend-taglib-clay$clayui/layout"));

    var _classnames = _interopRequireDefault(require("frontend-js-react-web$classnames"));

    var _dynamicDataMappingFormBuilder = _interopRequireWildcard(require("dynamic-data-mapping-form-builder"));

    var _dynamicDataMappingFormRenderer = require("dynamic-data-mapping-form-renderer");

    var _metal = _interopRequireDefault(require("frontend-js-metal-web$metal"));

    var _react = _interopRequireDefault(require("frontend-js-react-web$react"));

    var _dragTypes = require("../drag-and-drop/dragTypes.es");

    var _dataDefinition = require("../utils/dataDefinition.es");

    var _generateDataDefinitionFieldName = _interopRequireDefault(require("../utils/generateDataDefinitionFieldName.es"));

    var _EventEmitter = _interopRequireDefault(require("./EventEmitter.es"));

    var _saveDefinitionAndLayout = _interopRequireDefault(require("./saveDefinitionAndLayout.es"));

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return { default: obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj.default = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });keys.push.apply(keys, symbols);
      }return keys;
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
          ownKeys(Object(source), true).forEach(function (key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function (key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }return target;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    /**
     * Data Layout Builder.
     * @extends React.Component
     */
    class DataLayoutBuilder extends _react.default.Component {
      constructor(props) {
        super(props);
        this.containerRef = /*#__PURE__*/_react.default.createRef();
        this.eventEmitter = new _EventEmitter.default();
        this.state = {};
      }

      componentDidMount() {
        const {
          config,
          dataLayoutBuilderId,
          fieldTypes,
          localizable,
          portletNamespace
        } = this.props;

        const context = this._setContext(this.props.context);

        this.formBuilderWithLayoutProvider = new _dynamicDataMappingFormBuilder.default({
          events: {
            attached: () => {
              this.props.onLoad(this);
              Liferay.component(dataLayoutBuilderId, this);
            }
          },
          formBuilderProps: {
            allowNestedFields: config.allowNestedFields,
            dnd: {
              accept: [_dragTypes.DRAG_DATA_DEFINITION_FIELD, _dragTypes.DRAG_FIELDSET, _dragTypes.DRAG_FIELD_TYPE]
            },
            fieldTypes,
            portletNamespace,
            ref: 'builder'
          },
          layoutProviderProps: _objectSpread(_objectSpread({}, this.props), {}, {
            allowMultiplePages: config.allowMultiplePages,
            allowSuccessPage: config.allowSuccessPage,
            context,
            defaultLanguageId: themeDisplay.getDefaultLanguageId(),
            editingLanguageId: themeDisplay.getDefaultLanguageId(),
            initialPages: context.pages,
            ref: 'layoutProvider',
            rules: context.rules
          })
        }, this.containerRef.current);

        if (localizable) {
          this._localeChangedHandler = Liferay.after('inputLocalized:localeChanged', this._onLocaleChange.bind(this));
        }
      }

      componentWillUnmount() {
        const {
          dataLayoutBuilderId
        } = this.props;
        const {
          formBuilderWithLayoutProvider
        } = this;

        if (formBuilderWithLayoutProvider) {
          formBuilderWithLayoutProvider.dispose();
        }

        if (this._localeChangedHandler) {
          this._localeChangedHandler.detach();
        }

        Liferay.destroyComponent(dataLayoutBuilderId);
      }

      dispatch(event, payload) {
        const layoutProvider = this.getLayoutProvider();

        if (layoutProvider && layoutProvider.dispatch) {
          layoutProvider.dispatch(event, payload);
        }
      }

      dispatchAction(action) {
        const {
          appContext
        } = this.props;
        const [, dispatch] = appContext;

        if (dispatch) {
          dispatch(action);
        }
      }

      emit(event, payload, error = false) {
        this.eventEmitter.emit(event, payload, error);
      }

      fieldNameGenerator(dataDefinitionFields) {
        const layoutProvider = this.getLayoutProvider();
        layoutProvider.props = _objectSpread(_objectSpread({}, layoutProvider.props), {}, {
          fieldNameGenerator: (desiredFieldName, currentFieldName, blacklist) => (0, _generateDataDefinitionFieldName.default)(dataDefinitionFields, desiredFieldName, currentFieldName, blacklist),
          shouldAutoGenerateName: () => false
        });
      }

      getDataDefinitionAndDataLayout(pages, rules) {
        const {
          defaultLanguageId = themeDisplay.getDefaultLanguageId()
        } = this.props;
        const availableLanguageIds = this.state.availableLanguageIds || this.props.availableLanguageIds || [themeDisplay.getDefaultLanguageId()];
        const fieldDefinitions = [];
        const pagesVisitor = new _dynamicDataMappingFormRenderer.PagesVisitor(pages);
        const newPages = pagesVisitor.mapFields(field => {
          fieldDefinitions.push(this.getDataDefinitionField(field, availableLanguageIds, defaultLanguageId));
          return field.fieldName;
        }, false);
        const layoutProvider = this.getLayoutProvider();
        return {
          definition: {
            availableLanguageIds,
            dataDefinitionFields: fieldDefinitions,
            defaultLanguageId
          },
          layout: {
            dataLayoutPages: newPages.map(page => {
              const rows = page.rows.map(row => {
                const columns = row.columns.map(column => {
                  return {
                    columnSize: column.size,
                    fieldNames: column.fields
                  };
                });
                return {
                  dataLayoutColumns: columns
                };
              });
              return {
                dataLayoutRows: rows,
                description: page.localizedDescription,
                title: page.localizedTitle
              };
            }),
            dataRules: rules.map(rule => {
              if (typeof rule.name === 'string') {
                rule.name = {
                  [defaultLanguageId]: rule.name
                };
              }

              delete rule.ruleEditedIndex;
              return rule;
            }),
            paginationMode: layoutProvider.getPaginationMode()
          }
        };
      }

      getDataDefinitionField({
        nestedFields = [],
        settingsContext
      }, availableLanguageIds = [], defaultLanguageId) {
        const fieldConfig = {
          customProperties: {},
          nestedDataDefinitionFields: nestedFields.map(nestedField => this.getDataDefinitionField(nestedField, availableLanguageIds, defaultLanguageId))
        };
        const settingsContextVisitor = new _dynamicDataMappingFormRenderer.PagesVisitor(settingsContext.pages);
        settingsContextVisitor.mapFields(({
          dataType,
          fieldName,
          localizable,
          localizedValue = {},
          value
        }) => {
          if (fieldName === 'predefinedValue') {
            fieldName = 'defaultValue';
          } else if (fieldName === 'type') {
            fieldName = 'fieldType';
          }

          if (localizable) {
            if (this.props.contentType !== 'app-builder') {
              availableLanguageIds.forEach(languageId => {
                if (!localizedValue[languageId]) {
                  localizedValue[languageId] = localizedValue[defaultLanguageId] || '';
                }
              });
            }

            if (this._isCustomProperty(fieldName)) {
              fieldConfig.customProperties[fieldName] = localizedValue;
            } else {
              fieldConfig[fieldName] = localizedValue;
            }
          } else {
            const formattedValue = this.getDataDefinitionFieldFormattedValue(dataType, value);

            if (this._isCustomProperty(fieldName)) {
              fieldConfig.customProperties[fieldName] = formattedValue;
            } else {
              fieldConfig[fieldName] = formattedValue;
            }
          }
        }, false);
        return fieldConfig;
      }

      getDataDefinitionFieldFormattedValue(dataType, value) {
        if (dataType === 'json' && typeof value !== 'string') {
          return JSON.stringify(value);
        }

        return value;
      }

      getDDMForm(dataDefinition, dataLayout = this.getDefaultDataLayout(dataDefinition)) {
        const {
          editingLanguageId = themeDisplay.getDefaultLanguageId()
        } = this.props;
        const {
          defaultLanguageId,
          name
        } = dataDefinition;
        return {
          description: dataDefinition.description[editingLanguageId],
          id: dataDefinition.id,
          localizedDescription: dataDefinition.description,
          localizedTitle: name,
          pages: dataLayout.dataLayoutPages.map(dataLayoutPage => ({
            rows: dataLayoutPage.dataLayoutRows.map(dataLayoutRow => ({
              columns: dataLayoutRow.dataLayoutColumns.map(({
                columnSize,
                fieldNames
              }) => ({
                fields: fieldNames.map(fieldName => this.getDDMFormField(dataDefinition, fieldName)),
                size: columnSize
              }))
            }))
          })),
          title: name[editingLanguageId] || name[defaultLanguageId]
        };
      }

      getDDMFormField(dataDefinition, fieldName) {
        const dataDefinitionField = (0, _dataDefinition.getDataDefinitionField)(dataDefinition, fieldName);

        if (dataDefinitionField.fieldType === 'ddm-text-html') {
          dataDefinitionField.fieldType = 'rich_text';
        }

        const {
          editingLanguageId = themeDisplay.getDefaultLanguageId()
        } = this.props;
        const settingsContext = this.getDDMFormFieldSettingsContext(dataDefinitionField);
        const ddmFormField = {
          nestedFields: dataDefinitionField.nestedDataDefinitionFields,
          settingsContext
        };
        const visitor = new _dynamicDataMappingFormRenderer.PagesVisitor(settingsContext.pages);
        visitor.mapFields(field => {
          const {
            fieldName
          } = field;
          let {
            value
          } = field;

          if (fieldName === 'options' && value) {
            value = value[editingLanguageId];
          } else if (fieldName === 'name') {
            ddmFormField.fieldName = value;
          }

          ddmFormField[fieldName] = value;
        });

        if (ddmFormField.nestedFields.length > 0) {
          ddmFormField.nestedFields = ddmFormField.nestedFields.map(nestedField => this.getDDMFormField(dataDefinition, nestedField.name));
        }

        if (!ddmFormField.instanceId) {
          ddmFormField.instanceId = _dynamicDataMappingFormBuilder.FieldSupport.generateInstanceId(8);
        }

        return ddmFormField;
      }

      getDDMFormFieldSettingsContext(dataDefinitionField) {
        const {
          editingLanguageId = themeDisplay.getDefaultLanguageId()
        } = this.props;
        const fieldTypes = this.getFieldTypes();
        const {
          settingsContext
        } = fieldTypes.find(({
          name
        }) => {
          return name === dataDefinitionField.fieldType;
        });
        const visitor = new _dynamicDataMappingFormRenderer.PagesVisitor(settingsContext.pages);
        return _objectSpread(_objectSpread({}, settingsContext), {}, {
          pages: visitor.mapFields(field => {
            const {
              fieldName,
              localizable
            } = field;

            const propertyValue = this._getDataDefinitionfieldPropertyValue(dataDefinitionField, this._fromDDMFormToDataDefinitionPropertyName(fieldName));

            let value = propertyValue || field.value;

            if (localizable && propertyValue && Object.prototype.hasOwnProperty.call(propertyValue, editingLanguageId) && fieldName !== 'label') {
              value = propertyValue[editingLanguageId];
            }

            let localizedValue = {};

            if (localizable) {
              localizedValue = _objectSpread({}, propertyValue);
            }

            let options = field.options;

            if (field.type === 'select' && field.fieldName === 'predefinedValue') {
              options = dataDefinitionField.customProperties.options[editingLanguageId];
            }

            return _objectSpread(_objectSpread({}, field), {}, {
              localizedValue,
              options,
              value
            });
          })
        });
      }

      getDefaultDataLayout(dataDefinition) {
        const {
          dataDefinitionFields
        } = dataDefinition;
        return {
          dataLayoutPages: [{
            dataLayoutRows: dataDefinitionFields.map(({
              name
            }) => ({
              dataLayoutColumns: [{
                columnSize: 12,
                fieldNames: [name]
              }]
            }))
          }]
        };
      }

      getFieldTypes() {
        const {
          fieldTypes
        } = this.props;
        return fieldTypes;
      }

      getFormData() {
        const {
          pages,
          rules
        } = this.getStore();
        return this.getDataDefinitionAndDataLayout(pages, rules || []);
      }

      getLayoutProvider() {
        const {
          layoutProvider
        } = this.formBuilderWithLayoutProvider.refs;
        return layoutProvider;
      }

      getState() {
        const {
          appContext
        } = this.props;
        const [state] = appContext;
        return state;
      }

      getStore() {
        const layoutProvider = this.getLayoutProvider();
        return _objectSpread({}, layoutProvider.state);
      }

      on(eventName, listener) {
        this.eventEmitter.on(eventName, listener);
      }

      onEditingLanguageIdChange({
        editingLanguageId,
        defaultLanguageId = themeDisplay.getDefaultLanguageId()
      }) {
        const layoutProvider = this.getLayoutProvider();
        const availableLanguageIds = [...new Set([...layoutProvider.props.availableLanguageIds, editingLanguageId])];
        const focusedField = layoutProvider.getFocusedField();
        this.setState({
          availableLanguageIds
        });
        const props = {
          availableLanguageIds,
          defaultLanguageId,
          editingLanguageId
        };
        layoutProvider.props = _objectSpread(_objectSpread({}, layoutProvider.props), props);
        this.formBuilderWithLayoutProvider.props.layoutProviderProps = _objectSpread(_objectSpread({}, this.formBuilderWithLayoutProvider.props.layoutProviderProps), props);
        this.formBuilderWithLayoutProvider.props.layoutProviderProps = this.formBuilderWithLayoutProvider.props.layoutProviderProps; // eslint-disable-line

        if (Object.keys(focusedField).length) {
          layoutProvider.getEvents().fieldClicked(_objectSpread({
            activePage: 0
          }, focusedField));
        }
      }

      removeEventListener(eventName, listener) {
        this.eventEmitter.removeListener(eventName, listener);
      }

      render() {
        const {
          sidebarOpen = false
        } = this.getState();
        return (/*#__PURE__*/_react.default.createElement("div", {
            className: (0, _classnames.default)('data-engine-form-builder ddm-form-builder', {
              'ddm-form-builder--sidebar-open': sidebarOpen
            })
          }, /*#__PURE__*/_react.default.createElement(_layout.default.Sheet, {
            ref: this.containerRef
          }))
        );
      }

      save(params = {}) {
        const {
          contentType,
          dataDefinitionId,
          dataLayoutId,
          groupId
        } = this.props;
        const {
          definition: dataDefinition,
          layout: dataLayout
        } = this.getFormData();
        return (0, _saveDefinitionAndLayout.default)({
          contentType,
          dataDefinition,
          dataDefinitionId,
          dataLayout,
          dataLayoutId,
          groupId,
          params
        });
      }

      serialize(pages, rules) {
        const {
          definition,
          layout
        } = this.getDataDefinitionAndDataLayout(pages, rules || []);
        return {
          definition: JSON.stringify(definition),
          layout: JSON.stringify(layout)
        };
      }

      _fromDataDefinitionToDDMFormPropertyName(propertyName) {
        return {
          defaultValue: 'predefinedValue',
          fieldType: 'type',
          name: 'fieldName',
          nestedDataDefinitionFields: 'nestedFields'
        }[propertyName] || propertyName;
      }

      _fromDDMFormToDataDefinitionPropertyName(propertyName) {
        return {
          fieldName: 'name',
          nestedFields: 'nestedDataDefinitionFields',
          predefinedValue: 'defaultValue',
          type: 'fieldType'
        }[propertyName] || propertyName;
      }

      _getDataDefinitionfieldPropertyValue(dataDefinitionField, propertyName) {
        const {
          customProperties
        } = dataDefinitionField;

        if (customProperties && this._isCustomProperty(propertyName)) {
          return customProperties[propertyName];
        }

        return dataDefinitionField[propertyName];
      }

      _isCustomProperty(name) {
        return ['defaultValue', 'fieldType', 'indexable', 'indexType', 'label', 'localizable', 'name', 'readOnly', 'repeatable', 'required', 'showLabel', 'tip'].indexOf(name) === -1;
      }

      _onLocaleChange(event) {
        const layoutProvider = this.getLayoutProvider();
        const selectedLanguageId = event.item.getAttribute('data-value');
        const {
          defaultLanguageId
        } = layoutProvider.props;
        this.onEditingLanguageIdChange({
          defaultLanguageId,
          editingLanguageId: selectedLanguageId
        });
      }

      _setContext(context) {
        const {
          config,
          defaultLanguageId
        } = this.props;
        const emptyLocalizableValue = {
          [defaultLanguageId]: ''
        };
        const pages = context.pages || [];

        if (!pages.length) {
          context = _objectSpread(_objectSpread({}, context), {}, {
            pages: [{
              description: '',
              localizedDescription: emptyLocalizableValue,
              localizedTitle: emptyLocalizableValue,
              rows: [],
              title: ''
            }],
            paginationMode: config.paginationMode || 'wizard',
            rules: context.rules || []
          });
        }

        return _objectSpread(_objectSpread({}, context), {}, {
          pages: context.pages.map(page => {
            let {
              description = '',
              localizedDescription,
              localizedTitle,
              title = ''
            } = page;
            description = description === null ? '' : description;
            title = title === null ? '' : title;

            if (!_metal.default.isString(description)) {
              description = description[defaultLanguageId];
              localizedDescription = {
                [defaultLanguageId]: description
              };
            }

            if (!_metal.default.isString(title)) {
              title = title[defaultLanguageId];
              localizedTitle = {
                [defaultLanguageId]: title
              };
            }

            return _objectSpread(_objectSpread({}, page), {}, {
              description,
              localizedDescription,
              localizedTitle,
              title
            });
          }),
          rules: context.rules || []
        });
      }

    }

    exports.DataLayoutBuilder = DataLayoutBuilder;
    var _default = DataLayoutBuilder;
    exports.default = _default;
    //# sourceMappingURL=DataLayoutBuilder.es.js.map
  }
});
//# sourceMappingURL=DataLayoutBuilder.es.js.map