Liferay.Loader.define("data-engine-taglib@2.5.34/data_layout_builder/js/data-layout-builder/DataLayoutBuilderContextProvider.es", ['module', 'exports', 'require', 'dynamic-data-mapping-form-renderer', 'frontend-js-react-web$react', '../AppContext.es', '../actions.es', '../drag-and-drop/getDropHandler.es', './DataLayoutBuilderContext.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;

    var _dynamicDataMappingFormRenderer = require("dynamic-data-mapping-form-renderer");

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _AppContext = _interopRequireDefault(require("../AppContext.es"));

    var _actions = require("../actions.es");

    var _getDropHandler = require("../drag-and-drop/getDropHandler.es");

    var _DataLayoutBuilderContext = _interopRequireDefault(require("./DataLayoutBuilderContext.es"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return { default: obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj.default = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * This library is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Lesser General Public License as published by the Free
     * Software Foundation; either version 2.1 of the License, or (at your option)
     * any later version.
     *
     * This library is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
     * details.
     */
    var _default = ({
      children,
      dataLayoutBuilder
    }) => {
      const [{
        dataDefinition
      }, dispatch] = (0, _react.useContext)(_AppContext.default);
      (0, _react.useEffect)(() => {
        const provider = dataLayoutBuilder.getLayoutProvider();
        const eventHandler = provider.on('editingLanguageIdChanged', ({
          newVal
        }) => {
          provider.once('rendered', () => {
            dispatch({
              payload: newVal,
              type: _actions.UPDATE_EDITING_LANGUAGE_ID
            });
          });
        });
        return () => eventHandler.removeListener();
      }, [dataLayoutBuilder, dispatch]);
      (0, _react.useEffect)(() => {
        const provider = dataLayoutBuilder.getLayoutProvider();
        const eventHandler = provider.on('focusedFieldChanged', ({
          newVal
        }) => {
          dispatch({
            payload: {
              focusedField: newVal
            },
            type: _actions.UPDATE_FOCUSED_FIELD
          });
        });
        return () => eventHandler.removeListener();
      }, [dataLayoutBuilder, dispatch]);
      (0, _react.useEffect)(() => {
        const provider = dataLayoutBuilder.getLayoutProvider();
        const eventHandler = provider.on('fieldHovered', newVal => {
          dispatch({
            payload: {
              hoveredField: newVal
            },
            type: _actions.UPDATE_HOVERED_FIELD
          });
        });
        return () => eventHandler.removeListener();
      }, [dataLayoutBuilder, dispatch]);
      (0, _react.useEffect)(() => {
        const provider = dataLayoutBuilder.getLayoutProvider();
        const eventHandler = provider.on('pagesChanged', ({
          newVal
        }) => {
          dispatch({
            payload: {
              pages: newVal
            },
            type: _actions.UPDATE_PAGES
          });
        });
        return () => eventHandler.removeListener();
      }, [dataLayoutBuilder, dispatch]);
      (0, _react.useEffect)(() => {
        const provider = dataLayoutBuilder.getLayoutProvider();
        const ruleAddedEventHandler = provider.on('ruleAdded', dataRule => {
          provider.once('rendered', () => {
            dispatch({
              payload: {
                dataRule
              },
              type: _actions.ADD_DATA_LAYOUT_RULE
            });
          });
        });
        const ruleEditedEventHandler = provider.on('ruleEdited', dataRule => {
          provider.once('rendered', () => {
            dispatch({
              payload: {
                dataRule
              },
              type: _actions.UPDATE_DATA_LAYOUT_RULE
            });
          });
        });
        return () => {
          ruleAddedEventHandler.removeListener();
          ruleEditedEventHandler.removeListener();
        };
      }, [dataLayoutBuilder, dispatch]);
      (0, _react.useEffect)(() => {
        const fieldTypes = dataLayoutBuilder.getFieldTypes();
        dispatch({
          payload: {
            fieldTypes
          },
          type: _actions.UPDATE_FIELD_TYPES
        });
      }, [dataLayoutBuilder, dispatch]);
      (0, _react.useEffect)(() => {
        const provider = dataLayoutBuilder.getLayoutProvider();
        const onDrop = (0, _getDropHandler.getDropHandler)({
          dataDefinition,
          dataLayoutBuilder
        });
        const eventHandler = provider.on(_dynamicDataMappingFormRenderer.EVENT_TYPES.FIELD_DROP, onDrop);
        return () => eventHandler.removeListener();
      }, [dataLayoutBuilder, dataDefinition]);
      return (/*#__PURE__*/_react.default.createElement(_DataLayoutBuilderContext.default.Provider, {
          value: [dataLayoutBuilder, dataLayoutBuilder.dispatch]
        }, children)
      );
    };

    exports.default = _default;
    //# sourceMappingURL=DataLayoutBuilderContextProvider.es.js.map
  }
});
//# sourceMappingURL=DataLayoutBuilderContextProvider.es.js.map