Liferay.Loader.define("data-engine-taglib@2.5.34/data_layout_builder/js/data-layout-builder/saveDefinitionAndLayout.es", ['module', 'exports', 'require', 'frontend-js-web'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = exports.updateItem = exports.addItem = exports.getURL = void 0;

    var _frontendJsWeb = require("frontend-js-web");

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });keys.push.apply(keys, symbols);
      }return keys;
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
          ownKeys(Object(source), true).forEach(function (key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function (key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }return target;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    const HEADERS = {
      Accept: 'application/json',
      'Accept-Language': Liferay.ThemeDisplay.getBCP47LanguageId(),
      'Content-Type': 'application/json'
    };

    const getURL = (path, params) => {
      params = _objectSpread({
        ['p_auth']: Liferay.authToken,
        t: Date.now()
      }, params);
      const uri = new URL("".concat(window.location.origin).concat(path));
      const keys = Object.keys(params);
      keys.forEach(key => uri.searchParams.set(key, params[key]));
      return uri.toString();
    };

    exports.getURL = getURL;

    const addItem = (endpoint, item) => (0, _frontendJsWeb.fetch)(getURL(endpoint), {
      body: JSON.stringify(item),
      headers: HEADERS,
      method: 'POST'
    }).then(response => response.json());

    exports.addItem = addItem;

    const updateItem = (endpoint, item, params) => (0, _frontendJsWeb.fetch)(getURL(endpoint, params), {
      body: JSON.stringify(item),
      headers: HEADERS,
      method: 'PUT'
    }).then(response => response.text()).then(text => text ? JSON.parse(text) : {});

    exports.updateItem = updateItem;

    var _default = ({
      contentType,
      dataDefinition,
      dataDefinitionId,
      dataLayout,
      groupId,
      params = {}
    }) => {
      const normalizedDataLayout = _objectSpread(_objectSpread({}, dataLayout), {}, {
        dataLayoutPages: dataLayout.dataLayoutPages.map(dataLayoutPage => _objectSpread(_objectSpread({}, dataLayoutPage), {}, {
          dataLayoutRows: (dataLayoutPage.dataLayoutRows || []).map(dataLayoutRow => _objectSpread(_objectSpread({}, dataLayoutRow), {}, {
            dataLayoutColumns: (dataLayoutRow.dataLayoutColumns || []).map(dataLayoutColumn => _objectSpread(_objectSpread({}, dataLayoutColumn), {}, {
              fieldNames: dataLayoutColumn.fieldNames || []
            }))
          })),
          description: dataLayoutPage.description || {
            [themeDisplay.getLanguageId()]: ''
          },
          title: dataLayoutPage.title || {
            [themeDisplay.getLanguageId()]: ''
          }
        }))
      }, params.dataLayout || {});

      return (() => {
        if (dataDefinitionId) {
          return updateItem("/o/data-engine/v2.0/data-definitions/".concat(dataDefinitionId), _objectSpread(_objectSpread(_objectSpread({}, dataDefinition), params.dataDefinition || {}), {}, {
            defaultDataLayout: normalizedDataLayout
          }));
        }

        let endpoint = "/o/data-engine/v2.0/data-definitions/by-content-type/".concat(contentType);

        if (groupId > 0) {
          endpoint = "/o/data-engine/v2.0/sites/".concat(groupId, "/data-definitions/by-content-type/").concat(contentType);
        }

        return addItem(endpoint, _objectSpread(_objectSpread(_objectSpread({}, dataDefinition), params.dataDefinition || {}), {}, {
          defaultDataLayout: normalizedDataLayout
        }));
      })();
    };

    exports.default = _default;
    //# sourceMappingURL=saveDefinitionAndLayout.es.js.map
  }
});
//# sourceMappingURL=saveDefinitionAndLayout.es.js.map