Liferay.Loader.define("data-engine-taglib@2.5.34/data_layout_builder/js/hooks/useHeightTransition.es", ['module', 'exports', 'require', 'frontend-js-react-web$react'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;

    var _react = require("frontend-js-react-web$react");

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * This library is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Lesser General Public License as published by the Free
     * Software Foundation; either version 2.1 of the License, or (at your option)
     * any later version.
     *
     * This library is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
     * details.
     */
    const removeCollapseHeight = collapseElementRef => {
      if (collapseElementRef && collapseElementRef.current) {
        collapseElementRef.current.style.removeProperty('height');
      }
    };

    const setCollapseHeight = collapseElementRef => {
      if (collapseElementRef && collapseElementRef.current) {
        const height = Array.prototype.slice.call(collapseElementRef.current.children).reduce((acc, child) => acc + child.clientHeight, 0);
        collapseElementRef.current.setAttribute('style', "height: ".concat(height, "px"));
      }
    };

    var _default = (visible, setVisible, contentRef) => {
      const [transitioning, setTransitioning] = (0, _react.useState)(false);
      (0, _react.useEffect)(() => {
        if (transitioning) {
          setCollapseHeight(contentRef);

          if (visible) {
            removeCollapseHeight(contentRef);
          }
        }
      }, [contentRef, transitioning, visible]);

      return [transitioning, event => {
        if (event.target === contentRef.current && transitioning && !visible) {
          setVisible(true);
          setTransitioning(false);
          removeCollapseHeight(contentRef);
        } else if (event.target === contentRef.current) {
          setVisible(false);
          setTransitioning(false);
        }
      }, event => {
        event.preventDefault();

        if (visible && !transitioning) {
          setCollapseHeight(contentRef);
        }

        if (!transitioning) {
          setTransitioning(true);
        }
      }];
    };

    exports.default = _default;
    //# sourceMappingURL=useHeightTransition.es.js.map
  }
});
//# sourceMappingURL=useHeightTransition.es.js.map