Liferay.Loader.define("data-engine-taglib@2.5.34/data_layout_builder/js/plugins/fields-sidebar/components/FieldsSidebarBody.es", ['module', 'exports', 'require', 'frontend-js-react-web$react', '../../../AppContext.es', '../../../actions.es', '../../../components/field-sets/FieldSets.es', '../../../components/field-types/FieldTypeList.es', '../../../components/sidebar/Sidebar.es', '../../../data-layout-builder/DataLayoutBuilderContext.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = _default;

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _AppContext = _interopRequireDefault(require("../../../AppContext.es"));

    var _actions = require("../../../actions.es");

    var _FieldSets = _interopRequireDefault(require("../../../components/field-sets/FieldSets.es"));

    var _FieldTypeList = _interopRequireDefault(require("../../../components/field-types/FieldTypeList.es"));

    var _Sidebar = _interopRequireDefault(require("../../../components/sidebar/Sidebar.es"));

    var _DataLayoutBuilderContext = _interopRequireDefault(require("../../../data-layout-builder/DataLayoutBuilderContext.es"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return { default: obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj.default = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * This library is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Lesser General Public License as published by the Free
     * Software Foundation; either version 2.1 of the License, or (at your option)
     * any later version.
     *
     * This library is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
     * details.
     */
    function _default({
      keywords,
      setKeywords
    }) {
      const [dataLayoutBuilder] = (0, _react.useContext)(_DataLayoutBuilderContext.default);
      const [{
        config: {
          allowFieldSets
        }
      }] = (0, _react.useContext)(_AppContext.default);

      const onDoubleClick = ({
        name
      }) => {
        const {
          activePage,
          pages
        } = dataLayoutBuilder.getStore();
        dataLayoutBuilder.dispatch('fieldAdded', (0, _actions.dropLayoutBuilderField)({
          addedToPlaceholder: true,
          dataLayoutBuilder,
          fieldTypeName: name,
          indexes: {
            columnIndex: 0,
            pageIndex: activePage,
            rowIndex: pages[activePage].rows.length
          }
        }));
      };

      const fieldTypes = dataLayoutBuilder.getFieldTypes().filter(({
        group
      }) => group === 'basic');
      fieldTypes.sort(({
        displayOrder: a
      }, {
        displayOrder: b
      }) => a - b);
      const tabs = [{
        label: Liferay.Language.get('fields'),
        render: () => /*#__PURE__*/_react.default.createElement(_FieldTypeList.default, {
          fieldTypes: fieldTypes,
          keywords: keywords,
          onDoubleClick: onDoubleClick
        })
      }];

      if (allowFieldSets) {
        tabs.push({
          label: Liferay.Language.get('fieldsets'),
          render: () => /*#__PURE__*/_react.default.createElement(_FieldSets.default, {
            keywords: keywords
          })
        });
      }

      return (/*#__PURE__*/_react.default.createElement(_Sidebar.default.Tabs, {
          setKeywords: setKeywords,
          tabs: tabs
        })
      );
    }
    //# sourceMappingURL=FieldsSidebarBody.es.js.map
  }
});
//# sourceMappingURL=FieldsSidebarBody.es.js.map