Liferay.Loader.define("data-engine-taglib@2.5.34/data_layout_builder/js/utils/client.es", ['module', 'exports', 'require', 'frontend-js-web'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.updateItem = exports.getItem = exports.request = exports.confirmDelete = exports.deleteItem = exports.addItem = exports.getURL = void 0;

    var _frontendJsWeb = require("frontend-js-web");

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });keys.push.apply(keys, symbols);
      }return keys;
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
          ownKeys(Object(source), true).forEach(function (key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function (key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }return target;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    const HEADERS = {
      Accept: 'application/json',
      'Accept-Language': Liferay.ThemeDisplay.getBCP47LanguageId(),
      'Content-Type': 'application/json'
    };

    function fetchItem(url, options) {
      return new Promise((resolve, reject) => {
        let isOk;
        (0, _frontendJsWeb.fetch)(url, options).then(response => {
          isOk = response.ok;
          return response.json();
        }).then(data => {
          if (isOk) {
            resolve(data);
          } else {
            reject(data);
          }
        }).catch(error => reject(error));
      });
    }

    const getURL = (path, params) => {
      params = _objectSpread({
        ['p_auth']: Liferay.authToken,
        t: Date.now()
      }, params);
      const uri = new URL("".concat(window.location.origin).concat(path));
      const keys = Object.keys(params);
      keys.forEach(key => uri.searchParams.set(key, params[key]));
      return uri.toString();
    };

    exports.getURL = getURL;

    const addItem = (endpoint, item) => fetchItem(getURL(endpoint), {
      body: JSON.stringify(item),
      headers: HEADERS,
      method: 'POST'
    });

    exports.addItem = addItem;

    const deleteItem = endpoint => {
      return (0, _frontendJsWeb.fetch)(getURL(endpoint), {
        method: 'DELETE'
      });
    };

    exports.deleteItem = deleteItem;

    const confirmDelete = endpoint => item => new Promise((resolve, reject) => {
      const confirmed = confirm(Liferay.Language.get('are-you-sure-you-want-to-delete-this'));

      if (confirmed) {
        deleteItem(endpoint + item.id).then(() => resolve(true)).catch(error => reject(error));
      } else {
        resolve(false);
      }
    });

    exports.confirmDelete = confirmDelete;

    const request = (endpoint, method = 'GET') => (0, _frontendJsWeb.fetch)(getURL(endpoint), {
      headers: HEADERS,
      method
    });

    exports.request = request;

    const getItem = endpoint => {
      return (0, _frontendJsWeb.fetch)(getURL(endpoint), {
        headers: HEADERS,
        method: 'GET'
      }).then(response => response.json());
    };

    exports.getItem = getItem;

    const updateItem = (endpoint, item, params) => fetchItem(getURL(endpoint, params), {
      body: JSON.stringify(item),
      headers: HEADERS,
      method: 'PUT'
    });

    exports.updateItem = updateItem;
    //# sourceMappingURL=client.es.js.map
  }
});
//# sourceMappingURL=client.es.js.map